/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.Decryptor;
import ai2.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai2.org.apache.poi.poifs.crypt.EncryptionMode;
import ai2.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai2.org.apache.poi.poifs.crypt.Encryptor;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndianInput;
import java.io.IOException;

public class EncryptionInfo {
    private final int versionMajor;
    private final int versionMinor;
    private final int encryptionFlags;
    private final EncryptionHeader header;
    private final EncryptionVerifier verifier;
    private final Decryptor decryptor;
    private final Encryptor encryptor;
    public static final BitField flagCryptoAPI = BitFieldFactory.getInstance(4);
    public static final BitField flagDocProps = BitFieldFactory.getInstance(8);
    public static final BitField flagExternal = BitFieldFactory.getInstance(16);
    public static final BitField flagAES = BitFieldFactory.getInstance(32);

    public EncryptionInfo(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public EncryptionInfo(OPOIFSFileSystem oPOIFSFileSystem) throws IOException {
        this(oPOIFSFileSystem.getRoot());
    }

    public EncryptionInfo(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    public EncryptionInfo(DirectoryNode directoryNode) throws IOException {
        this(directoryNode.createDocumentInputStream("EncryptionInfo"), false);
    }

    public EncryptionInfo(LittleEndianInput littleEndianInput, boolean bl) throws IOException {
        EncryptionInfoBuilder encryptionInfoBuilder;
        EncryptionMode encryptionMode;
        this.versionMajor = littleEndianInput.readShort();
        this.versionMinor = littleEndianInput.readShort();
        if (!bl && this.versionMajor == EncryptionMode.binaryRC4.versionMajor && this.versionMinor == EncryptionMode.binaryRC4.versionMinor) {
            encryptionMode = EncryptionMode.binaryRC4;
            this.encryptionFlags = -1;
        } else if (!bl && this.versionMajor == EncryptionMode.agile.versionMajor && this.versionMinor == EncryptionMode.agile.versionMinor) {
            encryptionMode = EncryptionMode.agile;
            this.encryptionFlags = littleEndianInput.readInt();
        } else if (!bl && 2 <= this.versionMajor && this.versionMajor <= 4 && this.versionMinor == EncryptionMode.standard.versionMinor) {
            encryptionMode = EncryptionMode.standard;
            this.encryptionFlags = littleEndianInput.readInt();
        } else if (bl && 2 <= this.versionMajor && this.versionMajor <= 4 && this.versionMinor == EncryptionMode.cryptoAPI.versionMinor) {
            encryptionMode = EncryptionMode.cryptoAPI;
            this.encryptionFlags = littleEndianInput.readInt();
        } else {
            this.encryptionFlags = littleEndianInput.readInt();
            throw new EncryptedDocumentException("Unknown encryption: version major: " + this.versionMajor + " / version minor: " + this.versionMinor + " / fCrypto: " + flagCryptoAPI.isSet(this.encryptionFlags) + " / fExternal: " + flagExternal.isSet(this.encryptionFlags) + " / fDocProps: " + flagDocProps.isSet(this.encryptionFlags) + " / fAES: " + flagAES.isSet(this.encryptionFlags));
        }
        try {
            encryptionInfoBuilder = EncryptionInfo.getBuilder(encryptionMode);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        encryptionInfoBuilder.initialize(this, littleEndianInput);
        this.header = encryptionInfoBuilder.getHeader();
        this.verifier = encryptionInfoBuilder.getVerifier();
        this.decryptor = encryptionInfoBuilder.getDecryptor();
        this.encryptor = encryptionInfoBuilder.getEncryptor();
    }

    @Deprecated
    public EncryptionInfo(POIFSFileSystem pOIFSFileSystem, EncryptionMode encryptionMode) {
        this(encryptionMode);
    }

    @Deprecated
    public EncryptionInfo(NPOIFSFileSystem nPOIFSFileSystem, EncryptionMode encryptionMode) {
        this(encryptionMode);
    }

    @Deprecated
    public EncryptionInfo(DirectoryNode directoryNode, EncryptionMode encryptionMode) {
        this(encryptionMode);
    }

    @Deprecated
    public EncryptionInfo(POIFSFileSystem pOIFSFileSystem, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this(encryptionMode, cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
    }

    @Deprecated
    public EncryptionInfo(NPOIFSFileSystem nPOIFSFileSystem, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this(encryptionMode, cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
    }

    @Deprecated
    public EncryptionInfo(DirectoryNode directoryNode, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this(encryptionMode, cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
    }

    public EncryptionInfo(EncryptionMode encryptionMode) {
        this(encryptionMode, null, null, -1, -1, null);
    }

    public EncryptionInfo(EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        EncryptionInfoBuilder encryptionInfoBuilder;
        this.versionMajor = encryptionMode.versionMajor;
        this.versionMinor = encryptionMode.versionMinor;
        this.encryptionFlags = encryptionMode.encryptionFlags;
        try {
            encryptionInfoBuilder = EncryptionInfo.getBuilder(encryptionMode);
        }
        catch (Exception exception) {
            throw new EncryptedDocumentException(exception);
        }
        encryptionInfoBuilder.initialize(this, cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.header = encryptionInfoBuilder.getHeader();
        this.verifier = encryptionInfoBuilder.getVerifier();
        this.decryptor = encryptionInfoBuilder.getDecryptor();
        this.encryptor = encryptionInfoBuilder.getEncryptor();
    }

    protected static EncryptionInfoBuilder getBuilder(EncryptionMode encryptionMode) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        EncryptionInfoBuilder encryptionInfoBuilder = (EncryptionInfoBuilder)classLoader.loadClass(encryptionMode.builder).newInstance();
        return encryptionInfoBuilder;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getEncryptionFlags() {
        return this.encryptionFlags;
    }

    public EncryptionHeader getHeader() {
        return this.header;
    }

    public EncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public Decryptor getDecryptor() {
        return this.decryptor;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }
}

