/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.poifs.crypt.ChainingMode;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.nio.charset.Charset;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class CryptoFunctions {
    private static final int[] InitialCodeArray = new int[]{57840, 7439, 52380, 33984, 4364, 3600, 61902, 12606, 6258, 57657, 54287, 34041, 10252, 43370, 20163};
    private static final byte[] PadArray = new byte[]{-69, -1, -1, -70, -1, -1, -71, -128, 0, -66, 15, 0, -65, 15, 0};
    private static final int[][] EncryptionMatrix = new int[][]{{44796, 19929, 39858, 10053, 20106, 40212, 10761}, {31585, 63170, 64933, 60267, 50935, 40399, 11199}, {17763, 35526, 1453, 2906, 5812, 11624, 23248}, {885, 1770, 3540, 7080, 14160, 28320, 56640}, {55369, 41139, 20807, 41614, 21821, 43642, 17621}, {28485, 56970, 44341, 19019, 38038, 14605, 29210}, {60195, 50791, 40175, 10751, 21502, 43004, 24537}, {18387, 36774, 3949, 7898, 15796, 31592, 63184}, {47201, 24803, 49606, 37805, 14203, 28406, 56812}, {17824, 35648, 1697, 3394, 6788, 13576, 27152}, {43601, 17539, 35078, 557, 1114, 2228, 4456}, {30388, 60776, 51953, 34243, 7079, 14158, 28316}, {14128, 28256, 56512, 43425, 17251, 34502, 7597}, {13105, 26210, 52420, 35241, 883, 1766, 3532}, {4129, 8258, 16516, 33032, 4657, 9314, 18628}};

    public static byte[] hashPassword(String string, HashAlgorithm hashAlgorithm, byte[] byArray, int n) {
        return CryptoFunctions.hashPassword(string, hashAlgorithm, byArray, n, true);
    }

    public static byte[] hashPassword(String string, HashAlgorithm hashAlgorithm, byte[] byArray, int n, boolean bl) {
        if (string == null) {
            string = "VelvetSweatshop";
        }
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest(StringUtil.getToUnicodeLE(string));
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = bl ? byArray3 : byArray2;
        byte[] byArray5 = bl ? byArray2 : byArray3;
        try {
            for (int i = 0; i < n; ++i) {
                LittleEndian.putInt(byArray3, 0, i);
                messageDigest.reset();
                messageDigest.update(byArray4);
                messageDigest.update(byArray5);
                messageDigest.digest(byArray2, 0, byArray2.length);
            }
        }
        catch (DigestException digestException) {
            throw new EncryptedDocumentException("error in password hashing");
        }
        return byArray2;
    }

    public static byte[] generateIv(HashAlgorithm hashAlgorithm, byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = byArray;
        if (byArray2 != null) {
            MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
            messageDigest.update(byArray);
            byArray3 = messageDigest.digest(byArray2);
        }
        return CryptoFunctions.getBlock36(byArray3, n);
    }

    public static byte[] generateKey(byte[] byArray, HashAlgorithm hashAlgorithm, byte[] byArray2, int n) {
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(hashAlgorithm);
        messageDigest.update(byArray);
        byte[] byArray3 = messageDigest.digest(byArray2);
        return CryptoFunctions.getBlock36(byArray3, n);
    }

    public static Cipher getCipher(SecretKey secretKey, CipherAlgorithm cipherAlgorithm, ChainingMode chainingMode, byte[] byArray, int n) {
        return CryptoFunctions.getCipher(secretKey, cipherAlgorithm, chainingMode, byArray, n, null);
    }

    public static Cipher getCipher(Key key, CipherAlgorithm cipherAlgorithm, ChainingMode chainingMode, byte[] byArray, int n, String string) {
        int n2 = key.getEncoded().length;
        if (string == null) {
            string = "NoPadding";
        }
        try {
            Cipher cipher;
            if (Cipher.getMaxAllowedKeyLength(cipherAlgorithm.jceId) < n2 * 8) {
                throw new EncryptedDocumentException("Export Restrictions in place - please install JCE Unlimited Strength Jurisdiction Policy files");
            }
            if (cipherAlgorithm == CipherAlgorithm.rc4) {
                cipher = Cipher.getInstance(cipherAlgorithm.jceId);
            } else if (cipherAlgorithm.needsBouncyCastle) {
                CryptoFunctions.registerBouncyCastle();
                cipher = Cipher.getInstance(cipherAlgorithm.jceId + "/" + chainingMode.jceId + "/" + string, "BC");
            } else {
                cipher = Cipher.getInstance(cipherAlgorithm.jceId + "/" + chainingMode.jceId + "/" + string);
            }
            if (byArray == null) {
                cipher.init(n, key);
            } else {
                AlgorithmParameterSpec algorithmParameterSpec = cipherAlgorithm == CipherAlgorithm.rc2 ? new RC2ParameterSpec(key.getEncoded().length * 8, byArray) : new IvParameterSpec(byArray);
                cipher.init(n, key, algorithmParameterSpec);
            }
            return cipher;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException(generalSecurityException);
        }
    }

    public static byte[] getBlock36(byte[] byArray, int n) {
        return CryptoFunctions.getBlockX(byArray, n, (byte)54);
    }

    public static byte[] getBlock0(byte[] byArray, int n) {
        return CryptoFunctions.getBlockX(byArray, n, (byte)0);
    }

    private static byte[] getBlockX(byte[] byArray, int n, byte by) {
        if (byArray.length == n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        Arrays.fill(byArray2, by);
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray2.length, byArray.length));
        return byArray2;
    }

    public static MessageDigest getMessageDigest(HashAlgorithm hashAlgorithm) {
        try {
            if (hashAlgorithm.needsBouncyCastle) {
                CryptoFunctions.registerBouncyCastle();
                return MessageDigest.getInstance(hashAlgorithm.jceId, "BC");
            }
            return MessageDigest.getInstance(hashAlgorithm.jceId);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException("hash algo not supported", generalSecurityException);
        }
    }

    public static Mac getMac(HashAlgorithm hashAlgorithm) {
        try {
            if (hashAlgorithm.needsBouncyCastle) {
                CryptoFunctions.registerBouncyCastle();
                return Mac.getInstance(hashAlgorithm.jceHmacId, "BC");
            }
            return Mac.getInstance(hashAlgorithm.jceHmacId);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedDocumentException("hmac algo not supported", generalSecurityException);
        }
    }

    public static void registerBouncyCastle() {
        if (Security.getProvider("BC") != null) {
            return;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String string = "org.bouncycastle.jce.provider.BouncyCastleProvider";
            Class<?> clazz = classLoader.loadClass(string);
            Security.addProvider((Provider)clazz.newInstance());
        }
        catch (Exception exception) {
            throw new EncryptedDocumentException("Only the BouncyCastle provider supports your encryption settings - please add it to the classpath.");
        }
    }

    public static int createXorVerifier2(String string) {
        byte[] byArray = new byte[4];
        if (!"".equals(string)) {
            int n;
            int n2;
            short s;
            int n3;
            string = string.substring(0, Math.min(string.length(), 15));
            byte[] byArray2 = new byte[string.length()];
            for (n3 = 0; n3 < string.length(); ++n3) {
                s = string.charAt(n3);
                n2 = s & 0xFF;
                n = (s & 0xFF00) >> 8;
                byArray2[n3] = n2 != 0 ? n2 : (int)n;
            }
            n3 = InitialCodeArray[byArray2.length - 1];
            for (s = 0; s < byArray2.length; ++s) {
                n2 = 15 - byArray2.length + s;
                for (n = 0; n < 7; ++n) {
                    if ((byArray2[s] & 1 << n) == 0) continue;
                    n3 ^= EncryptionMatrix[n2][n];
                }
            }
            s = 0;
            for (n2 = byArray2.length - 1; n2 >= 0; --n2) {
                s = CryptoFunctions.rotateLeftBase15Bit(s);
                s = (short)(s ^ byArray2[n2]);
            }
            s = CryptoFunctions.rotateLeftBase15Bit(s);
            s = (short)(s ^ byArray2.length);
            s = (short)(s ^ 0xCE4B);
            LittleEndian.putShort(byArray, 0, s);
            LittleEndian.putShort(byArray, 2, (short)n3);
        }
        return LittleEndian.getInt(byArray);
    }

    public static String xorHashPassword(String string) {
        int n = CryptoFunctions.createXorVerifier2(string);
        return String.format(Locale.ROOT, "%1$08X", n);
    }

    public static String xorHashPasswordReversed(String string) {
        int n = CryptoFunctions.createXorVerifier2(string);
        return String.format(Locale.ROOT, "%1$02X%2$02X%3$02X%4$02X", n >>> 0 & 0xFF, n >>> 8 & 0xFF, n >>> 16 & 0xFF, n >>> 24 & 0xFF);
    }

    public static int createXorVerifier1(String string) {
        return CryptoFunctions.createXorVerifier2(string) & 0xFFFF;
    }

    public static int createXorKey1(String string) {
        return CryptoFunctions.createXorVerifier2(string) >>> 16;
    }

    public static byte[] createXorArray1(String string) {
        if (string.length() > 15) {
            string = string.substring(0, 15);
        }
        byte[] byArray = string.getBytes(Charset.forName("ASCII"));
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(PadArray, 0, byArray2, byArray.length, PadArray.length - byArray.length + 1);
        int n = CryptoFunctions.createXorKey1(string);
        int n2 = 2;
        byte[] byArray3 = new byte[]{(byte)(n & 0xFF), (byte)(n >>> 8 & 0xFF)};
        for (int i = 0; i < byArray2.length; ++i) {
            int n3 = i;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray3[i & 1]);
            byArray2[i] = CryptoFunctions.rotateLeft(byArray2[i], n2);
        }
        return byArray2;
    }

    private static byte rotateLeft(byte by, int n) {
        return (byte)((by & 0xFF) << n | (by & 0xFF) >>> 8 - n);
    }

    private static short rotateLeftBase15Bit(short s) {
        short s2 = (short)((s & 0x4000) != 0 ? 1 : 0);
        short s3 = (short)(s << 1 & Short.MAX_VALUE);
        short s4 = (short)(s2 | s3);
        return s4;
    }
}

