/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.poifs.crypt;

import ai2.org.apache.poi.EncryptedDocumentException;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

@Internal
public abstract class ChunkedCipherInputStream
extends LittleEndianInputStream {
    private final int chunkSize;
    private final int chunkMask;
    private final int chunkBits;
    private int _lastIndex = 0;
    private long _pos = 0L;
    private long _size;
    private byte[] _chunk;
    private Cipher _cipher;

    public ChunkedCipherInputStream(LittleEndianInput littleEndianInput, long l, int n) throws GeneralSecurityException {
        super((InputStream)((Object)littleEndianInput));
        this._size = l;
        this.chunkSize = n;
        this.chunkMask = n - 1;
        this.chunkBits = Integer.bitCount(this.chunkMask);
        this._cipher = this.initCipherForBlock(null, 0);
    }

    protected abstract Cipher initCipherForBlock(Cipher var1, int var2) throws GeneralSecurityException;

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray) == 1) {
            return byArray[0];
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.available() <= 0) {
            return -1;
        }
        while (n2 > 0) {
            if (this._chunk == null) {
                try {
                    this._chunk = this.nextChunk();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new EncryptedDocumentException(generalSecurityException.getMessage(), generalSecurityException);
                }
            }
            int n4 = (int)((long)this.chunkSize - (this._pos & (long)this.chunkMask));
            int n5 = this.available();
            if (n5 == 0) {
                return n3;
            }
            n4 = Math.min(n5, Math.min(n4, n2));
            System.arraycopy(this._chunk, (int)(this._pos & (long)this.chunkMask), byArray, n, n4);
            n += n4;
            n2 -= n4;
            this._pos += (long)n4;
            if ((this._pos & (long)this.chunkMask) == 0L) {
                this._chunk = null;
            }
            n3 += n4;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this._pos;
        long l3 = Math.min((long)this.available(), l);
        if (((this._pos + l3 ^ l2) & (long)(~this.chunkMask)) != 0L) {
            this._chunk = null;
        }
        this._pos += l3;
        return l3;
    }

    public int available() {
        return (int)(this._size - this._pos);
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int n) {
        throw new UnsupportedOperationException();
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    private byte[] nextChunk() throws GeneralSecurityException, IOException {
        int n = (int)(this._pos >> this.chunkBits);
        this.initCipherForBlock(this._cipher, n);
        if (this._lastIndex != n) {
            super.skip(n - this._lastIndex << this.chunkBits);
        }
        byte[] byArray = new byte[Math.min(super.available(), this.chunkSize)];
        super.read(byArray, 0, byArray.length);
        this._lastIndex = n + 1;
        return this._cipher.doFinal(byArray);
    }
}

