/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.util;

import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipSecureFile
extends ZipFile {
    private static POILogger logger = POILogFactory.getLogger(ZipSecureFile.class);
    private static double MIN_INFLATE_RATIO = 0.01;
    private static long MAX_ENTRY_SIZE = 0xFFFFFFFFL;

    public static void setMinInflateRatio(double d) {
        MIN_INFLATE_RATIO = d;
    }

    public static double getMinInflateRatio() {
        return MIN_INFLATE_RATIO;
    }

    public static void setMaxEntrySize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max entry size is bounded [0-4GB].");
        }
        MAX_ENTRY_SIZE = l;
    }

    public static long getMaxEntrySize() {
        return MAX_ENTRY_SIZE;
    }

    public ZipSecureFile(File file, int n) throws IOException {
        super(file, n);
    }

    public ZipSecureFile(File file) throws ZipException, IOException {
        super(file);
    }

    public ZipSecureFile(String string) throws IOException {
        super(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        InputStream inputStream = super.getInputStream(zipEntry);
        return ZipSecureFile.addThreshold(inputStream);
    }

    public static ThresholdInputStream addThreshold(InputStream inputStream) throws IOException {
        ThresholdInputStream thresholdInputStream;
        if (inputStream instanceof InflaterInputStream) {
            try {
                Field field = FilterInputStream.class.getDeclaredField("in");
                field.setAccessible(true);
                InputStream inputStream2 = (InputStream)field.get(inputStream);
                thresholdInputStream = new ThresholdInputStream(inputStream2, null);
                field.set(inputStream, thresholdInputStream);
            }
            catch (Exception exception) {
                logger.log(5, new Object[]{"SecurityManager doesn't allow manipulation via reflection for zipbomb detection - continue with original input stream", exception});
                thresholdInputStream = null;
            }
        } else {
            thresholdInputStream = null;
        }
        return new ThresholdInputStream(inputStream, thresholdInputStream);
    }

    public static class ThresholdInputStream
    extends PushbackInputStream {
        long counter = 0L;
        ThresholdInputStream cis;

        public ThresholdInputStream(InputStream inputStream, ThresholdInputStream thresholdInputStream) {
            super(inputStream, 1);
            this.cis = thresholdInputStream;
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n > -1) {
                this.advance(1);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 > -1) {
                this.advance(n3);
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            this.counter = 0L;
            return this.in.skip(l);
        }

        public synchronized void reset() throws IOException {
            this.counter = 0L;
            this.in.reset();
        }

        public void advance(int n) throws IOException {
            this.counter += (long)n;
            if (this.counter < MAX_ENTRY_SIZE) {
                if (this.cis == null) {
                    return;
                }
                double d = (double)this.cis.counter / (double)this.counter;
                if (d >= MIN_INFLATE_RATIO) {
                    return;
                }
            }
            throw new IOException("Zip bomb detected! The file would exceed certain limits which usually indicate that the file is used to inflate memory usage and thus could pose a security risk. You can adjust these limits via setMinInflateRatio() and setMaxEntrySize() if you need to work with files which exceed these limits. Counter: " + this.counter + ", cis.counter: " + (this.cis == null ? 0L : this.cis.counter) + ", ratio: " + (this.cis == null ? 0.0 : (double)this.cis.counter / (double)this.counter) + "Limits: MIN_INFLATE_RATIO: " + MIN_INFLATE_RATIO + ", MAX_ENTRY_SIZE: " + MAX_ENTRY_SIZE);
        }

        public ZipEntry getNextEntry() throws IOException {
            if (!(this.in instanceof ZipInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a ZipInputStream");
            }
            this.counter = 0L;
            return ((ZipInputStream)this.in).getNextEntry();
        }

        public void closeEntry() throws IOException {
            if (!(this.in instanceof ZipInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a ZipInputStream");
            }
            this.counter = 0L;
            ((ZipInputStream)this.in).closeEntry();
        }

        public void unread(int n) throws IOException {
            if (!(this.in instanceof PushbackInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a PushbackInputStream");
            }
            if (--this.counter < 0L) {
                this.counter = 0L;
            }
            ((PushbackInputStream)this.in).unread(n);
        }

        public void unread(byte[] byArray, int n, int n2) throws IOException {
            if (!(this.in instanceof PushbackInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a PushbackInputStream");
            }
            this.counter -= (long)n2;
            if (--this.counter < 0L) {
                this.counter = 0L;
            }
            ((PushbackInputStream)this.in).unread(byArray, n, n2);
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public synchronized void mark(int n) {
            this.in.mark(n);
        }
    }
}

