/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal.marshallers;

import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import ai2.org.apache.poi.openxml4j.opc.internal.PartMarshaller;
import ai2.org.apache.poi.openxml4j.util.Nullable;
import ai2.org.apache.poi.util.DocumentHelper;
import java.io.OutputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagePropertiesMarshaller
implements PartMarshaller {
    private static final Namespace namespaceDC;
    private static final Namespace namespaceCoreProperties;
    private static final Namespace namespaceDcTerms;
    private static final Namespace namespaceXSI;
    protected static final String KEYWORD_CATEGORY = "category";
    protected static final String KEYWORD_CONTENT_STATUS = "contentStatus";
    protected static final String KEYWORD_CONTENT_TYPE = "contentType";
    protected static final String KEYWORD_CREATED = "created";
    protected static final String KEYWORD_CREATOR = "creator";
    protected static final String KEYWORD_DESCRIPTION = "description";
    protected static final String KEYWORD_IDENTIFIER = "identifier";
    protected static final String KEYWORD_KEYWORDS = "keywords";
    protected static final String KEYWORD_LANGUAGE = "language";
    protected static final String KEYWORD_LAST_MODIFIED_BY = "lastModifiedBy";
    protected static final String KEYWORD_LAST_PRINTED = "lastPrinted";
    protected static final String KEYWORD_MODIFIED = "modified";
    protected static final String KEYWORD_REVISION = "revision";
    protected static final String KEYWORD_SUBJECT = "subject";
    protected static final String KEYWORD_TITLE = "title";
    protected static final String KEYWORD_VERSION = "version";
    PackagePropertiesPart propsPart;
    Document xmlDoc = null;

    @Override
    public boolean marshall(PackagePart packagePart, OutputStream outputStream) throws OpenXML4JException {
        if (!(packagePart instanceof PackagePropertiesPart)) {
            throw new IllegalArgumentException("'part' must be a PackagePropertiesPart instance.");
        }
        this.propsPart = (PackagePropertiesPart)packagePart;
        this.xmlDoc = DocumentHelper.createDocument();
        Element element = this.xmlDoc.createElementNS(namespaceCoreProperties.getNamespaceURI(), this.getQName("coreProperties", namespaceCoreProperties));
        DocumentHelper.addNamespaceDeclaration(element, namespaceCoreProperties);
        DocumentHelper.addNamespaceDeclaration(element, namespaceDC);
        DocumentHelper.addNamespaceDeclaration(element, namespaceDcTerms);
        DocumentHelper.addNamespaceDeclaration(element, namespaceXSI);
        this.xmlDoc.appendChild(element);
        this.addCategory();
        this.addContentStatus();
        this.addContentType();
        this.addCreated();
        this.addCreator();
        this.addDescription();
        this.addIdentifier();
        this.addKeywords();
        this.addLanguage();
        this.addLastModifiedBy();
        this.addLastPrinted();
        this.addModified();
        this.addRevision();
        this.addSubject();
        this.addTitle();
        this.addVersion();
        return true;
    }

    private Element setElementTextContent(String string, Namespace namespace, Nullable<String> nullable) {
        return this.setElementTextContent(string, namespace, nullable, nullable.getValue());
    }

    private String getQName(String string, Namespace namespace) {
        return namespace.getPrefix().isEmpty() ? string : namespace.getPrefix() + ':' + string;
    }

    private Element setElementTextContent(String string, Namespace namespace, Nullable<?> nullable, String string2) {
        if (!nullable.hasValue()) {
            return null;
        }
        Element element = this.xmlDoc.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(namespace.getNamespaceURI(), string).item(0);
        if (element2 == null) {
            element2 = this.xmlDoc.createElementNS(namespace.getNamespaceURI(), this.getQName(string, namespace));
            element.appendChild(element2);
        }
        element2.setTextContent(string2);
        return element2;
    }

    private Element setElementTextContent(String string, Namespace namespace, Nullable<?> nullable, String string2, String string3) {
        Element element = this.setElementTextContent(string, namespace, nullable, string2);
        if (element != null) {
            element.setAttributeNS(namespaceXSI.getNamespaceURI(), this.getQName("type", namespaceXSI), string3);
        }
        return element;
    }

    private void addCategory() {
        this.setElementTextContent(KEYWORD_CATEGORY, namespaceCoreProperties, this.propsPart.getCategoryProperty());
    }

    private void addContentStatus() {
        this.setElementTextContent(KEYWORD_CONTENT_STATUS, namespaceCoreProperties, this.propsPart.getContentStatusProperty());
    }

    private void addContentType() {
        this.setElementTextContent(KEYWORD_CONTENT_TYPE, namespaceCoreProperties, this.propsPart.getContentTypeProperty());
    }

    private void addCreated() {
        this.setElementTextContent(KEYWORD_CREATED, namespaceDcTerms, this.propsPart.getCreatedProperty(), this.propsPart.getCreatedPropertyString(), "dcterms:W3CDTF");
    }

    private void addCreator() {
        this.setElementTextContent(KEYWORD_CREATOR, namespaceDC, this.propsPart.getCreatorProperty());
    }

    private void addDescription() {
        this.setElementTextContent(KEYWORD_DESCRIPTION, namespaceDC, this.propsPart.getDescriptionProperty());
    }

    private void addIdentifier() {
        this.setElementTextContent(KEYWORD_IDENTIFIER, namespaceDC, this.propsPart.getIdentifierProperty());
    }

    private void addKeywords() {
        this.setElementTextContent(KEYWORD_KEYWORDS, namespaceCoreProperties, this.propsPart.getKeywordsProperty());
    }

    private void addLanguage() {
        this.setElementTextContent(KEYWORD_LANGUAGE, namespaceDC, this.propsPart.getLanguageProperty());
    }

    private void addLastModifiedBy() {
        this.setElementTextContent(KEYWORD_LAST_MODIFIED_BY, namespaceCoreProperties, this.propsPart.getLastModifiedByProperty());
    }

    private void addLastPrinted() {
        this.setElementTextContent(KEYWORD_LAST_PRINTED, namespaceCoreProperties, this.propsPart.getLastPrintedProperty(), this.propsPart.getLastPrintedPropertyString());
    }

    private void addModified() {
        this.setElementTextContent(KEYWORD_MODIFIED, namespaceDcTerms, this.propsPart.getModifiedProperty(), this.propsPart.getModifiedPropertyString(), "dcterms:W3CDTF");
    }

    private void addRevision() {
        this.setElementTextContent(KEYWORD_REVISION, namespaceCoreProperties, this.propsPart.getRevisionProperty());
    }

    private void addSubject() {
        this.setElementTextContent(KEYWORD_SUBJECT, namespaceDC, this.propsPart.getSubjectProperty());
    }

    private void addTitle() {
        this.setElementTextContent(KEYWORD_TITLE, namespaceDC, this.propsPart.getTitleProperty());
    }

    private void addVersion() {
        this.setElementTextContent(KEYWORD_VERSION, namespaceCoreProperties, this.propsPart.getVersionProperty());
    }

    static {
        XMLEventFactory xMLEventFactory = XMLEventFactory.newInstance();
        namespaceDC = xMLEventFactory.createNamespace("dc", "http://purl.org/dc/elements/1.1/");
        namespaceCoreProperties = xMLEventFactory.createNamespace("cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
        namespaceDcTerms = xMLEventFactory.createNamespace("dcterms", "http://purl.org/dc/terms/");
        namespaceXSI = xMLEventFactory.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }
}

