/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal;

import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.ZipPackage;
import ai2.org.apache.poi.openxml4j.util.ZipSecureFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ZipHelper {
    private static final String FORWARD_SLASH = "/";
    public static final int READ_WRITE_FILE_BUFFER_SIZE = 8192;

    private ZipHelper() {
    }

    public static ZipEntry getCorePropertiesZipEntry(ZipPackage zipPackage) {
        PackageRelationship packageRelationship = zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties").getRelationship(0);
        if (packageRelationship == null) {
            return null;
        }
        return new ZipEntry(packageRelationship.getTargetURI().getPath());
    }

    public static ZipEntry getContentTypeZipEntry(ZipPackage zipPackage) {
        Enumeration<? extends ZipEntry> enumeration = zipPackage.getZipArchive().getEntries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().equals("[Content_Types].xml")) continue;
            return zipEntry;
        }
        return null;
    }

    public static String getOPCNameFromZipItemName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("zipItemName");
        }
        if (string.startsWith(FORWARD_SLASH)) {
            return string;
        }
        return FORWARD_SLASH + string;
    }

    public static String getZipItemNameFromOPCName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("opcItemName");
        }
        String string2 = string;
        while (string2.startsWith(FORWARD_SLASH)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static URI getZipURIFromOPCName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("opcItemName");
        }
        String string2 = string;
        while (string2.startsWith(FORWARD_SLASH)) {
            string2 = string2.substring(1);
        }
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static ZipFile openZipFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        return new ZipSecureFile(file);
    }

    public static ZipFile openZipFile(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        return new ZipSecureFile(file);
    }
}

