/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.StreamHelper;
import ai2.org.apache.poi.openxml4j.opc.internal.ContentTypeManager;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;

public class ZipContentTypeManager
extends ContentTypeManager {
    private static POILogger logger = POILogFactory.getLogger(ZipContentTypeManager.class);

    public ZipContentTypeManager(InputStream inputStream, OPCPackage oPCPackage) throws InvalidFormatException {
        super(inputStream, oPCPackage);
    }

    public boolean saveImpl(Document document, OutputStream outputStream) {
        ZipOutputStream zipOutputStream = null;
        zipOutputStream = outputStream instanceof ZipOutputStream ? (ZipOutputStream)outputStream : new ZipOutputStream(outputStream);
        ZipEntry zipEntry = new ZipEntry("[Content_Types].xml");
        try {
            zipOutputStream.putNextEntry(zipEntry);
            if (!StreamHelper.saveXmlInStream(document, zipOutputStream)) {
                return false;
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException iOException) {
            logger.log(7, new Object[]{"Cannot write: [Content_Types].xml in Zip !", iOException});
            return false;
        }
        return true;
    }
}

