/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageProperties;
import ai2.org.apache.poi.openxml4j.util.Nullable;
import ai2.org.apache.poi.util.LocaleUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackagePropertiesPart
extends PackagePart
implements PackageProperties {
    public static final String NAMESPACE_DC_URI = "http://purl.org/dc/elements/1.1/";
    public static final String NAMESPACE_CP_URI = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    public static final String NAMESPACE_DCTERMS_URI = "http://purl.org/dc/terms/";
    protected Nullable<String> category = new Nullable();
    protected Nullable<String> contentStatus = new Nullable();
    protected Nullable<String> contentType = new Nullable();
    protected Nullable<Date> created = new Nullable();
    protected Nullable<String> creator = new Nullable();
    protected Nullable<String> description = new Nullable();
    protected Nullable<String> identifier = new Nullable();
    protected Nullable<String> keywords = new Nullable();
    protected Nullable<String> language = new Nullable();
    protected Nullable<String> lastModifiedBy = new Nullable();
    protected Nullable<Date> lastPrinted = new Nullable();
    protected Nullable<Date> modified = new Nullable();
    protected Nullable<String> revision = new Nullable();
    protected Nullable<String> subject = new Nullable();
    protected Nullable<String> title = new Nullable();
    protected Nullable<String> version = new Nullable();

    public PackagePropertiesPart(OPCPackage oPCPackage, PackagePartName packagePartName) throws InvalidFormatException {
        super(oPCPackage, packagePartName, "application/vnd.openxmlformats-package.core-properties+xml");
    }

    @Override
    public Nullable<String> getCategoryProperty() {
        return this.category;
    }

    @Override
    public Nullable<String> getContentStatusProperty() {
        return this.contentStatus;
    }

    @Override
    public Nullable<String> getContentTypeProperty() {
        return this.contentType;
    }

    @Override
    public Nullable<Date> getCreatedProperty() {
        return this.created;
    }

    public String getCreatedPropertyString() {
        return this.getDateValue(this.created);
    }

    @Override
    public Nullable<String> getCreatorProperty() {
        return this.creator;
    }

    @Override
    public Nullable<String> getDescriptionProperty() {
        return this.description;
    }

    @Override
    public Nullable<String> getIdentifierProperty() {
        return this.identifier;
    }

    @Override
    public Nullable<String> getKeywordsProperty() {
        return this.keywords;
    }

    @Override
    public Nullable<String> getLanguageProperty() {
        return this.language;
    }

    @Override
    public Nullable<String> getLastModifiedByProperty() {
        return this.lastModifiedBy;
    }

    @Override
    public Nullable<Date> getLastPrintedProperty() {
        return this.lastPrinted;
    }

    public String getLastPrintedPropertyString() {
        return this.getDateValue(this.lastPrinted);
    }

    @Override
    public Nullable<Date> getModifiedProperty() {
        return this.modified;
    }

    public String getModifiedPropertyString() {
        if (this.modified.hasValue()) {
            return this.getDateValue(this.modified);
        }
        return this.getDateValue(new Nullable<Date>(new Date()));
    }

    @Override
    public Nullable<String> getRevisionProperty() {
        return this.revision;
    }

    @Override
    public Nullable<String> getSubjectProperty() {
        return this.subject;
    }

    @Override
    public Nullable<String> getTitleProperty() {
        return this.title;
    }

    @Override
    public Nullable<String> getVersionProperty() {
        return this.version;
    }

    @Override
    public void setCategoryProperty(String string) {
        this.category = this.setStringValue(string);
    }

    @Override
    public void setContentStatusProperty(String string) {
        this.contentStatus = this.setStringValue(string);
    }

    @Override
    public void setContentTypeProperty(String string) {
        this.contentType = this.setStringValue(string);
    }

    @Override
    public void setCreatedProperty(String string) {
        try {
            this.created = this.setDateValue(string);
        }
        catch (InvalidFormatException invalidFormatException) {
            new IllegalArgumentException("created  : " + invalidFormatException.getLocalizedMessage());
        }
    }

    @Override
    public void setCreatedProperty(Nullable<Date> nullable) {
        if (nullable.hasValue()) {
            this.created = nullable;
        }
    }

    @Override
    public void setCreatorProperty(String string) {
        this.creator = this.setStringValue(string);
    }

    @Override
    public void setDescriptionProperty(String string) {
        this.description = this.setStringValue(string);
    }

    @Override
    public void setIdentifierProperty(String string) {
        this.identifier = this.setStringValue(string);
    }

    @Override
    public void setKeywordsProperty(String string) {
        this.keywords = this.setStringValue(string);
    }

    @Override
    public void setLanguageProperty(String string) {
        this.language = this.setStringValue(string);
    }

    @Override
    public void setLastModifiedByProperty(String string) {
        this.lastModifiedBy = this.setStringValue(string);
    }

    @Override
    public void setLastPrintedProperty(String string) {
        try {
            this.lastPrinted = this.setDateValue(string);
        }
        catch (InvalidFormatException invalidFormatException) {
            new IllegalArgumentException("lastPrinted  : " + invalidFormatException.getLocalizedMessage());
        }
    }

    @Override
    public void setLastPrintedProperty(Nullable<Date> nullable) {
        if (nullable.hasValue()) {
            this.lastPrinted = nullable;
        }
    }

    @Override
    public void setModifiedProperty(String string) {
        try {
            this.modified = this.setDateValue(string);
        }
        catch (InvalidFormatException invalidFormatException) {
            new IllegalArgumentException("modified  : " + invalidFormatException.getLocalizedMessage());
        }
    }

    @Override
    public void setModifiedProperty(Nullable<Date> nullable) {
        if (nullable.hasValue()) {
            this.modified = nullable;
        }
    }

    @Override
    public void setRevisionProperty(String string) {
        this.revision = this.setStringValue(string);
    }

    @Override
    public void setSubjectProperty(String string) {
        this.subject = this.setStringValue(string);
    }

    @Override
    public void setTitleProperty(String string) {
        this.title = this.setStringValue(string);
    }

    @Override
    public void setVersionProperty(String string) {
        this.version = this.setStringValue(string);
    }

    private Nullable<String> setStringValue(String string) {
        if (string == null || string.equals("")) {
            return new Nullable<String>();
        }
        return new Nullable<String>(string);
    }

    private Nullable<Date> setDateValue(String string) throws InvalidFormatException {
        if (string == null || string.equals("")) {
            return new Nullable<Date>();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        simpleDateFormat.setTimeZone(LocaleUtil.TIMEZONE_UTC);
        Date date = simpleDateFormat.parse(string, new ParsePosition(0));
        if (date == null) {
            throw new InvalidFormatException("Date not well formated");
        }
        return new Nullable<Date>(date);
    }

    private String getDateValue(Nullable<Date> nullable) {
        if (nullable == null) {
            return "";
        }
        Date date = nullable.getValue();
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        simpleDateFormat.setTimeZone(LocaleUtil.TIMEZONE_UTC);
        return simpleDateFormat.format(date);
    }

    @Override
    protected InputStream getInputStreamImpl() {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    protected OutputStream getOutputStreamImpl() {
        throw new InvalidOperationException("Can't use output stream to set properties !");
    }

    @Override
    public boolean save(OutputStream outputStream) {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    public boolean load(InputStream inputStream) {
        throw new InvalidOperationException("Operation not authorized. This part may only be manipulated using the getters and setters on PackagePropertiesPart");
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

