/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc.internal;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentType {
    private String type;
    private String subType;
    private Hashtable<String, String> parameters;
    private static final Pattern patternTypeSubType;
    private static final Pattern patternTypeSubTypeParams;
    private static final Pattern patternParams;

    public ContentType(String string) throws InvalidFormatException {
        Matcher matcher = patternTypeSubType.matcher(string);
        if (!matcher.matches()) {
            matcher = patternTypeSubTypeParams.matcher(string);
        }
        if (!matcher.matches()) {
            throw new InvalidFormatException("The specified content type '" + string + "' is not compliant with RFC 2616: malformed content type.");
        }
        if (matcher.groupCount() >= 2) {
            this.type = matcher.group(1);
            this.subType = matcher.group(2);
            this.parameters = new Hashtable(1);
            if (matcher.groupCount() >= 5) {
                Matcher matcher2 = patternParams.matcher(string.substring(matcher.end(2)));
                while (matcher2.find()) {
                    this.parameters.put(matcher2.group(1), matcher2.group(2));
                }
            }
        }
    }

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getType());
        stringBuffer.append("/");
        stringBuffer.append(this.getSubType());
        if (bl) {
            for (String string : this.parameters.keySet()) {
                stringBuffer.append(";");
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(this.parameters.get(string));
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return !(object instanceof ContentType) || this.toString().equalsIgnoreCase(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public String[] getParameterKeys() {
        if (this.parameters == null) {
            return new String[0];
        }
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public String getParameters(String string) {
        return this.getParameter(string);
    }

    static {
        String string = "[\\x21-\\x7E&&[^\\(\\)<>@,;:\\\\/\"\\[\\]\\?={}\\x20\\x09]]";
        String string2 = "(" + string + "+)=(\"?" + string + "+\"?)";
        patternTypeSubType = Pattern.compile("^(" + string + "+)/(" + string + "+)$");
        patternTypeSubTypeParams = Pattern.compile("^(" + string + "+)/(" + string + "+)(;" + string2 + ")*$");
        patternParams = Pattern.compile(";" + string2);
    }
}

