/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.Package;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.openxml4j.opc.ZipPackagePart;
import ai2.org.apache.poi.openxml4j.opc.internal.FileHelper;
import ai2.org.apache.poi.openxml4j.opc.internal.MemoryPackagePart;
import ai2.org.apache.poi.openxml4j.opc.internal.PartMarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.ZipContentTypeManager;
import ai2.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import ai2.org.apache.poi.openxml4j.opc.internal.marshallers.ZipPartMarshaller;
import ai2.org.apache.poi.openxml4j.util.ZipEntrySource;
import ai2.org.apache.poi.openxml4j.util.ZipFileZipEntrySource;
import ai2.org.apache.poi.openxml4j.util.ZipInputStreamZipEntrySource;
import ai2.org.apache.poi.openxml4j.util.ZipSecureFile;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.TempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipPackage
extends Package {
    private static POILogger logger = POILogFactory.getLogger(ZipPackage.class);
    private final ZipEntrySource zipArchive;

    public ZipPackage() {
        super(defaultPackageAccess);
        this.zipArchive = null;
        try {
            this.contentTypeManager = new ZipContentTypeManager(null, this);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    ZipPackage(InputStream inputStream, PackageAccess packageAccess) throws IOException {
        super(packageAccess);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipSecureFile.ThresholdInputStream thresholdInputStream = ZipSecureFile.addThreshold(zipInputStream);
        this.zipArchive = new ZipInputStreamZipEntrySource(thresholdInputStream);
    }

    ZipPackage(String string, PackageAccess packageAccess) {
        super(packageAccess);
        ZipFile zipFile = null;
        try {
            zipFile = ZipHelper.openZipFile(string);
        }
        catch (IOException iOException) {
            throw new InvalidOperationException("Can't open the specified file: '" + string + "'", iOException);
        }
        this.zipArchive = new ZipFileZipEntrySource(zipFile);
    }

    ZipPackage(File file, PackageAccess packageAccess) {
        super(packageAccess);
        ZipFile zipFile = null;
        try {
            zipFile = ZipHelper.openZipFile(file);
        }
        catch (IOException iOException) {
            throw new InvalidOperationException("Can't open the specified file: '" + file + "'", iOException);
        }
        this.zipArchive = new ZipFileZipEntrySource(zipFile);
    }

    ZipPackage(ZipEntrySource zipEntrySource, PackageAccess packageAccess) {
        super(packageAccess);
        this.zipArchive = zipEntrySource;
    }

    protected PackagePart[] getPartsImpl() throws InvalidFormatException {
        String string;
        PackagePartName packagePartName;
        ZipEntry zipEntry;
        if (this.partList == null) {
            this.partList = new PackagePartCollection();
        }
        if (this.zipArchive == null) {
            return this.partList.values().toArray(new PackagePart[this.partList.values().size()]);
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipArchive.getEntries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().equalsIgnoreCase("[Content_Types].xml")) continue;
            try {
                this.contentTypeManager = new ZipContentTypeManager(this.getZipArchive().getInputStream(zipEntry), this);
                break;
            }
            catch (IOException iOException) {
                throw new InvalidFormatException(iOException.getMessage());
            }
        }
        if (this.contentTypeManager == null) {
            throw new InvalidFormatException("Package should contain a content type part [M1.13]");
        }
        enumeration = this.zipArchive.getEntries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            packagePartName = this.buildPartName(zipEntry);
            if (packagePartName == null || (string = this.contentTypeManager.getContentType(packagePartName)) == null || !string.equals("application/vnd.openxmlformats-package.relationships+xml")) continue;
            try {
                this.partList.put(packagePartName, new ZipPackagePart((OPCPackage)this, zipEntry, packagePartName, string));
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new InvalidFormatException(invalidOperationException.getMessage());
            }
        }
        enumeration = this.zipArchive.getEntries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            packagePartName = this.buildPartName(zipEntry);
            if (packagePartName == null || (string = this.contentTypeManager.getContentType(packagePartName)) != null && string.equals("application/vnd.openxmlformats-package.relationships+xml")) continue;
            if (string != null) {
                try {
                    this.partList.put(packagePartName, new ZipPackagePart((OPCPackage)this, zipEntry, packagePartName, string));
                    continue;
                }
                catch (InvalidOperationException invalidOperationException) {
                    throw new InvalidFormatException(invalidOperationException.getMessage());
                }
            }
            throw new InvalidFormatException("The part " + packagePartName.getURI().getPath() + " does not have any content type ! Rule: Package require content types when retrieving a part from a package. [M.1.14]");
        }
        return this.partList.values().toArray(new ZipPackagePart[this.partList.size()]);
    }

    private PackagePartName buildPartName(ZipEntry zipEntry) {
        try {
            if (zipEntry.getName().equalsIgnoreCase("[Content_Types].xml")) {
                return null;
            }
            return PackagingURIHelper.createPartName(ZipHelper.getOPCNameFromZipItemName(zipEntry.getName()));
        }
        catch (Exception exception) {
            logger.log(5, new Object[]{"Entry " + zipEntry.getName() + " is not valid, so this part won't be add to the package.", exception});
            return null;
        }
    }

    protected PackagePart createPartImpl(PackagePartName packagePartName, String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("contentType");
        }
        if (packagePartName == null) {
            throw new IllegalArgumentException("partName");
        }
        try {
            return new MemoryPackagePart((OPCPackage)this, packagePartName, string, bl);
        }
        catch (InvalidFormatException invalidFormatException) {
            logger.log(5, new Object[]{invalidFormatException});
            return null;
        }
    }

    protected void removePartImpl(PackagePartName packagePartName) {
        if (packagePartName == null) {
            throw new IllegalArgumentException("partUri");
        }
    }

    protected void flushImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void closeImpl() throws IOException {
        this.flush();
        if (this.originalPackagePath == null || "".equals(this.originalPackagePath)) return;
        File file = new File(this.originalPackagePath);
        if (!file.exists()) throw new InvalidOperationException("Can't close a package not previously open with the open() method !");
        File file2 = TempFile.createTempFile(this.generateTempFileName(FileHelper.getDirectory(file)), ".tmp");
        try {
            this.save(file2);
            this.zipArchive.close();
            FileHelper.copyFile(file2, file);
            if (file2.delete()) return;
        }
        catch (Throwable throwable) {
            if (file2.delete()) throw throwable;
            logger.log(5, new Object[]{"The temporary file: '" + file.getAbsolutePath() + "' cannot be deleted ! Make sure that no other application use it."});
            throw throwable;
        }
        logger.log(5, new Object[]{"The temporary file: '" + file.getAbsolutePath() + "' cannot be deleted ! Make sure that no other application use it."});
    }

    private synchronized String generateTempFileName(File file) {
        File file2;
        while ((file2 = new File(file.getAbsoluteFile() + File.separator + "OpenXML4J" + System.nanoTime())).exists()) {
        }
        return FileHelper.getFilename(file2.getAbsoluteFile());
    }

    protected void revertImpl() {
        try {
            if (this.zipArchive != null) {
                this.zipArchive.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected PackagePart getPartImpl(PackagePartName packagePartName) {
        if (this.partList.containsKey(packagePartName)) {
            return (PackagePart)this.partList.get(packagePartName);
        }
        return null;
    }

    public void saveImpl(OutputStream outputStream) {
        this.throwExceptionIfReadOnly();
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = !(outputStream instanceof ZipOutputStream) ? new ZipOutputStream(outputStream) : (ZipOutputStream)outputStream;
            if (this.getPartsByRelationshipType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties").size() == 0 && this.getPartsByRelationshipType("http://schemas.openxmlformats.org/officedocument/2006/relationships/metadata/core-properties").size() == 0) {
                logger.log(1, new Object[]{"Save core properties part"});
                this.getPackageProperties();
                this.addPackagePart(this.packageProperties);
                this.relationships.addRelationship(this.packageProperties.getPartName().getURI(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties", null);
                if (!this.contentTypeManager.isContentTypeRegister("application/vnd.openxmlformats-package.core-properties+xml")) {
                    this.contentTypeManager.addContentType(this.packageProperties.getPartName(), "application/vnd.openxmlformats-package.core-properties+xml");
                }
            }
            logger.log(1, new Object[]{"Save package relationships"});
            ZipPartMarshaller.marshallRelationshipPart(this.getRelationships(), PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_PART_NAME, zipOutputStream);
            logger.log(1, new Object[]{"Save content types part"});
            this.contentTypeManager.save(zipOutputStream);
            for (PackagePart packagePart : this.getParts()) {
                if (packagePart.isRelationshipPart()) continue;
                logger.log(1, new Object[]{"Save part '" + ZipHelper.getZipItemNameFromOPCName(packagePart.getPartName().getName()) + "'"});
                PartMarshaller partMarshaller = (PartMarshaller)this.partMarshallers.get(packagePart._contentType);
                if (partMarshaller != null) {
                    if (partMarshaller.marshall(packagePart, zipOutputStream)) continue;
                    throw new OpenXML4JException("The part " + packagePart.getPartName().getURI() + " fail to be saved in the stream with marshaller " + partMarshaller);
                }
                if (this.defaultPartMarshaller.marshall(packagePart, zipOutputStream)) continue;
                throw new OpenXML4JException("The part " + packagePart.getPartName().getURI() + " fail to be saved in the stream with marshaller " + this.defaultPartMarshaller);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            throw new OpenXML4JRuntimeException("Fail to save: an error occurs while saving the package : " + exception.getMessage(), exception);
        }
    }

    public ZipEntrySource getZipArchive() {
        return this.zipArchive;
    }
}

