/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public final class StreamHelper {
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    private StreamHelper() {
    }

    private static synchronized Transformer getIdentityTransformer() throws TransformerException {
        return transformerFactory.newTransformer();
    }

    public static boolean saveXmlInStream(Document document, OutputStream outputStream) {
        try {
            Transformer transformer = StreamHelper.getIdentityTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(new FilterOutputStream(outputStream){

                public void write(byte[] byArray, int n, int n2) throws IOException {
                    this.out.write(byArray, n, n2);
                }

                public void close() throws IOException {
                    this.out.flush();
                }
            });
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            return false;
        }
        return true;
    }

    public static boolean copyStream(InputStream inputStream, OutputStream outputStream) {
        try {
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

