/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public final class PackagingURIHelper {
    private static final POILogger _logger = POILogFactory.getLogger(PackagingURIHelper.class);
    private static URI packageRootUri;
    public static final String RELATIONSHIP_PART_EXTENSION_NAME;
    public static final String RELATIONSHIP_PART_SEGMENT_NAME;
    public static final String PACKAGE_PROPERTIES_SEGMENT_NAME;
    public static final String PACKAGE_CORE_PROPERTIES_NAME;
    public static final char FORWARD_SLASH_CHAR;
    public static final String FORWARD_SLASH_STRING;
    public static final URI PACKAGE_RELATIONSHIPS_ROOT_URI;
    public static final PackagePartName PACKAGE_RELATIONSHIPS_ROOT_PART_NAME;
    public static final URI CORE_PROPERTIES_URI;
    public static final PackagePartName CORE_PROPERTIES_PART_NAME;
    public static final URI PACKAGE_ROOT_URI;
    public static final PackagePartName PACKAGE_ROOT_PART_NAME;
    private static final Pattern missingAuthPattern;
    private static final char[] hexDigits;

    public static URI getPackageRootUri() {
        return packageRootUri;
    }

    public static boolean isRelationshipPartURI(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("partUri");
        }
        return uRI.getPath().matches(".*" + RELATIONSHIP_PART_SEGMENT_NAME + ".*" + RELATIONSHIP_PART_EXTENSION_NAME + "$");
    }

    public static String getFilename(URI uRI) {
        if (uRI != null) {
            int n;
            String string = uRI.getPath();
            int n2 = n = string.length();
            while (--n2 >= 0) {
                char c = string.charAt(n2);
                if (c != FORWARD_SLASH_CHAR) continue;
                return string.substring(n2 + 1, n);
            }
        }
        return "";
    }

    public static String getFilenameWithoutExtension(URI uRI) {
        String string = PackagingURIHelper.getFilename(uRI);
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static URI getPath(URI uRI) {
        if (uRI != null) {
            int n;
            String string = uRI.getPath();
            int n2 = n = string.length();
            while (--n2 >= 0) {
                char c = string.charAt(n2);
                if (c != FORWARD_SLASH_CHAR) continue;
                try {
                    return new URI(string.substring(0, n2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    return null;
                }
            }
        }
        return null;
    }

    public static URI combine(URI uRI, URI uRI2) {
        URI uRI3 = null;
        try {
            uRI3 = new URI(PackagingURIHelper.combine(uRI.getPath(), uRI2.getPath()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Prefix and suffix can't be combine !");
        }
        return uRI3;
    }

    public static String combine(String string, String string2) {
        if (!string.endsWith("" + FORWARD_SLASH_CHAR) && !string2.startsWith("" + FORWARD_SLASH_CHAR)) {
            return string + FORWARD_SLASH_CHAR + string2;
        }
        if (!string.endsWith("" + FORWARD_SLASH_CHAR) && string2.startsWith("" + FORWARD_SLASH_CHAR) || string.endsWith("" + FORWARD_SLASH_CHAR) && !string2.startsWith("" + FORWARD_SLASH_CHAR)) {
            return string + string2;
        }
        return "";
    }

    public static URI relativizeURI(URI uRI, URI uRI2, boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = uRI.getPath().split("/", -1);
        String[] stringArray2 = uRI2.getPath().split("/", -1);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Can't relativize an empty source URI !");
        }
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException("Can't relativize an empty target URI !");
        }
        if (uRI.toString().equals("/")) {
            String string = uRI2.getPath();
            if (bl && string.length() > 0 && string.charAt(0) == '/') {
                try {
                    uRI2 = new URI(string.substring(1));
                }
                catch (Exception exception) {
                    _logger.log(5, new Object[]{exception});
                    return null;
                }
            }
            return uRI2;
        }
        int n2 = 0;
        for (n = 0; n < stringArray.length && n < stringArray2.length && stringArray[n].equals(stringArray2[n]); ++n) {
            ++n2;
        }
        if ((n2 == 0 || n2 == 1) && stringArray[0].equals("") && stringArray2[0].equals("")) {
            for (n = 0; n < stringArray.length - 2; ++n) {
                stringBuilder.append("../");
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n].equals("")) continue;
                stringBuilder.append(stringArray2[n]);
                if (n == stringArray2.length - 1) continue;
                stringBuilder.append("/");
            }
            try {
                return new URI(stringBuilder.toString());
            }
            catch (Exception exception) {
                _logger.log(5, new Object[]{exception});
                return null;
            }
        }
        if (n2 == stringArray.length && n2 == stringArray2.length) {
            if (uRI.equals(uRI2)) {
                stringBuilder.append(stringArray[stringArray.length - 1]);
            } else {
                stringBuilder.append("");
            }
        } else {
            if (n2 == 1) {
                stringBuilder.append("/");
            } else {
                for (n = n2; n < stringArray.length - 1; ++n) {
                    stringBuilder.append("../");
                }
            }
            for (n = n2; n < stringArray2.length; ++n) {
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
                    stringBuilder.append("/");
                }
                stringBuilder.append(stringArray2[n]);
            }
        }
        String string = uRI2.getRawFragment();
        if (string != null) {
            stringBuilder.append("#").append(string);
        }
        try {
            return new URI(stringBuilder.toString());
        }
        catch (Exception exception) {
            _logger.log(5, new Object[]{exception});
            return null;
        }
    }

    public static URI relativizeURI(URI uRI, URI uRI2) {
        return PackagingURIHelper.relativizeURI(uRI, uRI2, false);
    }

    public static URI resolvePartUri(URI uRI, URI uRI2) {
        if (uRI == null || uRI.isAbsolute()) {
            throw new IllegalArgumentException("sourcePartUri invalid - " + uRI);
        }
        if (uRI2 == null || uRI2.isAbsolute()) {
            throw new IllegalArgumentException("targetUri invalid - " + uRI2);
        }
        return uRI.resolve(uRI2);
    }

    public static URI getURIFromPath(String string) {
        URI uRI;
        try {
            uRI = PackagingURIHelper.toURI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("path");
        }
        return uRI;
    }

    public static URI getSourcePartUriFromRelationshipPartUri(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("Must not be null");
        }
        if (!PackagingURIHelper.isRelationshipPartURI(uRI)) {
            throw new IllegalArgumentException("Must be a relationship part");
        }
        if (uRI.compareTo(PACKAGE_RELATIONSHIPS_ROOT_URI) == 0) {
            return PACKAGE_ROOT_URI;
        }
        String string = uRI.getPath();
        String string2 = PackagingURIHelper.getFilenameWithoutExtension(uRI);
        string = string.substring(0, string.length() - string2.length() - RELATIONSHIP_PART_EXTENSION_NAME.length());
        string = string.substring(0, string.length() - RELATIONSHIP_PART_SEGMENT_NAME.length() - 1);
        string = PackagingURIHelper.combine(string, string2);
        return PackagingURIHelper.getURIFromPath(string);
    }

    public static PackagePartName createPartName(URI uRI) throws InvalidFormatException {
        if (uRI == null) {
            throw new IllegalArgumentException("partName");
        }
        return new PackagePartName(uRI, true);
    }

    public static PackagePartName createPartName(String string) throws InvalidFormatException {
        URI uRI;
        try {
            uRI = PackagingURIHelper.toURI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidFormatException(uRISyntaxException.getMessage());
        }
        return PackagingURIHelper.createPartName(uRI);
    }

    public static PackagePartName createPartName(String string, PackagePart packagePart) throws InvalidFormatException {
        URI uRI;
        try {
            uRI = PackagingURIHelper.resolvePartUri(packagePart.getPartName().getURI(), new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidFormatException(uRISyntaxException.getMessage());
        }
        return PackagingURIHelper.createPartName(uRI);
    }

    public static PackagePartName createPartName(URI uRI, PackagePart packagePart) throws InvalidFormatException {
        URI uRI2 = PackagingURIHelper.resolvePartUri(packagePart.getPartName().getURI(), uRI);
        return PackagingURIHelper.createPartName(uRI2);
    }

    public static boolean isValidPartName(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("partUri");
        }
        try {
            PackagingURIHelper.createPartName(uRI);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String decodeURI(URI uRI) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = uRI.toASCIIString();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (string.length() - i < 2) {
                    throw new IllegalArgumentException("The uri " + string + " contain invalid encoded character !");
                }
                char c2 = (char)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                stringBuffer.append(c2);
                i += 2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static PackagePartName getRelationshipPartName(PackagePartName packagePartName) {
        PackagePartName packagePartName2;
        if (packagePartName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (PACKAGE_ROOT_URI.getPath().equals(packagePartName.getURI().getPath())) {
            return PACKAGE_RELATIONSHIPS_ROOT_PART_NAME;
        }
        if (packagePartName.isRelationshipPartURI()) {
            throw new InvalidOperationException("Can't be a relationship part");
        }
        String string = packagePartName.getURI().getPath();
        String string2 = PackagingURIHelper.getFilename(packagePartName.getURI());
        string = string.substring(0, string.length() - string2.length());
        string = PackagingURIHelper.combine(string, RELATIONSHIP_PART_SEGMENT_NAME);
        string = PackagingURIHelper.combine(string, string2);
        string = string + RELATIONSHIP_PART_EXTENSION_NAME;
        try {
            packagePartName2 = PackagingURIHelper.createPartName(string);
        }
        catch (InvalidFormatException invalidFormatException) {
            return null;
        }
        return packagePartName2;
    }

    public static URI toURI(String string) throws URISyntaxException {
        CharSequence charSequence;
        int n;
        if (string.indexOf("\\") != -1) {
            string = string.replace('\\', '/');
        }
        if ((n = string.indexOf(35)) != -1) {
            charSequence = string.substring(0, n);
            String string2 = string.substring(n + 1);
            string = (String)charSequence + "#" + PackagingURIHelper.encode(string2);
        }
        if (string.length() > 0) {
            char c;
            int n2;
            charSequence = new StringBuilder();
            for (n2 = string.length() - 1; n2 >= 0 && (Character.isWhitespace(c = string.charAt(n2)) || c == '\u00a0'); --n2) {
                ((StringBuilder)charSequence).append(c);
            }
            if (((StringBuilder)charSequence).length() > 0) {
                string = string.substring(0, n2 + 1) + PackagingURIHelper.encode(((StringBuilder)charSequence).reverse().toString());
            }
        }
        if (missingAuthPattern.matcher(string).matches()) {
            string = string + "/";
        }
        return new URI(string);
    }

    public static String encode(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(string.getBytes(Charset.forName("UTF-8")));
        StringBuilder stringBuilder = new StringBuilder();
        while (byteBuffer.hasRemaining()) {
            int n2 = byteBuffer.get() & 0xFF;
            if (PackagingURIHelper.isUnsafe(n2)) {
                stringBuilder.append('%');
                stringBuilder.append(hexDigits[n2 >> 4 & 0xF]);
                stringBuilder.append(hexDigits[n2 >> 0 & 0xF]);
                continue;
            }
            stringBuilder.append((char)n2);
        }
        return stringBuilder.toString();
    }

    private static boolean isUnsafe(int n) {
        return n > 128 || Character.isWhitespace(n) || n == 160;
    }

    static {
        RELATIONSHIP_PART_SEGMENT_NAME = "_rels";
        RELATIONSHIP_PART_EXTENSION_NAME = ".rels";
        FORWARD_SLASH_CHAR = (char)47;
        FORWARD_SLASH_STRING = "/";
        PACKAGE_PROPERTIES_SEGMENT_NAME = "docProps";
        PACKAGE_CORE_PROPERTIES_NAME = "core.xml";
        URI uRI = null;
        URI uRI2 = null;
        URI uRI3 = null;
        try {
            uRI = new URI("/");
            uRI2 = new URI(FORWARD_SLASH_CHAR + RELATIONSHIP_PART_SEGMENT_NAME + FORWARD_SLASH_CHAR + RELATIONSHIP_PART_EXTENSION_NAME);
            packageRootUri = new URI("/");
            uRI3 = new URI(FORWARD_SLASH_CHAR + PACKAGE_PROPERTIES_SEGMENT_NAME + FORWARD_SLASH_CHAR + PACKAGE_CORE_PROPERTIES_NAME);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        PACKAGE_ROOT_URI = uRI;
        PACKAGE_RELATIONSHIPS_ROOT_URI = uRI2;
        CORE_PROPERTIES_URI = uRI3;
        PackagePartName packagePartName = null;
        PackagePartName packagePartName2 = null;
        PackagePartName packagePartName3 = null;
        try {
            packagePartName2 = PackagingURIHelper.createPartName(PACKAGE_RELATIONSHIPS_ROOT_URI);
            packagePartName3 = PackagingURIHelper.createPartName(CORE_PROPERTIES_URI);
            packagePartName = new PackagePartName(PACKAGE_ROOT_URI, false);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        PACKAGE_RELATIONSHIPS_ROOT_PART_NAME = packagePartName2;
        CORE_PROPERTIES_PART_NAME = packagePartName3;
        PACKAGE_ROOT_PART_NAME = packagePartName;
        missingAuthPattern = Pattern.compile("\\w+://");
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

