/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import java.net.URI;
import java.net.URISyntaxException;

public final class PackageRelationship {
    private static URI containerRelationshipPart;
    public static final String ID_ATTRIBUTE_NAME = "Id";
    public static final String RELATIONSHIPS_TAG_NAME = "Relationships";
    public static final String RELATIONSHIP_TAG_NAME = "Relationship";
    public static final String TARGET_ATTRIBUTE_NAME = "Target";
    public static final String TARGET_MODE_ATTRIBUTE_NAME = "TargetMode";
    public static final String TYPE_ATTRIBUTE_NAME = "Type";
    private String id;
    private OPCPackage container;
    private String relationshipType;
    private PackagePart source;
    private TargetMode targetMode;
    private URI targetUri;

    public PackageRelationship(OPCPackage oPCPackage, PackagePart packagePart, URI uRI, TargetMode targetMode, String string, String string2) {
        if (oPCPackage == null) {
            throw new IllegalArgumentException("pkg");
        }
        if (uRI == null) {
            throw new IllegalArgumentException("targetUri");
        }
        if (string == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("id");
        }
        this.container = oPCPackage;
        this.source = packagePart;
        this.targetUri = uRI;
        this.targetMode = targetMode;
        this.relationshipType = string;
        this.id = string2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PackageRelationship)) {
            return false;
        }
        PackageRelationship packageRelationship = (PackageRelationship)object;
        return this.id.equals(packageRelationship.id) && this.relationshipType.equals(packageRelationship.relationshipType) && (packageRelationship.source == null || packageRelationship.source.equals(this.source)) && this.targetMode == packageRelationship.targetMode && this.targetUri.equals(packageRelationship.targetUri);
    }

    public int hashCode() {
        return this.id.hashCode() + this.relationshipType.hashCode() + (this.source == null ? 0 : this.source.hashCode()) + this.targetMode.hashCode() + this.targetUri.hashCode();
    }

    public static URI getContainerPartRelationship() {
        return containerRelationshipPart;
    }

    public OPCPackage getPackage() {
        return this.container;
    }

    public String getId() {
        return this.id;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public PackagePart getSource() {
        return this.source;
    }

    public URI getSourceURI() {
        if (this.source == null) {
            return PackagingURIHelper.PACKAGE_ROOT_URI;
        }
        return this.source._partName.getURI();
    }

    public TargetMode getTargetMode() {
        return this.targetMode;
    }

    public URI getTargetURI() {
        if (this.targetMode == TargetMode.EXTERNAL) {
            return this.targetUri;
        }
        if (!this.targetUri.toASCIIString().startsWith("/")) {
            return PackagingURIHelper.resolvePartUri(this.getSourceURI(), this.targetUri);
        }
        return this.targetUri;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id == null ? "id=null" : "id=" + this.id);
        stringBuilder.append(this.container == null ? " - container=null" : " - container=" + this.container.toString());
        stringBuilder.append(this.relationshipType == null ? " - relationshipType=null" : " - relationshipType=" + this.relationshipType);
        stringBuilder.append(this.source == null ? " - source=null" : " - source=" + this.getSourceURI().toASCIIString());
        stringBuilder.append(this.targetUri == null ? " - target=null" : " - target=" + this.getTargetURI().toASCIIString());
        stringBuilder.append(this.targetMode == null ? ",targetMode=null" : ",targetMode=" + this.targetMode.toString());
        return stringBuilder.toString();
    }

    static {
        try {
            containerRelationshipPart = new URI("/_rels/.rels");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

