/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackagePartName
implements Comparable<PackagePartName> {
    private URI partNameURI;
    private static String[] RFC3986_PCHAR_SUB_DELIMS = new String[]{"!", "$", "&", "'", "(", ")", "*", "+", ",", ";", "="};
    private static String[] RFC3986_PCHAR_UNRESERVED_SUP = new String[]{"-", ".", "_", "~"};
    private static String[] RFC3986_PCHAR_AUTHORIZED_SUP = new String[]{":", "@"};
    private boolean isRelationship;

    PackagePartName(URI uRI, boolean bl) throws InvalidFormatException {
        if (bl) {
            PackagePartName.throwExceptionIfInvalidPartUri(uRI);
        } else if (!PackagingURIHelper.PACKAGE_ROOT_URI.equals(uRI)) {
            throw new OpenXML4JRuntimeException("OCP conformance must be check for ALL part name except special cases : ['/']");
        }
        this.partNameURI = uRI;
        this.isRelationship = this.isRelationshipPartURI(this.partNameURI);
    }

    PackagePartName(String string, boolean bl) throws InvalidFormatException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("partName argmument is not a valid OPC part name !");
        }
        if (bl) {
            PackagePartName.throwExceptionIfInvalidPartUri(uRI);
        } else if (!PackagingURIHelper.PACKAGE_ROOT_URI.equals(uRI)) {
            throw new OpenXML4JRuntimeException("OCP conformance must be check for ALL part name except special cases : ['/']");
        }
        this.partNameURI = uRI;
        this.isRelationship = this.isRelationshipPartURI(this.partNameURI);
    }

    private boolean isRelationshipPartURI(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("partUri");
        }
        return uRI.getPath().matches("^.*/" + PackagingURIHelper.RELATIONSHIP_PART_SEGMENT_NAME + "/.*\\" + PackagingURIHelper.RELATIONSHIP_PART_EXTENSION_NAME + "$");
    }

    public boolean isRelationshipPartURI() {
        return this.isRelationship;
    }

    private static void throwExceptionIfInvalidPartUri(URI uRI) throws InvalidFormatException {
        if (uRI == null) {
            throw new IllegalArgumentException("partUri");
        }
        PackagePartName.throwExceptionIfEmptyURI(uRI);
        PackagePartName.throwExceptionIfAbsoluteUri(uRI);
        PackagePartName.throwExceptionIfPartNameNotStartsWithForwardSlashChar(uRI);
        PackagePartName.throwExceptionIfPartNameEndsWithForwardSlashChar(uRI);
        PackagePartName.throwExceptionIfPartNameHaveInvalidSegments(uRI);
    }

    private static void throwExceptionIfEmptyURI(URI uRI) throws InvalidFormatException {
        if (uRI == null) {
            throw new IllegalArgumentException("partURI");
        }
        String string = uRI.getPath();
        if (string.length() == 0 || string.length() == 1 && string.charAt(0) == PackagingURIHelper.FORWARD_SLASH_CHAR) {
            throw new InvalidFormatException("A part name shall not be empty [M1.1]: " + uRI.getPath());
        }
    }

    private static void throwExceptionIfPartNameHaveInvalidSegments(URI uRI) throws InvalidFormatException {
        if (uRI == null) {
            throw new IllegalArgumentException("partUri");
        }
        String[] stringArray = uRI.toASCIIString().split("/");
        if (stringArray.length <= 1 || !stringArray[0].equals("")) {
            throw new InvalidFormatException("A part name shall not have empty segments [M1.3]: " + uRI.getPath());
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || "".equals(string)) {
                throw new InvalidFormatException("A part name shall not have empty segments [M1.3]: " + uRI.getPath());
            }
            if (string.endsWith(".")) {
                throw new InvalidFormatException("A segment shall not end with a dot ('.') character [M1.9]: " + uRI.getPath());
            }
            if ("".equals(string.replaceAll("\\\\.", ""))) {
                throw new InvalidFormatException("A segment shall include at least one non-dot character. [M1.10]: " + uRI.getPath());
            }
            PackagePartName.checkPCharCompliance(string);
        }
    }

    private static void checkPCharCompliance(String string) throws InvalidFormatException {
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            boolean bl = true;
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                bl = false;
            } else {
                for (n = 0; n < RFC3986_PCHAR_UNRESERVED_SUP.length; ++n) {
                    if (c != RFC3986_PCHAR_UNRESERVED_SUP[n].charAt(0)) continue;
                    bl = false;
                    break;
                }
                for (n = 0; bl && n < RFC3986_PCHAR_AUTHORIZED_SUP.length; ++n) {
                    if (c != RFC3986_PCHAR_AUTHORIZED_SUP[n].charAt(0)) continue;
                    bl = false;
                }
                for (n = 0; bl && n < RFC3986_PCHAR_SUB_DELIMS.length; ++n) {
                    if (c != RFC3986_PCHAR_SUB_DELIMS[n].charAt(0)) continue;
                    bl = false;
                }
            }
            if (bl && c == '%') {
                if (string.length() - i < 2) {
                    throw new InvalidFormatException("The segment " + string + " contain invalid encoded character !");
                }
                bl = false;
                n = (char)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                i += 2;
                if (n == 47 || n == 92) {
                    throw new InvalidFormatException("A segment shall not contain percent-encoded forward slash ('/'), or backward slash ('') characters. [M1.7]");
                }
                if (n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57) {
                    bl = true;
                }
                for (int j = 0; !bl && j < RFC3986_PCHAR_UNRESERVED_SUP.length; ++j) {
                    if (c != RFC3986_PCHAR_UNRESERVED_SUP[j].charAt(0)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    throw new InvalidFormatException("A segment shall not contain percent-encoded unreserved characters. [M1.8]");
                }
            }
            if (!bl) continue;
            throw new InvalidFormatException("A segment shall not hold any characters other than pchar characters. [M1.6]");
        }
    }

    private static void throwExceptionIfPartNameNotStartsWithForwardSlashChar(URI uRI) throws InvalidFormatException {
        String string = uRI.getPath();
        if (string.length() > 0 && string.charAt(0) != PackagingURIHelper.FORWARD_SLASH_CHAR) {
            throw new InvalidFormatException("A part name shall start with a forward slash ('/') character [M1.4]: " + uRI.getPath());
        }
    }

    private static void throwExceptionIfPartNameEndsWithForwardSlashChar(URI uRI) throws InvalidFormatException {
        String string = uRI.getPath();
        if (string.length() > 0 && string.charAt(string.length() - 1) == PackagingURIHelper.FORWARD_SLASH_CHAR) {
            throw new InvalidFormatException("A part name shall not have a forward slash as the last character [M1.5]: " + uRI.getPath());
        }
    }

    private static void throwExceptionIfAbsoluteUri(URI uRI) throws InvalidFormatException {
        if (uRI.isAbsolute()) {
            throw new InvalidFormatException("Absolute URI forbidden: " + uRI);
        }
    }

    @Override
    public int compareTo(PackagePartName packagePartName) {
        return PackagePartName.compare(this, packagePartName);
    }

    public String getExtension() {
        int n;
        String string = this.partNameURI.getPath();
        if (string.length() > 0 && (n = string.lastIndexOf(".")) > -1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public String getName() {
        return this.partNameURI.toASCIIString();
    }

    public boolean equals(Object object) {
        if (object instanceof PackagePartName) {
            return this.partNameURI.toASCIIString().toLowerCase(Locale.ROOT).equals(((PackagePartName)object).partNameURI.toASCIIString().toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public int hashCode() {
        return this.partNameURI.toASCIIString().toLowerCase(Locale.ROOT).hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public URI getURI() {
        return this.partNameURI;
    }

    public static int compare(PackagePartName packagePartName, PackagePartName packagePartName2) {
        if (packagePartName == null) {
            return packagePartName2 == null ? 0 : -1;
        }
        if (packagePartName2 == null) {
            return 1;
        }
        return PackagePartName.compare(packagePartName.getURI().toASCIIString().toLowerCase(Locale.ROOT), packagePartName2.getURI().toASCIIString().toLowerCase(Locale.ROOT));
    }

    public static int compare(String string, String string2) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            char c = string.charAt(n3++);
            char c2 = string2.charAt(n4++);
            if (Character.isDigit(c) && Character.isDigit(c2)) {
                int n5 = n3 - 1;
                while (n3 < n && Character.isDigit(string.charAt(n3))) {
                    ++n3;
                }
                int n6 = n4 - 1;
                while (n4 < n2 && Character.isDigit(string2.charAt(n4))) {
                    ++n4;
                }
                int n7 = new BigInteger(string.substring(n5, n3)).compareTo(new BigInteger(string2.substring(n6, n4)));
                if (n7 == 0) continue;
                return n7;
            }
            if (c == c2) continue;
            return c - c2;
        }
        return n - n2;
    }
}

