/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.RelationshipSource;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.openxml4j.opc.ZipPackagePart;
import ai2.org.apache.poi.openxml4j.opc.internal.ContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackagePart
implements RelationshipSource,
Comparable<PackagePart> {
    protected OPCPackage _container;
    protected PackagePartName _partName;
    protected ContentType _contentType;
    private boolean _isRelationshipPart;
    private boolean _isDeleted;
    private PackageRelationshipCollection _relationships;

    protected PackagePart(OPCPackage oPCPackage, PackagePartName packagePartName, ContentType contentType) throws InvalidFormatException {
        this(oPCPackage, packagePartName, contentType, true);
    }

    protected PackagePart(OPCPackage oPCPackage, PackagePartName packagePartName, ContentType contentType, boolean bl) throws InvalidFormatException {
        this._partName = packagePartName;
        this._contentType = contentType;
        this._container = oPCPackage;
        this._isRelationshipPart = this._partName.isRelationshipPartURI();
        if (bl) {
            this.loadRelationships();
        }
    }

    public PackagePart(OPCPackage oPCPackage, PackagePartName packagePartName, String string) throws InvalidFormatException {
        this(oPCPackage, packagePartName, new ContentType(string));
    }

    @Override
    public PackageRelationship addExternalRelationship(String string, String string2) {
        return this.addExternalRelationship(string, string2, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String string, String string2, String string3) {
        URI uRI;
        if (string == null) {
            throw new IllegalArgumentException("target is null for type " + string2);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this._relationships == null) {
            this._relationships = new PackageRelationshipCollection();
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid target - " + uRISyntaxException);
        }
        return this._relationships.addRelationship(uRI, TargetMode.EXTERNAL, string2, string3);
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName packagePartName, TargetMode targetMode, String string) {
        return this.addRelationship(packagePartName, targetMode, string, null);
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName packagePartName, TargetMode targetMode, String string, String string2) {
        this._container.throwExceptionIfReadOnly();
        if (packagePartName == null) {
            throw new IllegalArgumentException("targetPartName");
        }
        if (targetMode == null) {
            throw new IllegalArgumentException("targetMode");
        }
        if (string == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this._isRelationshipPart || packagePartName.isRelationshipPartURI()) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        if (this._relationships == null) {
            this._relationships = new PackageRelationshipCollection();
        }
        return this._relationships.addRelationship(packagePartName.getURI(), targetMode, string, string2);
    }

    public PackageRelationship addRelationship(URI uRI, TargetMode targetMode, String string) {
        return this.addRelationship(uRI, targetMode, string, null);
    }

    public PackageRelationship addRelationship(URI uRI, TargetMode targetMode, String string, String string2) {
        this._container.throwExceptionIfReadOnly();
        if (uRI == null) {
            throw new IllegalArgumentException("targetPartName");
        }
        if (targetMode == null) {
            throw new IllegalArgumentException("targetMode");
        }
        if (string == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this._isRelationshipPart || PackagingURIHelper.isRelationshipPartURI(uRI)) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        if (this._relationships == null) {
            this._relationships = new PackageRelationshipCollection();
        }
        return this._relationships.addRelationship(uRI, targetMode, string, string2);
    }

    @Override
    public void clearRelationships() {
        if (this._relationships != null) {
            this._relationships.clear();
        }
    }

    @Override
    public void removeRelationship(String string) {
        this._container.throwExceptionIfReadOnly();
        if (this._relationships != null) {
            this._relationships.removeRelationship(string);
        }
    }

    @Override
    public PackageRelationshipCollection getRelationships() throws InvalidFormatException {
        return this.getRelationshipsCore(null);
    }

    @Override
    public PackageRelationship getRelationship(String string) {
        return this._relationships.getRelationshipByID(string);
    }

    @Override
    public PackageRelationshipCollection getRelationshipsByType(String string) throws InvalidFormatException {
        this._container.throwExceptionIfWriteOnly();
        return this.getRelationshipsCore(string);
    }

    private PackageRelationshipCollection getRelationshipsCore(String string) throws InvalidFormatException {
        this._container.throwExceptionIfWriteOnly();
        if (this._relationships == null) {
            this.throwExceptionIfRelationship();
            this._relationships = new PackageRelationshipCollection(this);
        }
        return new PackageRelationshipCollection(this._relationships, string);
    }

    @Override
    public boolean hasRelationships() {
        return !this._isRelationshipPart && this._relationships != null && this._relationships.size() > 0;
    }

    @Override
    public boolean isRelationshipExists(PackageRelationship packageRelationship) {
        try {
            for (PackageRelationship packageRelationship2 : this.getRelationships()) {
                if (packageRelationship2 != packageRelationship) continue;
                return true;
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return false;
    }

    public PackagePart getRelatedPart(PackageRelationship packageRelationship) throws InvalidFormatException {
        PackagePart packagePart;
        Object object;
        if (!this.isRelationshipExists(packageRelationship)) {
            throw new IllegalArgumentException("Relationship " + packageRelationship + " doesn't start with this part " + this._partName);
        }
        URI uRI = packageRelationship.getTargetURI();
        if (uRI.getFragment() != null) {
            object = uRI.toString();
            try {
                uRI = new URI(((String)object).substring(0, ((String)object).indexOf(35)));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InvalidFormatException("Invalid target URI: " + uRI);
            }
        }
        if ((packagePart = this._container.getPart((PackagePartName)(object = PackagingURIHelper.createPartName(uRI)))) == null) {
            throw new IllegalArgumentException("No part found for relationship " + packageRelationship);
        }
        return packagePart;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.getInputStreamImpl();
        if (inputStream == null) {
            throw new IOException("Can't obtain the input stream from " + this._partName.getName());
        }
        return inputStream;
    }

    public OutputStream getOutputStream() {
        OutputStream outputStream;
        if (this instanceof ZipPackagePart) {
            this._container.removePart(this._partName);
            PackagePart packagePart = this._container.createPart(this._partName, this._contentType.toString(), false);
            if (packagePart == null) {
                throw new InvalidOperationException("Can't create a temporary part !");
            }
            packagePart._relationships = this._relationships;
            outputStream = packagePart.getOutputStreamImpl();
        } else {
            outputStream = this.getOutputStreamImpl();
        }
        return outputStream;
    }

    private void throwExceptionIfRelationship() throws InvalidOperationException {
        if (this._isRelationshipPart) {
            throw new InvalidOperationException("Can do this operation on a relationship part !");
        }
    }

    private void loadRelationships() throws InvalidFormatException {
        if (this._relationships == null && !this._isRelationshipPart) {
            this.throwExceptionIfRelationship();
            this._relationships = new PackageRelationshipCollection(this);
        }
    }

    public PackagePartName getPartName() {
        return this._partName;
    }

    public String getContentType() {
        return this._contentType.toString();
    }

    public ContentType getContentTypeDetails() {
        return this._contentType;
    }

    public void setContentType(String string) throws InvalidFormatException {
        if (this._container == null) {
            this._contentType = new ContentType(string);
        } else {
            this._container.unregisterPartAndContentType(this._partName);
            this._contentType = new ContentType(string);
            this._container.registerPartAndContentType(this);
        }
    }

    public OPCPackage getPackage() {
        return this._container;
    }

    public boolean isRelationshipPart() {
        return this._isRelationshipPart;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public void setDeleted(boolean bl) {
        this._isDeleted = bl;
    }

    public long getSize() {
        return -1L;
    }

    public String toString() {
        return "Name: " + this._partName + " - Content Type: " + this._contentType.toString();
    }

    @Override
    public int compareTo(PackagePart packagePart) {
        if (packagePart == null) {
            return -1;
        }
        return PackagePartName.compare(this._partName, packagePart._partName);
    }

    protected abstract InputStream getInputStreamImpl() throws IOException;

    protected abstract OutputStream getOutputStreamImpl();

    public abstract boolean save(OutputStream var1) throws OpenXML4JException;

    public abstract boolean load(InputStream var1) throws InvalidFormatException;

    public abstract void close();

    public abstract void flush();

    public void clear() {
    }
}

