/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.openxml4j.opc;

import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import ai2.org.apache.poi.openxml4j.exceptions.PartAlreadyExistsException;
import ai2.org.apache.poi.openxml4j.opc.ContentTypes;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackagePartCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagePartName;
import ai2.org.apache.poi.openxml4j.opc.PackageProperties;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationship;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.openxml4j.opc.PackagingURIHelper;
import ai2.org.apache.poi.openxml4j.opc.RelationshipSource;
import ai2.org.apache.poi.openxml4j.opc.StreamHelper;
import ai2.org.apache.poi.openxml4j.opc.TargetMode;
import ai2.org.apache.poi.openxml4j.opc.ZipPackage;
import ai2.org.apache.poi.openxml4j.opc.internal.ContentType;
import ai2.org.apache.poi.openxml4j.opc.internal.ContentTypeManager;
import ai2.org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import ai2.org.apache.poi.openxml4j.opc.internal.PartMarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.PartUnmarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.ZipContentTypeManager;
import ai2.org.apache.poi.openxml4j.opc.internal.marshallers.DefaultMarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.marshallers.ZipPackagePropertiesMarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.unmarshallers.PackagePropertiesUnmarshaller;
import ai2.org.apache.poi.openxml4j.opc.internal.unmarshallers.UnmarshallContext;
import ai2.org.apache.poi.openxml4j.util.Nullable;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OPCPackage
implements RelationshipSource,
Closeable {
    private static POILogger logger = POILogFactory.getLogger(OPCPackage.class);
    protected static final PackageAccess defaultPackageAccess = PackageAccess.READ_WRITE;
    private PackageAccess packageAccess;
    protected PackagePartCollection partList;
    protected PackageRelationshipCollection relationships;
    protected Hashtable<ContentType, PartMarshaller> partMarshallers;
    protected PartMarshaller defaultPartMarshaller;
    protected Hashtable<ContentType, PartUnmarshaller> partUnmarshallers;
    protected PackagePropertiesPart packageProperties;
    protected ContentTypeManager contentTypeManager;
    protected boolean isDirty = false;
    protected String originalPackagePath;
    protected OutputStream output;

    OPCPackage(PackageAccess packageAccess) {
        if (this.getClass() != ZipPackage.class) {
            throw new IllegalArgumentException("PackageBase may not be subclassed");
        }
        this.init();
        this.packageAccess = packageAccess;
    }

    private void init() {
        this.partMarshallers = new Hashtable(5);
        this.partUnmarshallers = new Hashtable(2);
        try {
            this.partUnmarshallers.put(new ContentType("application/vnd.openxmlformats-package.core-properties+xml"), new PackagePropertiesUnmarshaller());
            this.defaultPartMarshaller = new DefaultMarshaller();
            this.partMarshallers.put(new ContentType("application/vnd.openxmlformats-package.core-properties+xml"), new ZipPackagePropertiesMarshaller());
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new OpenXML4JRuntimeException("Package.init() : this exception should never happen, if you read this message please send a mail to the developers team. : " + invalidFormatException.getMessage());
        }
    }

    public static OPCPackage open(String string) throws InvalidFormatException {
        return OPCPackage.open(string, defaultPackageAccess);
    }

    public static OPCPackage open(File file) throws InvalidFormatException {
        return OPCPackage.open(file, defaultPackageAccess);
    }

    public static OPCPackage open(String string, PackageAccess packageAccess) throws InvalidFormatException {
        if (string == null || "".equals(string.trim())) {
            throw new IllegalArgumentException("'path' must be given");
        }
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("path must not be a directory");
        }
        ZipPackage zipPackage = new ZipPackage(string, packageAccess);
        if (zipPackage.partList == null && packageAccess != PackageAccess.WRITE) {
            zipPackage.getParts();
        }
        zipPackage.originalPackagePath = new File(string).getAbsolutePath();
        return zipPackage;
    }

    public static OPCPackage open(File file, PackageAccess packageAccess) throws InvalidFormatException {
        if (file == null) {
            throw new IllegalArgumentException("'file' must be given");
        }
        if (file == null || file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("file must not be a directory");
        }
        ZipPackage zipPackage = new ZipPackage(file, packageAccess);
        if (zipPackage.partList == null && packageAccess != PackageAccess.WRITE) {
            zipPackage.getParts();
        }
        zipPackage.originalPackagePath = file.getAbsolutePath();
        return zipPackage;
    }

    public static OPCPackage open(InputStream inputStream) throws InvalidFormatException, IOException {
        ZipPackage zipPackage = new ZipPackage(inputStream, PackageAccess.READ_WRITE);
        if (zipPackage.partList == null) {
            zipPackage.getParts();
        }
        return zipPackage;
    }

    public static OPCPackage openOrCreate(File file) throws InvalidFormatException {
        OPCPackage oPCPackage = null;
        oPCPackage = file.exists() ? OPCPackage.open(file.getAbsolutePath()) : OPCPackage.create(file);
        return oPCPackage;
    }

    public static OPCPackage create(String string) {
        return OPCPackage.create(new File(string));
    }

    public static OPCPackage create(File file) {
        if (file == null || file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("file");
        }
        if (file.exists()) {
            throw new InvalidOperationException("This package (or file) already exists : use the open() method or delete the file.");
        }
        ZipPackage zipPackage = null;
        zipPackage = new ZipPackage();
        zipPackage.originalPackagePath = file.getAbsolutePath();
        OPCPackage.configurePackage(zipPackage);
        return zipPackage;
    }

    public static OPCPackage create(OutputStream outputStream) {
        ZipPackage zipPackage = null;
        zipPackage = new ZipPackage();
        zipPackage.originalPackagePath = null;
        zipPackage.output = outputStream;
        OPCPackage.configurePackage(zipPackage);
        return zipPackage;
    }

    private static void configurePackage(OPCPackage oPCPackage) {
        try {
            oPCPackage.contentTypeManager = new ZipContentTypeManager(null, oPCPackage);
            oPCPackage.contentTypeManager.addContentType(PackagingURIHelper.createPartName(PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_URI), "application/vnd.openxmlformats-package.relationships+xml");
            oPCPackage.contentTypeManager.addContentType(PackagingURIHelper.createPartName("/default.xml"), "application/xml");
            oPCPackage.packageProperties = new PackagePropertiesPart(oPCPackage, PackagingURIHelper.CORE_PROPERTIES_PART_NAME);
            oPCPackage.packageProperties.setCreatorProperty("Generated by Apache POI OpenXML4J");
            oPCPackage.packageProperties.setCreatedProperty(new Nullable<Date>(new Date()));
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new IllegalStateException(invalidFormatException);
        }
    }

    public void flush() {
        this.throwExceptionIfReadOnly();
        if (this.packageProperties != null) {
            this.packageProperties.flush();
        }
        this.flushImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.packageAccess == PackageAccess.READ) {
            logger.log(5, new Object[]{"The close() method is intended to SAVE a package. This package is open in READ ONLY mode, use the revert() method instead !"});
            this.revert();
            return;
        }
        if (this.contentTypeManager == null) {
            logger.log(5, new Object[]{"Unable to call close() on a package that hasn't been fully opened yet"});
            return;
        }
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        try {
            reentrantReadWriteLock.writeLock().lock();
            if (this.originalPackagePath != null && !"".equals(this.originalPackagePath.trim())) {
                File file = new File(this.originalPackagePath);
                if (!file.exists() || !this.originalPackagePath.equalsIgnoreCase(file.getAbsolutePath())) {
                    this.save(file);
                } else {
                    this.closeImpl();
                }
            } else if (this.output != null) {
                this.save(this.output);
                this.output.close();
            }
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
        this.contentTypeManager.clearAll();
    }

    public void revert() {
        this.revertImpl();
    }

    public void addThumbnail(String string) throws IOException {
        if ("".equals(string)) {
            throw new IllegalArgumentException("path");
        }
        String string2 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        String string3 = ContentTypes.getContentTypeFromFileExtension(string2);
        PackagePartName packagePartName = null;
        try {
            packagePartName = PackagingURIHelper.createPartName("/docProps/" + string2);
        }
        catch (InvalidFormatException invalidFormatException) {
            try {
                packagePartName = PackagingURIHelper.createPartName("/docProps/thumbnail" + string.substring(string.lastIndexOf(".") + 1));
            }
            catch (InvalidFormatException invalidFormatException2) {
                throw new InvalidOperationException("Can't add a thumbnail file named '" + string2 + "'");
            }
        }
        if (this.getPart(packagePartName) != null) {
            throw new InvalidOperationException("You already add a thumbnail named '" + string2 + "'");
        }
        PackagePart packagePart = this.createPart(packagePartName, string3, false);
        this.addRelationship(packagePartName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail");
        FileInputStream fileInputStream = new FileInputStream(string);
        StreamHelper.copyStream(fileInputStream, packagePart.getOutputStream());
        fileInputStream.close();
    }

    void throwExceptionIfReadOnly() throws InvalidOperationException {
        if (this.packageAccess == PackageAccess.READ) {
            throw new InvalidOperationException("Operation not allowed, document open in read only mode!");
        }
    }

    void throwExceptionIfWriteOnly() throws InvalidOperationException {
        if (this.packageAccess == PackageAccess.WRITE) {
            throw new InvalidOperationException("Operation not allowed, document open in write only mode!");
        }
    }

    public PackageProperties getPackageProperties() throws InvalidFormatException {
        this.throwExceptionIfWriteOnly();
        if (this.packageProperties == null) {
            this.packageProperties = new PackagePropertiesPart(this, PackagingURIHelper.CORE_PROPERTIES_PART_NAME);
        }
        return this.packageProperties;
    }

    public PackagePart getPart(PackagePartName packagePartName) {
        this.throwExceptionIfWriteOnly();
        if (packagePartName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.partList == null) {
            try {
                this.getParts();
            }
            catch (InvalidFormatException invalidFormatException) {
                return null;
            }
        }
        return this.getPartImpl(packagePartName);
    }

    public ArrayList<PackagePart> getPartsByContentType(String string) {
        ArrayList<PackagePart> arrayList = new ArrayList<PackagePart>();
        for (PackagePart packagePart : this.partList.values()) {
            if (!packagePart.getContentType().equals(string)) continue;
            arrayList.add(packagePart);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public ArrayList<PackagePart> getPartsByRelationshipType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        ArrayList<PackagePart> arrayList = new ArrayList<PackagePart>();
        for (PackageRelationship packageRelationship : this.getRelationshipsByType(string)) {
            PackagePart packagePart = this.getPart(packageRelationship);
            if (packagePart == null) continue;
            arrayList.add(packagePart);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<PackagePart> getPartsByName(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("name pattern must not be null");
        }
        Matcher matcher = pattern.matcher("");
        ArrayList<PackagePart> arrayList = new ArrayList<PackagePart>();
        for (PackagePart packagePart : this.partList.values()) {
            PackagePartName packagePartName = packagePart.getPartName();
            if (!matcher.reset(packagePartName.getName()).matches()) continue;
            arrayList.add(packagePart);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public PackagePart getPart(PackageRelationship packageRelationship) {
        PackagePart packagePart = null;
        this.ensureRelationships();
        for (PackageRelationship packageRelationship2 : this.relationships) {
            if (!packageRelationship2.getRelationshipType().equals(packageRelationship.getRelationshipType())) continue;
            try {
                packagePart = this.getPart(PackagingURIHelper.createPartName(packageRelationship2.getTargetURI()));
                break;
            }
            catch (InvalidFormatException invalidFormatException) {
            }
        }
        return packagePart;
    }

    public ArrayList<PackagePart> getParts() throws InvalidFormatException {
        this.throwExceptionIfWriteOnly();
        if (this.partList == null) {
            boolean bl = false;
            boolean bl2 = true;
            PackagePart[] packagePartArray = this.getPartsImpl();
            this.partList = new PackagePartCollection();
            for (PackagePart packagePart : packagePartArray) {
                PartUnmarshaller partUnmarshaller;
                if (this.partList.containsKey(packagePart._partName)) {
                    throw new InvalidFormatException("A part with the name '" + packagePart._partName + "' already exist : Packages shall not contain equivalent " + "part names and package implementers shall neither create " + "nor recognize packages with equivalent part names. [M1.12]");
                }
                if (packagePart.getContentType().equals("application/vnd.openxmlformats-package.core-properties+xml")) {
                    if (!bl) {
                        bl = true;
                    } else {
                        logger.log(5, new Object[]{"OPC Compliance error [M4.1]: there is more than one core properties relationship in the package! POI will use only the first, but other software may reject this file."});
                    }
                }
                if ((partUnmarshaller = this.partUnmarshallers.get(packagePart._contentType)) != null) {
                    UnmarshallContext unmarshallContext = new UnmarshallContext(this, packagePart._partName);
                    try {
                        PackagePart packagePart2 = partUnmarshaller.unmarshall(unmarshallContext, packagePart.getInputStream());
                        this.partList.put(packagePart2._partName, packagePart2);
                        if (!(packagePart2 instanceof PackagePropertiesPart) || !bl || !bl2) continue;
                        this.packageProperties = (PackagePropertiesPart)packagePart2;
                        bl2 = false;
                        continue;
                    }
                    catch (IOException iOException) {
                        logger.log(5, new Object[]{"Unmarshall operation : IOException for " + packagePart._partName});
                        continue;
                    }
                    catch (InvalidOperationException invalidOperationException) {
                        throw new InvalidFormatException(invalidOperationException.getMessage());
                    }
                }
                try {
                    this.partList.put(packagePart._partName, packagePart);
                }
                catch (InvalidOperationException invalidOperationException) {
                    throw new InvalidFormatException(invalidOperationException.getMessage());
                }
            }
        }
        ArrayList<PackagePart> arrayList = new ArrayList<PackagePart>(this.partList.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public PackagePart createPart(PackagePartName packagePartName, String string) {
        return this.createPart(packagePartName, string, true);
    }

    PackagePart createPart(PackagePartName packagePartName, String string, boolean bl) {
        this.throwExceptionIfReadOnly();
        if (packagePartName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("contentType");
        }
        if (this.partList.containsKey(packagePartName) && !((PackagePart)this.partList.get(packagePartName)).isDeleted()) {
            throw new PartAlreadyExistsException("A part with the name '" + packagePartName.getName() + "'" + " already exists : Packages shall not contain equivalent part names and package" + " implementers shall neither create nor recognize packages with equivalent part names. [M1.12]");
        }
        if (string.equals("application/vnd.openxmlformats-package.core-properties+xml") && this.packageProperties != null) {
            throw new InvalidOperationException("OPC Compliance error [M4.1]: you try to add more than one core properties relationship in the package !");
        }
        PackagePart packagePart = this.createPartImpl(packagePartName, string, bl);
        this.contentTypeManager.addContentType(packagePartName, string);
        this.partList.put(packagePartName, packagePart);
        this.isDirty = true;
        return packagePart;
    }

    public PackagePart createPart(PackagePartName packagePartName, String string, ByteArrayOutputStream byteArrayOutputStream) {
        PackagePart packagePart = this.createPart(packagePartName, string);
        if (packagePart == null) {
            return null;
        }
        if (byteArrayOutputStream != null) {
            try {
                OutputStream outputStream = packagePart.getOutputStream();
                if (outputStream == null) {
                    return null;
                }
                outputStream.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                outputStream.close();
            }
            catch (IOException iOException) {
                return null;
            }
        } else {
            return null;
        }
        return packagePart;
    }

    protected PackagePart addPackagePart(PackagePart packagePart) {
        this.throwExceptionIfReadOnly();
        if (packagePart == null) {
            throw new IllegalArgumentException("part");
        }
        if (this.partList.containsKey(packagePart._partName)) {
            if (!((PackagePart)this.partList.get(packagePart._partName)).isDeleted()) {
                throw new InvalidOperationException("A part with the name '" + packagePart._partName.getName() + "' already exists : Packages shall not contain equivalent part names and package implementers shall neither create nor recognize packages with equivalent part names. [M1.12]");
            }
            packagePart.setDeleted(false);
            this.partList.remove(packagePart._partName);
        }
        this.partList.put(packagePart._partName, packagePart);
        this.isDirty = true;
        return packagePart;
    }

    public void removePart(PackagePart packagePart) {
        if (packagePart != null) {
            this.removePart(packagePart.getPartName());
        }
    }

    public void removePart(PackagePartName packagePartName) {
        this.throwExceptionIfReadOnly();
        if (packagePartName == null || !this.containPart(packagePartName)) {
            throw new IllegalArgumentException("partName");
        }
        if (this.partList.containsKey(packagePartName)) {
            ((PackagePart)this.partList.get(packagePartName)).setDeleted(true);
            this.removePartImpl(packagePartName);
            this.partList.remove(packagePartName);
        } else {
            this.removePartImpl(packagePartName);
        }
        this.contentTypeManager.removeContentType(packagePartName);
        if (packagePartName.isRelationshipPartURI()) {
            PackagePart packagePart;
            PackagePartName packagePartName2;
            URI uRI = PackagingURIHelper.getSourcePartUriFromRelationshipPartUri(packagePartName.getURI());
            try {
                packagePartName2 = PackagingURIHelper.createPartName(uRI);
            }
            catch (InvalidFormatException invalidFormatException) {
                logger.log(7, new Object[]{"Part name URI '" + uRI + "' is not valid ! This message is not intended to be displayed !"});
                return;
            }
            if (packagePartName2.getURI().equals(PackagingURIHelper.PACKAGE_ROOT_URI)) {
                this.clearRelationships();
            } else if (this.containPart(packagePartName2) && (packagePart = this.getPart(packagePartName2)) != null) {
                packagePart.clearRelationships();
            }
        }
        this.isDirty = true;
    }

    public void removePartRecursive(PackagePartName packagePartName) throws InvalidFormatException {
        PackagePart packagePart = (PackagePart)this.partList.get(PackagingURIHelper.getRelationshipPartName(packagePartName));
        PackagePart packagePart2 = (PackagePart)this.partList.get(packagePartName);
        if (packagePart != null) {
            PackageRelationshipCollection packageRelationshipCollection = new PackageRelationshipCollection(packagePart2);
            for (PackageRelationship packageRelationship : packageRelationshipCollection) {
                PackagePartName packagePartName2 = PackagingURIHelper.createPartName(PackagingURIHelper.resolvePartUri(packageRelationship.getSourceURI(), packageRelationship.getTargetURI()));
                this.removePart(packagePartName2);
            }
            this.removePart(packagePart._partName);
        }
        this.removePart(packagePart2._partName);
    }

    public void deletePart(PackagePartName packagePartName) {
        if (packagePartName == null) {
            throw new IllegalArgumentException("partName");
        }
        this.removePart(packagePartName);
        this.removePart(PackagingURIHelper.getRelationshipPartName(packagePartName));
    }

    public void deletePartRecursive(PackagePartName packagePartName) {
        if (packagePartName == null || !this.containPart(packagePartName)) {
            throw new IllegalArgumentException("partName");
        }
        PackagePart packagePart = this.getPart(packagePartName);
        this.removePart(packagePartName);
        try {
            for (PackageRelationship packageRelationship : packagePart.getRelationships()) {
                PackagePartName packagePartName2 = PackagingURIHelper.createPartName(PackagingURIHelper.resolvePartUri(packagePartName.getURI(), packageRelationship.getTargetURI()));
                this.deletePartRecursive(packagePartName2);
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            logger.log(5, new Object[]{"An exception occurs while deleting part '" + packagePartName.getName() + "'. Some parts may remain in the package. - " + invalidFormatException.getMessage()});
            return;
        }
        PackagePartName packagePartName3 = PackagingURIHelper.getRelationshipPartName(packagePartName);
        if (packagePartName3 != null && this.containPart(packagePartName3)) {
            this.removePart(packagePartName3);
        }
    }

    public boolean containPart(PackagePartName packagePartName) {
        return this.getPart(packagePartName) != null;
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName packagePartName, TargetMode targetMode, String string, String string2) {
        if (string.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties") && this.packageProperties != null) {
            throw new InvalidOperationException("OPC Compliance error [M4.1]: can't add another core properties part ! Use the built-in package method instead.");
        }
        if (packagePartName.isRelationshipPartURI()) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        this.ensureRelationships();
        PackageRelationship packageRelationship = this.relationships.addRelationship(packagePartName.getURI(), targetMode, string, string2);
        this.isDirty = true;
        return packageRelationship;
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName packagePartName, TargetMode targetMode, String string) {
        return this.addRelationship(packagePartName, targetMode, string, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String string, String string2) {
        return this.addExternalRelationship(string, string2, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String string, String string2, String string3) {
        URI uRI;
        if (string == null) {
            throw new IllegalArgumentException("target");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid target - " + uRISyntaxException);
        }
        this.ensureRelationships();
        PackageRelationship packageRelationship = this.relationships.addRelationship(uRI, TargetMode.EXTERNAL, string2, string3);
        this.isDirty = true;
        return packageRelationship;
    }

    @Override
    public void removeRelationship(String string) {
        if (this.relationships != null) {
            this.relationships.removeRelationship(string);
            this.isDirty = true;
        }
    }

    @Override
    public PackageRelationshipCollection getRelationships() {
        return this.getRelationshipsHelper(null);
    }

    @Override
    public PackageRelationshipCollection getRelationshipsByType(String string) {
        this.throwExceptionIfWriteOnly();
        if (string == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        return this.getRelationshipsHelper(string);
    }

    private PackageRelationshipCollection getRelationshipsHelper(String string) {
        this.throwExceptionIfWriteOnly();
        this.ensureRelationships();
        return this.relationships.getRelationships(string);
    }

    @Override
    public void clearRelationships() {
        if (this.relationships != null) {
            this.relationships.clear();
            this.isDirty = true;
        }
    }

    public void ensureRelationships() {
        if (this.relationships == null) {
            try {
                this.relationships = new PackageRelationshipCollection(this);
            }
            catch (InvalidFormatException invalidFormatException) {
                this.relationships = new PackageRelationshipCollection();
            }
        }
    }

    @Override
    public PackageRelationship getRelationship(String string) {
        return this.relationships.getRelationshipByID(string);
    }

    @Override
    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    @Override
    public boolean isRelationshipExists(PackageRelationship packageRelationship) {
        for (PackageRelationship packageRelationship2 : this.getRelationships()) {
            if (packageRelationship2 != packageRelationship) continue;
            return true;
        }
        return false;
    }

    public void addMarshaller(String string, PartMarshaller partMarshaller) {
        try {
            this.partMarshallers.put(new ContentType(string), partMarshaller);
        }
        catch (InvalidFormatException invalidFormatException) {
            logger.log(5, new Object[]{"The specified content type is not valid: '" + invalidFormatException.getMessage() + "'. The marshaller will not be added !"});
        }
    }

    public void addUnmarshaller(String string, PartUnmarshaller partUnmarshaller) {
        try {
            this.partUnmarshallers.put(new ContentType(string), partUnmarshaller);
        }
        catch (InvalidFormatException invalidFormatException) {
            logger.log(5, new Object[]{"The specified content type is not valid: '" + invalidFormatException.getMessage() + "'. The unmarshaller will not be added !"});
        }
    }

    public void removeMarshaller(String string) {
        this.partMarshallers.remove(string);
    }

    public void removeUnmarshaller(String string) {
        this.partUnmarshallers.remove(string);
    }

    public PackageAccess getPackageAccess() {
        return this.packageAccess;
    }

    public boolean validatePackage(OPCPackage oPCPackage) throws InvalidFormatException {
        throw new InvalidOperationException("Not implemented yet !!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("targetFile");
        }
        this.throwExceptionIfReadOnly();
        if (file.exists() && file.getAbsolutePath().equals(this.originalPackagePath)) {
            throw new InvalidOperationException("You can't call save(File) to save to the currently open file. To save to the current file, please just call close()");
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException.getLocalizedMessage());
        }
        try {
            this.save(fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        this.throwExceptionIfReadOnly();
        this.saveImpl(outputStream);
    }

    protected abstract PackagePart createPartImpl(PackagePartName var1, String var2, boolean var3);

    protected abstract void removePartImpl(PackagePartName var1);

    protected abstract void flushImpl();

    protected abstract void closeImpl() throws IOException;

    protected abstract void revertImpl();

    protected abstract void saveImpl(OutputStream var1) throws IOException;

    protected abstract PackagePart getPartImpl(PackagePartName var1);

    protected abstract PackagePart[] getPartsImpl() throws InvalidFormatException;

    public boolean replaceContentType(String string, String string2) {
        boolean bl = false;
        ArrayList<PackagePart> arrayList = this.getPartsByContentType(string);
        for (PackagePart packagePart : arrayList) {
            if (!packagePart.getContentType().equals(string)) continue;
            PackagePartName packagePartName = packagePart.getPartName();
            this.contentTypeManager.addContentType(packagePartName, string2);
            bl = true;
        }
        return bl;
    }

    public void registerPartAndContentType(PackagePart packagePart) {
        this.addPackagePart(packagePart);
        this.contentTypeManager.addContentType(packagePart.getPartName(), packagePart.getContentType());
        this.isDirty = true;
    }

    public void unregisterPartAndContentType(PackagePartName packagePartName) {
        this.removePart(packagePartName);
        this.contentTypeManager.removeContentType(packagePartName);
        this.isDirty = true;
    }
}

