/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.model.BytePropertyNode;
import ai2.org.apache.poi.hwpf.model.CHPX;
import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.ListTables;
import ai2.org.apache.poi.hwpf.model.PAPX;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.hwpf.model.SEPX;
import ai2.org.apache.poi.hwpf.model.StyleSheet;
import ai2.org.apache.poi.hwpf.model.SubdocumentType;
import ai2.org.apache.poi.hwpf.sprm.CharacterSprmCompressor;
import ai2.org.apache.poi.hwpf.sprm.ParagraphSprmCompressor;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.usermodel.BookmarksImpl;
import ai2.org.apache.poi.hwpf.usermodel.CharacterProperties;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.ListEntry;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.hwpf.usermodel.Section;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range {
    private POILogger logger = POILogFactory.getLogger(Range.class);
    @Deprecated
    public static final int TYPE_PARAGRAPH = 0;
    @Deprecated
    public static final int TYPE_CHARACTER = 1;
    @Deprecated
    public static final int TYPE_SECTION = 2;
    @Deprecated
    public static final int TYPE_TEXT = 3;
    @Deprecated
    public static final int TYPE_LISTENTRY = 4;
    @Deprecated
    public static final int TYPE_TABLE = 5;
    @Deprecated
    public static final int TYPE_UNDEFINED = 6;
    private WeakReference<Range> _parent;
    protected int _start;
    protected int _end;
    protected HWPFDocumentCore _doc;
    boolean _sectionRangeFound;
    protected List<SEPX> _sections;
    protected int _sectionStart;
    protected int _sectionEnd;
    protected boolean _parRangeFound;
    protected List<PAPX> _paragraphs;
    protected int _parStart;
    protected int _parEnd;
    protected boolean _charRangeFound;
    protected List<CHPX> _characters;
    protected int _charStart;
    protected int _charEnd;
    protected StringBuilder _text;

    public Range(int n, int n2, HWPFDocumentCore hWPFDocumentCore) {
        this._start = n;
        this._end = n2;
        this._doc = hWPFDocumentCore;
        this._sections = this._doc.getSectionTable().getSections();
        this._paragraphs = this._doc.getParagraphTable().getParagraphs();
        this._characters = this._doc.getCharacterTable().getTextRuns();
        this._text = this._doc.getText();
        this._parent = new WeakReference<Object>(null);
        this.sanityCheckStartEnd();
    }

    protected Range(int n, int n2, Range range) {
        this._start = n;
        this._end = n2;
        this._doc = range._doc;
        this._sections = range._sections;
        this._paragraphs = range._paragraphs;
        this._characters = range._characters;
        this._text = range._text;
        this._parent = new WeakReference<Range>(range);
        this.sanityCheckStartEnd();
        assert (this.sanityCheck());
    }

    @Deprecated
    protected Range(int n, int n2, int n3, Range range) {
        this._doc = range._doc;
        this._sections = range._sections;
        this._paragraphs = range._paragraphs;
        this._characters = range._characters;
        this._text = range._text;
        this._parent = new WeakReference<Range>(range);
        this.sanityCheckStartEnd();
    }

    private void sanityCheckStartEnd() {
        if (this._start < 0) {
            throw new IllegalArgumentException("Range start must not be negative. Given " + this._start);
        }
        if (this._end < this._start) {
            throw new IllegalArgumentException("The end (" + this._end + ") must not be before the start (" + this._start + ")");
        }
    }

    @Deprecated
    public boolean usesUnicode() {
        return true;
    }

    public String text() {
        return this._text.substring(this._start, this._end);
    }

    public static String stripFields(String string) {
        if (string.indexOf(19) == -1) {
            return string;
        }
        while (string.indexOf(19) > -1 && string.indexOf(21) > -1) {
            int n = string.indexOf(19);
            int n2 = string.indexOf(19, n + 1);
            int n3 = string.indexOf(20, n + 1);
            int n4 = string.lastIndexOf(21);
            if (n4 < n) break;
            if (n2 == -1 && n3 == -1) {
                string = string.substring(0, n) + string.substring(n4 + 1);
                break;
            }
            if (n3 != -1 && (n3 < n2 || n2 == -1)) {
                string = string.substring(0, n) + string.substring(n3 + 1, n4) + string.substring(n4 + 1);
                continue;
            }
            string = string.substring(0, n) + string.substring(n4 + 1);
        }
        return string;
    }

    public int numSections() {
        this.initSections();
        return this._sectionEnd - this._sectionStart;
    }

    public int numParagraphs() {
        this.initParagraphs();
        return this._parEnd - this._parStart;
    }

    public int numCharacterRuns() {
        this.initCharacterRuns();
        return this._charEnd - this._charStart;
    }

    public CharacterRun insertBefore(String string) {
        this.initAll();
        this._text.insert(this._start, string);
        this._doc.getCharacterTable().adjustForInsert(this._charStart, string.length());
        this._doc.getParagraphTable().adjustForInsert(this._parStart, string.length());
        this._doc.getSectionTable().adjustForInsert(this._sectionStart, string.length());
        if (this._doc instanceof HWPFDocument) {
            ((BookmarksImpl)((HWPFDocument)this._doc).getBookmarks()).afterInsert(this._start, string.length());
        }
        this.adjustForInsert(string.length());
        this.adjustFIB(string.length());
        assert (this.sanityCheck());
        return this.getCharacterRun(0);
    }

    public CharacterRun insertAfter(String string) {
        this.initAll();
        this._text.insert(this._end, string);
        this._doc.getCharacterTable().adjustForInsert(this._charEnd - 1, string.length());
        this._doc.getParagraphTable().adjustForInsert(this._parEnd - 1, string.length());
        this._doc.getSectionTable().adjustForInsert(this._sectionEnd - 1, string.length());
        if (this._doc instanceof HWPFDocument) {
            ((BookmarksImpl)((HWPFDocument)this._doc).getBookmarks()).afterInsert(this._end, string.length());
        }
        this.adjustForInsert(string.length());
        assert (this.sanityCheck());
        return this.getCharacterRun(this.numCharacterRuns() - 1);
    }

    @Deprecated
    public CharacterRun insertBefore(String string, CharacterProperties characterProperties) {
        this.initAll();
        PAPX pAPX = this._paragraphs.get(this._parStart);
        short s = pAPX.getIstd();
        StyleSheet styleSheet = this._doc.getStyleSheet();
        CharacterProperties characterProperties2 = styleSheet.getCharacterStyle(s);
        byte[] byArray = CharacterSprmCompressor.compressCharacterProperty(characterProperties, characterProperties2);
        SprmBuffer sprmBuffer = new SprmBuffer(byArray, 0);
        this._doc.getCharacterTable().insert(this._charStart, this._start, sprmBuffer);
        return this.insertBefore(string);
    }

    @Deprecated
    public CharacterRun insertAfter(String string, CharacterProperties characterProperties) {
        this.initAll();
        PAPX pAPX = this._paragraphs.get(this._parEnd - 1);
        short s = pAPX.getIstd();
        StyleSheet styleSheet = this._doc.getStyleSheet();
        CharacterProperties characterProperties2 = styleSheet.getCharacterStyle(s);
        byte[] byArray = CharacterSprmCompressor.compressCharacterProperty(characterProperties, characterProperties2);
        SprmBuffer sprmBuffer = new SprmBuffer(byArray, 0);
        this._doc.getCharacterTable().insert(this._charEnd, this._end, sprmBuffer);
        ++this._charEnd;
        return this.insertAfter(string);
    }

    @Deprecated
    public Paragraph insertBefore(ParagraphProperties paragraphProperties, int n) {
        return this.insertBefore(paragraphProperties, n, "\r");
    }

    @Deprecated
    protected Paragraph insertBefore(ParagraphProperties paragraphProperties, int n, String string) {
        this.initAll();
        StyleSheet styleSheet = this._doc.getStyleSheet();
        ParagraphProperties paragraphProperties2 = styleSheet.getParagraphStyle(n);
        CharacterProperties characterProperties = styleSheet.getCharacterStyle(n);
        byte[] byArray = ParagraphSprmCompressor.compressParagraphProperty(paragraphProperties, paragraphProperties2);
        byte[] byArray2 = new byte[byArray.length + 2];
        LittleEndian.putShort(byArray2, (short)n);
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        SprmBuffer sprmBuffer = new SprmBuffer(byArray2, 2);
        this._doc.getParagraphTable().insert(this._parStart, this._start, sprmBuffer);
        this.insertBefore(string, characterProperties);
        return this.getParagraph(0);
    }

    @Deprecated
    public Paragraph insertAfter(ParagraphProperties paragraphProperties, int n) {
        return this.insertAfter(paragraphProperties, n, "\r");
    }

    @Deprecated
    protected Paragraph insertAfter(ParagraphProperties paragraphProperties, int n, String string) {
        this.initAll();
        StyleSheet styleSheet = this._doc.getStyleSheet();
        ParagraphProperties paragraphProperties2 = styleSheet.getParagraphStyle(n);
        CharacterProperties characterProperties = styleSheet.getCharacterStyle(n);
        byte[] byArray = ParagraphSprmCompressor.compressParagraphProperty(paragraphProperties, paragraphProperties2);
        byte[] byArray2 = new byte[byArray.length + 2];
        LittleEndian.putShort(byArray2, (short)n);
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        SprmBuffer sprmBuffer = new SprmBuffer(byArray2, 2);
        this._doc.getParagraphTable().insert(this._parEnd, this._end, sprmBuffer);
        ++this._parEnd;
        this.insertAfter(string, characterProperties);
        return this.getParagraph(this.numParagraphs() - 1);
    }

    public void delete() {
        PropertyNode propertyNode;
        int n;
        this.initAll();
        int n2 = this._sections.size();
        int n3 = this._characters.size();
        int n4 = this._paragraphs.size();
        for (n = this._charStart; n < n3; ++n) {
            propertyNode = this._characters.get(n);
            propertyNode.adjustForDelete(this._start, this._end - this._start);
        }
        for (n = this._parStart; n < n4; ++n) {
            propertyNode = this._paragraphs.get(n);
            propertyNode.adjustForDelete(this._start, this._end - this._start);
        }
        for (n = this._sectionStart; n < n2; ++n) {
            propertyNode = this._sections.get(n);
            propertyNode.adjustForDelete(this._start, this._end - this._start);
        }
        if (this._doc instanceof HWPFDocument) {
            ((BookmarksImpl)((HWPFDocument)this._doc).getBookmarks()).afterDelete(this._start, this._end - this._start);
        }
        this._text.delete(this._start, this._end);
        Range range = (Range)this._parent.get();
        if (range != null) {
            range.adjustForInsert(-(this._end - this._start));
        }
        this.adjustFIB(-(this._end - this._start));
    }

    @Deprecated
    public Table insertBefore(TableProperties tableProperties, int n) {
        int n2;
        ParagraphProperties paragraphProperties = new ParagraphProperties();
        paragraphProperties.setFInTable(true);
        paragraphProperties.setItap(1);
        int n3 = this._end;
        int n4 = tableProperties.getItcMac();
        for (n2 = 0; n2 < n; ++n2) {
            Paragraph paragraph = this.insertBefore(paragraphProperties, 4095);
            paragraph.insertAfter(String.valueOf('\u0007'));
            for (int i = 1; i < n4; ++i) {
                paragraph = paragraph.insertAfter(paragraphProperties, 4095);
                paragraph.insertAfter(String.valueOf('\u0007'));
            }
            paragraph = paragraph.insertAfter(paragraphProperties, 4095, String.valueOf('\u0007'));
            paragraph.setTableRowEnd(tableProperties);
        }
        n2 = this._end;
        int n5 = n2 - n3;
        return new Table(this._start, this._start + n5, this, 1);
    }

    public Table insertTableBefore(short n, int n2) {
        int n3;
        ParagraphProperties paragraphProperties = new ParagraphProperties();
        paragraphProperties.setFInTable(true);
        paragraphProperties.setItap(1);
        int n4 = this._end;
        for (n3 = 0; n3 < n2; ++n3) {
            Paragraph paragraph = this.insertBefore(paragraphProperties, 4095);
            paragraph.insertAfter(String.valueOf('\u0007'));
            for (int i = 1; i < n; ++i) {
                paragraph = paragraph.insertAfter(paragraphProperties, 4095);
                paragraph.insertAfter(String.valueOf('\u0007'));
            }
            paragraph = paragraph.insertAfter(paragraphProperties, 4095, String.valueOf('\u0007'));
            paragraph.setTableRowEnd(new TableProperties((short)n));
        }
        n3 = this._end;
        int n5 = n3 - n4;
        return new Table(this._start, this._start + n5, this, 1);
    }

    @Deprecated
    public ListEntry insertBefore(ParagraphProperties paragraphProperties, int n, int n2, int n3) {
        ListTables listTables = this._doc.getListTables();
        if (listTables.getLevel(n, n2) == null) {
            throw new NoSuchElementException("The specified list and level do not exist");
        }
        int n4 = listTables.getOverrideIndexFromListID(n);
        paragraphProperties.setIlfo(n4);
        paragraphProperties.setIlvl((byte)n2);
        return (ListEntry)this.insertBefore(paragraphProperties, n3);
    }

    @Deprecated
    public ListEntry insertAfter(ParagraphProperties paragraphProperties, int n, int n2, int n3) {
        ListTables listTables = this._doc.getListTables();
        if (listTables.getLevel(n, n2) == null) {
            throw new NoSuchElementException("The specified list and level do not exist");
        }
        int n4 = listTables.getOverrideIndexFromListID(n);
        paragraphProperties.setIlfo(n4);
        paragraphProperties.setIlvl((byte)n2);
        return (ListEntry)this.insertAfter(paragraphProperties, n3);
    }

    public void replaceText(String string, boolean bl) {
        if (bl) {
            int n = this.getEndOffset();
            this.insertAfter(string);
            new Range(this.getStartOffset(), n, this).delete();
        } else {
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            this.insertBefore(string);
            new Range(n + string.length(), n2 + string.length(), this).delete();
        }
    }

    @Internal
    public void replaceText(String string, String string2, int n) {
        int n2 = this.getStartOffset() + n;
        Range range = new Range(n2, n2 + string.length(), this);
        range.insertBefore(string2);
        range = new Range(n2 + string2.length(), n2 + string.length() + string2.length(), this);
        range.delete();
    }

    public void replaceText(String string, String string2) {
        boolean bl = true;
        while (bl) {
            String string3 = this.text();
            int n = string3.indexOf(string);
            if (n >= 0) {
                this.replaceText(string, string2, n);
                continue;
            }
            bl = false;
        }
    }

    public CharacterRun getCharacterRun(int n) {
        Object object;
        short s;
        this.initCharacterRuns();
        if (n + this._charStart >= this._charEnd) {
            throw new IndexOutOfBoundsException("CHPX #" + n + " (" + (n + this._charStart) + ") not in range [" + this._charStart + "; " + this._charEnd + ")");
        }
        CHPX cHPX = this._characters.get(n + this._charStart);
        if (cHPX == null) {
            return null;
        }
        if (this instanceof Paragraph) {
            s = ((Paragraph)this)._istd;
        } else {
            object = this.findRange(this._paragraphs, Math.max(cHPX.getStart(), this._start), Math.min(cHPX.getEnd(), this._end));
            this.initParagraphs();
            int n2 = Math.max((int)object[0], this._parStart);
            if (n2 >= this._paragraphs.size()) {
                return null;
            }
            PAPX pAPX = this._paragraphs.get((int)object[0]);
            s = pAPX.getIstd();
        }
        object = new CharacterRun(cHPX, this._doc.getStyleSheet(), s, this);
        return object;
    }

    public Section getSection(int n) {
        this.initSections();
        SEPX sEPX = this._sections.get(n + this._sectionStart);
        Section section = new Section(sEPX, this);
        return section;
    }

    public Paragraph getParagraph(int n) {
        this.initParagraphs();
        if (n + this._parStart >= this._parEnd) {
            throw new IndexOutOfBoundsException("Paragraph #" + n + " (" + (n + this._parStart) + ") not in range [" + this._parStart + "; " + this._parEnd + ")");
        }
        PAPX pAPX = this._paragraphs.get(n + this._parStart);
        return Paragraph.newParagraph(this, pAPX);
    }

    @Deprecated
    public int type() {
        return 6;
    }

    public Table getTable(Paragraph paragraph) {
        Paragraph paragraph2;
        int n;
        Range range;
        if (!paragraph.isInTable()) {
            throw new IllegalArgumentException("This paragraph doesn't belong to a table");
        }
        Paragraph paragraph3 = paragraph;
        if (paragraph3._parent.get() != this) {
            throw new IllegalArgumentException("This paragraph is not a child of this range instance");
        }
        paragraph3.initAll();
        int n2 = paragraph.getTableLevel();
        if (paragraph3._parStart != 0 && ((Paragraph)(range = Paragraph.newParagraph(this, this._paragraphs.get(paragraph3._parStart - 1)))).isInTable() && ((Paragraph)range).getTableLevel() == n2 && ((Paragraph)range)._sectionEnd >= paragraph3._sectionStart) {
            throw new IllegalArgumentException("This paragraph is not the first one in the table");
        }
        range = this._doc.getOverallRange();
        int n3 = this._paragraphs.size();
        for (n = paragraph3._parStart; n < n3 - 1 && (paragraph2 = Paragraph.newParagraph(range, this._paragraphs.get(n + 1))).isInTable() && paragraph2.getTableLevel() >= n2; ++n) {
        }
        this.initAll();
        if (n >= this._parEnd) {
            this.logger.log(5, "The table's bounds ", "[" + this._parStart + "; " + n + ")", " fall outside of this Range paragraphs numbers ", "[" + this._parStart + "; " + this._parEnd + ")");
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("The table's end is negative, which isn't allowed!");
        }
        int n4 = this._paragraphs.get(n).getEnd();
        return new Table(paragraph.getStartOffset(), n4, this, paragraph.getTableLevel());
    }

    protected void initAll() {
        this.initCharacterRuns();
        this.initParagraphs();
        this.initSections();
    }

    private void initParagraphs() {
        if (!this._parRangeFound) {
            int[] nArray = this.findRange(this._paragraphs, this._start, this._end);
            this._parStart = nArray[0];
            this._parEnd = nArray[1];
            this._parRangeFound = true;
        }
    }

    private void initCharacterRuns() {
        if (!this._charRangeFound) {
            int[] nArray = this.findRange(this._characters, this._start, this._end);
            this._charStart = nArray[0];
            this._charEnd = nArray[1];
            this._charRangeFound = true;
        }
    }

    private void initSections() {
        if (!this._sectionRangeFound) {
            int[] nArray = this.findRange(this._sections, this._sectionStart, this._start, this._end);
            this._sectionStart = nArray[0];
            this._sectionEnd = nArray[1];
            this._sectionRangeFound = true;
        }
    }

    private static int binarySearchStart(List<? extends PropertyNode<?>> list, int n) {
        if (list.size() == 0) {
            return -1;
        }
        if (list.get(0).getStart() >= n) {
            return 0;
        }
        int n2 = 0;
        int n3 = list.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            PropertyNode<?> propertyNode = list.get(n4);
            if (propertyNode.getStart() < n) {
                n2 = n4 + 1;
                continue;
            }
            if (propertyNode.getStart() > n) {
                n3 = n4 - 1;
                continue;
            }
            assert (propertyNode.getStart() == n);
            return n4;
        }
        assert (n2 != 0);
        return n2 - 1;
    }

    private static int binarySearchEnd(List<? extends PropertyNode<?>> list, int n, int n2) {
        if (list.get(list.size() - 1).getEnd() <= n2) {
            return list.size() - 1;
        }
        int n3 = n;
        int n4 = list.size() - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            PropertyNode<?> propertyNode = list.get(n5);
            if (propertyNode.getEnd() < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (propertyNode.getEnd() > n2) {
                n4 = n5 - 1;
                continue;
            }
            assert (propertyNode.getEnd() == n2);
            return n5;
        }
        assert (0 <= n3 && n3 < list.size());
        return n3;
    }

    private int[] findRange(List<? extends PropertyNode<?>> list, int n, int n2) {
        int n3;
        int n4;
        for (n4 = Range.binarySearchStart(list, n); n4 > 0 && list.get(n4 - 1).getStart() >= n; --n4) {
        }
        for (n3 = Range.binarySearchEnd(list, n4, n2); n3 < list.size() - 1 && list.get(n3 + 1).getEnd() <= n2; ++n3) {
        }
        if (n4 < 0 || n4 >= list.size() || n4 > n3 || n3 < 0 || n3 >= list.size()) {
            throw new AssertionError();
        }
        return new int[]{n4, n3 + 1};
    }

    private int[] findRange(List<? extends PropertyNode<?>> list, int n, int n2, int n3) {
        int n4 = n;
        if (list.size() == n) {
            return new int[]{n, n};
        }
        PropertyNode<?> propertyNode = list.get(n4);
        while (propertyNode == null || propertyNode.getEnd() <= n2 && n4 < list.size() - 1) {
            if (++n4 >= list.size()) {
                return new int[]{0, 0};
            }
            propertyNode = list.get(n4);
        }
        if (propertyNode.getStart() > n3) {
            return new int[]{0, 0};
        }
        if (propertyNode.getEnd() <= n2) {
            return new int[]{list.size(), list.size()};
        }
        for (int i = n4; i < list.size(); ++i) {
            propertyNode = list.get(i);
            if (propertyNode == null || propertyNode.getStart() < n3 && propertyNode.getEnd() <= n3) continue;
            if (propertyNode.getStart() < n3) {
                return new int[]{n4, i + 1};
            }
            return new int[]{n4, i};
        }
        return new int[]{n4, list.size()};
    }

    protected void reset() {
        this._charRangeFound = false;
        this._parRangeFound = false;
        this._sectionRangeFound = false;
    }

    protected void adjustFIB(int n) {
        assert (this._doc instanceof HWPFDocument);
        FileInformationBlock fileInformationBlock = this._doc.getFileInformationBlock();
        int n2 = 0;
        for (SubdocumentType subdocumentType : SubdocumentType.ORDERED) {
            int n3 = fileInformationBlock.getSubdocumentTextStreamLength(subdocumentType);
            if (this._start > (n2 += n3)) continue;
            fileInformationBlock.setSubdocumentTextStreamLength(subdocumentType, n3 + n);
            break;
        }
    }

    private void adjustForInsert(int n) {
        this._end += n;
        this.reset();
        Range range = (Range)this._parent.get();
        if (range != null) {
            range.adjustForInsert(n);
        }
    }

    public int getStartOffset() {
        return this._start;
    }

    public int getEndOffset() {
        return this._end;
    }

    protected HWPFDocumentCore getDocument() {
        return this._doc;
    }

    public String toString() {
        return "Range from " + this.getStartOffset() + " to " + this.getEndOffset() + " (chars)";
    }

    public boolean sanityCheck() {
        int n;
        int n2;
        BytePropertyNode bytePropertyNode;
        int n3;
        if (this._start < 0) {
            throw new AssertionError();
        }
        if (this._start > this._text.length()) {
            throw new AssertionError();
        }
        if (this._end < 0) {
            throw new AssertionError();
        }
        if (this._end > this._text.length()) {
            throw new AssertionError();
        }
        if (this._start > this._end) {
            throw new AssertionError();
        }
        if (this._charRangeFound) {
            for (n3 = this._charStart; n3 < this._charEnd; ++n3) {
                bytePropertyNode = this._characters.get(n3);
                n2 = Math.max(this._start, bytePropertyNode.getStart());
                if (n2 >= (n = Math.min(this._end, bytePropertyNode.getEnd()))) {
                    throw new AssertionError();
                }
            }
        }
        if (this._parRangeFound) {
            for (n3 = this._parStart; n3 < this._parEnd; ++n3) {
                bytePropertyNode = this._paragraphs.get(n3);
                n2 = Math.max(this._start, bytePropertyNode.getStart());
                if (n2 >= (n = Math.min(this._end, bytePropertyNode.getEnd()))) {
                    throw new AssertionError();
                }
            }
        }
        return true;
    }
}

