/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PictureType {
    BMP("image/bmp", "bmp", new byte[][]{{66, 77}}),
    EMF("image/x-emf", "emf", new byte[][]{{1, 0, 0, 0}}),
    GIF("image/gif", "gif", new byte[][]{{71, 73, 70}}),
    JPEG("image/jpeg", "jpg", new byte[][]{{-1, -40}}),
    PICT("image/pict", ".pict", new byte[0][]),
    PNG("image/png", "png", new byte[][]{{-119, 80, 78, 71, 13, 10, 26, 10}}),
    TIFF("image/tiff", "tiff", new byte[][]{{73, 73, 42, 0}, {77, 77, 0, 42}}),
    UNKNOWN("image/unknown", "", new byte[0][]),
    WMF("image/x-wmf", "wmf", new byte[][]{{-41, -51, -58, -102, 0, 0}, {1, 0, 9, 0, 0, 3}});

    private String _extension;
    private String _mime;
    private byte[][] _signatures;

    public static PictureType findMatchingType(byte[] byArray) {
        for (PictureType pictureType : PictureType.values()) {
            for (byte[] byArray2 : pictureType.getSignatures()) {
                if (!PictureType.matchSignature(byArray, byArray2)) continue;
                return pictureType;
            }
        }
        return UNKNOWN;
    }

    private static boolean matchSignature(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private PictureType(String string2, String string3, byte[][] byArray) {
        this._mime = string2;
        this._extension = string3;
        this._signatures = byArray;
    }

    public String getExtension() {
        return this._extension;
    }

    public String getMime() {
        return this._mime;
    }

    public byte[][] getSignatures() {
        return this._signatures;
    }

    public boolean matchSignature(byte[] byArray) {
        for (byte[] byArray2 : this.getSignatures()) {
            if (!PictureType.matchSignature(byArray2, byArray)) continue;
            return true;
        }
        return false;
    }
}

