/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherBlipRecord;
import ai2.org.apache.poi.ddf.EscherComplexProperty;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherProperty;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hwpf.model.PICF;
import ai2.org.apache.poi.hwpf.model.PICFAndOfficeArtData;
import ai2.org.apache.poi.hwpf.usermodel.PictureType;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.PngUtils;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.InflaterInputStream;

public final class Picture {
    @Deprecated
    public static final byte[] BMP = new byte[]{66, 77};
    public static final byte[] COMPRESSED1 = new byte[]{-2, 120, -38};
    public static final byte[] COMPRESSED2 = new byte[]{-2, 120, -100};
    @Deprecated
    public static final byte[] EMF = new byte[]{1, 0, 0, 0};
    @Deprecated
    public static final byte[] GIF = new byte[]{71, 73, 70};
    public static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    @Deprecated
    public static final byte[] JPG = new byte[]{-1, -40};
    private static final POILogger log = POILogFactory.getLogger(Picture.class);
    @Deprecated
    public static final byte[] PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    @Deprecated
    public static final byte[] TIFF = new byte[]{73, 73, 42, 0};
    @Deprecated
    public static final byte[] TIFF1 = new byte[]{77, 77, 0, 42};
    @Deprecated
    public static final byte[] WMF1 = new byte[]{-41, -51, -58, -102, 0, 0};
    @Deprecated
    public static final byte[] WMF2 = new byte[]{1, 0, 9, 0, 0, 3};
    private PICF _picf;
    private PICFAndOfficeArtData _picfAndOfficeArtData;
    private List<? extends EscherRecord> _blipRecords;
    private byte[] content;
    private int dataBlockStartOfsset;
    private int height = -1;
    private int width = -1;

    private static int getBigEndianInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    private static int getBigEndianShort(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    private static boolean matchSignature(byte[] byArray, byte[] byArray2, int n) {
        boolean bl = n < byArray.length;
        for (int i = 0; i + n < byArray.length && i < byArray2.length; ++i) {
            if (byArray[i + n] == byArray2[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public Picture(EscherBlipRecord escherBlipRecord) {
        this._blipRecords = Arrays.asList(escherBlipRecord);
    }

    public Picture(int n, byte[] byArray, boolean bl) {
        this._picfAndOfficeArtData = new PICFAndOfficeArtData(byArray, n);
        this._picf = this._picfAndOfficeArtData.getPicf();
        this.dataBlockStartOfsset = n;
        if (this._picfAndOfficeArtData != null && this._picfAndOfficeArtData.getBlipRecords() != null) {
            this._blipRecords = this._picfAndOfficeArtData.getBlipRecords();
        }
        if (bl) {
            this.fillImageContent();
        }
    }

    private void fillImageContent() {
        if (this.content != null && this.content.length > 0) {
            return;
        }
        byte[] byArray = this.getRawContent();
        if (Picture.matchSignature(byArray, COMPRESSED1, 32) || Picture.matchSignature(byArray, COMPRESSED2, 32)) {
            try {
                int n;
                InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray, 33, byArray.length - 33));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[4096];
                while ((n = inflaterInputStream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                this.content = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                log.log(3, new Object[]{"Possibly corrupt compression or non-compressed data", iOException});
            }
        } else {
            this.content = byArray;
            if (PngUtils.matchesPngHeader(this.content, 16)) {
                byte[] byArray3 = new byte[this.content.length - 16];
                System.arraycopy(this.content, 16, byArray3, 0, byArray3.length);
                this.content = byArray3;
            }
        }
    }

    private void fillJPGWidthHeight() {
        byte[] byArray = this.getContent();
        int n = 2;
        byte by = byArray[n];
        byte by2 = byArray[n + 1];
        int n2 = byArray.length;
        while (n < n2 - 1) {
            do {
                by = byArray[n];
                by2 = byArray[n + 1];
            } while (by != -1 && (n += 2) < n2 - 1);
            if (by == -1 && n < n2 - 1) {
                if (by2 == -39 || by2 == -38) break;
                if ((by2 & 0xF0) == 192 && by2 != -60 && by2 != -56 && by2 != -52) {
                    this.height = Picture.getBigEndianShort(byArray, n += 5);
                    this.width = Picture.getBigEndianShort(byArray, n + 2);
                    break;
                }
                ++n;
                int n3 = Picture.getBigEndianShort(byArray, ++n);
                n += n3;
                continue;
            }
            ++n;
        }
    }

    void fillPNGWidthHeight() {
        int n;
        byte[] byArray = this.getContent();
        if (Picture.matchSignature(byArray, IHDR, n = PNG.length + 4)) {
            int n2 = n + 4;
            this.width = Picture.getBigEndianInt(byArray, n2);
            this.height = Picture.getBigEndianInt(byArray, n2 + 4);
        }
    }

    private void fillWidthHeight() {
        PictureType pictureType = this.suggestPictureType();
        switch (pictureType) {
            case JPEG: {
                this.fillJPGWidthHeight();
                break;
            }
            case PNG: {
                this.fillPNGWidthHeight();
                break;
            }
        }
    }

    @Deprecated
    public int getAspectRatioX() {
        return this._picf.getMx() / 10;
    }

    @Deprecated
    public int getAspectRatioY() {
        return this._picf.getMy() / 10;
    }

    public byte[] getContent() {
        this.fillImageContent();
        return this.content;
    }

    @Deprecated
    public int getDxaCropLeft() {
        return this._picf.getDxaReserved1();
    }

    @Deprecated
    public int getDxaCropRight() {
        return this._picf.getDxaReserved2();
    }

    public int getDxaGoal() {
        return this._picf.getDxaGoal();
    }

    @Deprecated
    public int getDyaCropBottom() {
        return this._picf.getDyaReserved2();
    }

    @Deprecated
    public int getDyaCropTop() {
        return this._picf.getDyaReserved1();
    }

    public int getDyaGoal() {
        return this._picf.getDyaGoal();
    }

    public int getHeight() {
        if (this.height == -1) {
            this.fillWidthHeight();
        }
        return this.height;
    }

    public int getHorizontalScalingFactor() {
        return this._picf.getMx();
    }

    public String getMimeType() {
        return this.suggestPictureType().getMime();
    }

    public byte[] getRawContent() {
        if (this._blipRecords == null || this._blipRecords.size() != 1) {
            return new byte[0];
        }
        EscherRecord escherRecord = this._blipRecords.get(0);
        if (escherRecord instanceof EscherBlipRecord) {
            return ((EscherBlipRecord)escherRecord).getPicturedata();
        }
        if (escherRecord instanceof EscherBSERecord) {
            return ((EscherBSERecord)escherRecord).getBlipRecord().getPicturedata();
        }
        return new byte[0];
    }

    public int getSize() {
        return this.getContent().length;
    }

    public int getStartOffset() {
        return this.dataBlockStartOfsset;
    }

    public int getVerticalScalingFactor() {
        return this._picf.getMy();
    }

    public int getWidth() {
        if (this.width == -1) {
            this.fillWidthHeight();
        }
        return this.width;
    }

    public String getDescription() {
        for (EscherRecord escherRecord : this._picfAndOfficeArtData.getShape().getChildRecords()) {
            if (!(escherRecord instanceof EscherOptRecord)) continue;
            EscherOptRecord escherOptRecord = (EscherOptRecord)escherRecord;
            for (EscherProperty escherProperty : escherOptRecord.getEscherProperties()) {
                if (897 != escherProperty.getPropertyNumber()) continue;
                byte[] byArray = ((EscherComplexProperty)escherProperty).getComplexData();
                return StringUtil.getFromUnicodeLE(byArray, 0, byArray.length / 2 - 1);
            }
        }
        return null;
    }

    public String suggestFileExtension() {
        return this.suggestPictureType().getExtension();
    }

    public String suggestFullFileName() {
        String string = this.suggestFileExtension();
        return Integer.toHexString(this.dataBlockStartOfsset) + (string.length() > 0 ? "." + string : "");
    }

    public PictureType suggestPictureType() {
        if (this._blipRecords == null || this._blipRecords.size() != 1) {
            return PictureType.UNKNOWN;
        }
        EscherRecord escherRecord = this._blipRecords.get(0);
        switch (escherRecord.getRecordId()) {
            case -4089: {
                EscherBSERecord escherBSERecord = (EscherBSERecord)escherRecord;
                switch (escherBSERecord.getBlipTypeWin32()) {
                    case 0: {
                        return PictureType.UNKNOWN;
                    }
                    case 1: {
                        return PictureType.UNKNOWN;
                    }
                    case 2: {
                        return PictureType.EMF;
                    }
                    case 3: {
                        return PictureType.WMF;
                    }
                    case 4: {
                        return PictureType.PICT;
                    }
                    case 5: {
                        return PictureType.JPEG;
                    }
                    case 6: {
                        return PictureType.PNG;
                    }
                    case 7: {
                        return PictureType.BMP;
                    }
                    case 17: {
                        return PictureType.TIFF;
                    }
                    case 18: {
                        return PictureType.JPEG;
                    }
                }
                return PictureType.UNKNOWN;
            }
            case -4070: {
                return PictureType.EMF;
            }
            case -4069: {
                return PictureType.WMF;
            }
            case -4068: {
                return PictureType.PICT;
            }
            case -4067: {
                return PictureType.JPEG;
            }
            case -4066: {
                return PictureType.PNG;
            }
            case -4065: {
                return PictureType.BMP;
            }
            case -4055: {
                return PictureType.TIFF;
            }
            case -4054: {
                return PictureType.JPEG;
            }
        }
        return PictureType.UNKNOWN;
    }

    public void writeImageContent(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getContent();
        if (byArray != null && byArray.length > 0) {
            outputStream.write(byArray, 0, byArray.length);
        }
    }
}

