/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.model.types.PAPAbstractType;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.DropCapSpecifier;
import ai2.org.apache.poi.hwpf.usermodel.LineSpacingDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.ShadingDescriptor;

public final class ParagraphProperties
extends PAPAbstractType
implements Cloneable {
    private boolean jcLogical = false;

    public ParagraphProperties() {
        this.setAnld(new byte[84]);
        this.setPhe(new byte[12]);
    }

    public Object clone() throws CloneNotSupportedException {
        ParagraphProperties paragraphProperties = (ParagraphProperties)super.clone();
        paragraphProperties.setAnld((byte[])this.getAnld().clone());
        paragraphProperties.setBrcTop((BorderCode)this.getBrcTop().clone());
        paragraphProperties.setBrcLeft((BorderCode)this.getBrcLeft().clone());
        paragraphProperties.setBrcBottom((BorderCode)this.getBrcBottom().clone());
        paragraphProperties.setBrcRight((BorderCode)this.getBrcRight().clone());
        paragraphProperties.setBrcBetween((BorderCode)this.getBrcBetween().clone());
        paragraphProperties.setBrcBar((BorderCode)this.getBrcBar().clone());
        paragraphProperties.setDcs(this.getDcs().clone());
        paragraphProperties.setLspd((LineSpacingDescriptor)this.getLspd().clone());
        paragraphProperties.setShd(this.getShd().clone());
        paragraphProperties.setPhe((byte[])this.getPhe().clone());
        return paragraphProperties;
    }

    public BorderCode getBarBorder() {
        return super.getBrcBar();
    }

    public BorderCode getBottomBorder() {
        return super.getBrcBottom();
    }

    public DropCapSpecifier getDropCap() {
        return super.getDcs();
    }

    public int getFirstLineIndent() {
        return super.getDxaLeft1();
    }

    public int getFontAlignment() {
        return super.getWAlignFont();
    }

    public int getIndentFromLeft() {
        return super.getDxaLeft();
    }

    public int getIndentFromRight() {
        return super.getDxaRight();
    }

    public int getJustification() {
        if (this.jcLogical) {
            if (!this.getFBiDi()) {
                return this.getJc();
            }
            switch (this.getJc()) {
                case 0: {
                    return 2;
                }
                case 2: {
                    return 0;
                }
            }
            return this.getJc();
        }
        return this.getJc();
    }

    public BorderCode getLeftBorder() {
        return super.getBrcLeft();
    }

    public LineSpacingDescriptor getLineSpacing() {
        return super.getLspd();
    }

    public BorderCode getRightBorder() {
        return super.getBrcRight();
    }

    public ShadingDescriptor getShading() {
        return super.getShd();
    }

    public int getSpacingAfter() {
        return super.getDyaAfter();
    }

    public int getSpacingBefore() {
        return super.getDyaBefore();
    }

    public BorderCode getTopBorder() {
        return super.getBrcTop();
    }

    public boolean isAutoHyphenated() {
        return !super.getFNoAutoHyph();
    }

    public boolean isBackward() {
        return super.isFBackward();
    }

    public boolean isKinsoku() {
        return super.getFKinsoku();
    }

    public boolean isLineNotNumbered() {
        return super.getFNoLnn();
    }

    public boolean isSideBySide() {
        return super.getFSideBySide();
    }

    public boolean isVertical() {
        return super.isFVertical();
    }

    public boolean isWidowControlled() {
        return super.getFWidowControl();
    }

    public boolean isWordWrapped() {
        return super.getFWordWrap();
    }

    public boolean keepOnPage() {
        return super.getFKeep();
    }

    public boolean keepWithNext() {
        return super.getFKeepFollow();
    }

    public boolean pageBreakBefore() {
        return super.getFPageBreakBefore();
    }

    public void setAutoHyphenated(boolean bl) {
        super.setFNoAutoHyph(!bl);
    }

    public void setBackward(boolean bl) {
        super.setFBackward(bl);
    }

    public void setBarBorder(BorderCode borderCode) {
        super.setBrcBar(borderCode);
    }

    public void setBottomBorder(BorderCode borderCode) {
        super.setBrcBottom(borderCode);
    }

    public void setDropCap(DropCapSpecifier dropCapSpecifier) {
        super.setDcs(dropCapSpecifier);
    }

    public void setFirstLineIndent(int n) {
        super.setDxaLeft1(n);
    }

    public void setFontAlignment(int n) {
        super.setWAlignFont(n);
    }

    public void setIndentFromLeft(int n) {
        super.setDxaLeft(n);
    }

    public void setIndentFromRight(int n) {
        super.setDxaRight(n);
    }

    public void setJustification(byte by) {
        super.setJc(by);
        this.jcLogical = false;
    }

    public void setJustificationLogical(byte by) {
        super.setJc(by);
        this.jcLogical = true;
    }

    public void setKeepOnPage(boolean bl) {
        super.setFKeep(bl);
    }

    public void setKeepWithNext(boolean bl) {
        super.setFKeepFollow(bl);
    }

    public void setKinsoku(boolean bl) {
        super.setFKinsoku(bl);
    }

    public void setLeftBorder(BorderCode borderCode) {
        super.setBrcLeft(borderCode);
    }

    public void setLineNotNumbered(boolean bl) {
        super.setFNoLnn(bl);
    }

    public void setLineSpacing(LineSpacingDescriptor lineSpacingDescriptor) {
        super.setLspd(lineSpacingDescriptor);
    }

    public void setPageBreakBefore(boolean bl) {
        super.setFPageBreakBefore(bl);
    }

    public void setRightBorder(BorderCode borderCode) {
        super.setBrcRight(borderCode);
    }

    public void setShading(ShadingDescriptor shadingDescriptor) {
        super.setShd(shadingDescriptor);
    }

    public void setSideBySide(boolean bl) {
        super.setFSideBySide(bl);
    }

    public void setSpacingAfter(int n) {
        super.setDyaAfter(n);
    }

    public void setSpacingBefore(int n) {
        super.setDyaBefore(n);
    }

    public void setTopBorder(BorderCode borderCode) {
        super.setBrcTop(borderCode);
    }

    public void setVertical(boolean bl) {
        super.setFVertical(bl);
    }

    public void setWidowControl(boolean bl) {
        super.setFWidowControl(bl);
    }

    public void setWordWrapped(boolean bl) {
        super.setFWordWrap(bl);
    }
}

