/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.model.LFO;
import ai2.org.apache.poi.hwpf.model.ListLevel;
import ai2.org.apache.poi.hwpf.model.ListTables;
import ai2.org.apache.poi.hwpf.model.PAPX;
import ai2.org.apache.poi.hwpf.model.StyleSheet;
import ai2.org.apache.poi.hwpf.sprm.ParagraphSprmUncompressor;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.sprm.TableSprmCompressor;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.DropCapSpecifier;
import ai2.org.apache.poi.hwpf.usermodel.HWPFList;
import ai2.org.apache.poi.hwpf.usermodel.LineSpacingDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.ListEntry;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.ShadingDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.NoSuchElementException;

public class Paragraph
extends Range
implements Cloneable {
    private static POILogger log = POILogFactory.getLogger(Paragraph.class);
    public static final short SPRM_JC = 9219;
    public static final short SPRM_FSIDEBYSIDE = 9220;
    public static final short SPRM_FKEEP = 9221;
    public static final short SPRM_FKEEPFOLLOW = 9222;
    public static final short SPRM_FPAGEBREAKBEFORE = 9223;
    public static final short SPRM_BRCL = 9224;
    public static final short SPRM_BRCP = 9225;
    public static final short SPRM_ILVL = 9738;
    public static final short SPRM_ILFO = 17931;
    public static final short SPRM_FNOLINENUMB = 9228;
    public static final short SPRM_CHGTABSPAPX = -14835;
    public static final short SPRM_DXARIGHT = -31730;
    public static final short SPRM_DXALEFT = -31729;
    public static final short SPRM_DXALEFT1 = -31727;
    public static final short SPRM_DYALINE = 25618;
    public static final short SPRM_DYABEFORE = -23533;
    public static final short SPRM_DYAAFTER = -23532;
    public static final short SPRM_CHGTABS = -14827;
    public static final short SPRM_FINTABLE = 9238;
    public static final short SPRM_FTTP = 9239;
    public static final short SPRM_DXAABS = -31720;
    public static final short SPRM_DYAABS = -31719;
    public static final short SPRM_DXAWIDTH = -31718;
    public static final short SPRM_PC = 9755;
    public static final short SPRM_WR = 9251;
    public static final short SPRM_BRCTOP = 25636;
    public static final short SPRM_BRCLEFT = 25637;
    public static final short SPRM_BRCBOTTOM = 25638;
    public static final short SPRM_BRCRIGHT = 25639;
    public static final short SPRM_BRCBAR = 26153;
    public static final short SPRM_FNOAUTOHYPH = 9258;
    public static final short SPRM_WHEIGHTABS = 17451;
    public static final short SPRM_DCS = 17452;
    public static final short SPRM_SHD80 = 17453;
    public static final short SPRM_SHD = -14771;
    public static final short SPRM_DYAFROMTEXT = -31698;
    public static final short SPRM_DXAFROMTEXT = -31697;
    public static final short SPRM_FLOCKED = 9264;
    public static final short SPRM_FWIDOWCONTROL = 9265;
    public static final short SPRM_RULER = -14798;
    public static final short SPRM_FKINSOKU = 9267;
    public static final short SPRM_FWORDWRAP = 9268;
    public static final short SPRM_FOVERFLOWPUNCT = 9269;
    public static final short SPRM_FTOPLINEPUNCT = 9270;
    public static final short SPRM_AUTOSPACEDE = 9271;
    public static final short SPRM_AUTOSPACEDN = 9272;
    public static final short SPRM_WALIGNFONT = 17465;
    public static final short SPRM_FRAMETEXTFLOW = 17466;
    public static final short SPRM_ANLD = -14786;
    public static final short SPRM_PROPRMARK = -14785;
    public static final short SPRM_OUTLVL = 9792;
    public static final short SPRM_FBIDI = 9281;
    public static final short SPRM_FNUMRMLNS = 9283;
    public static final short SPRM_CRLF = 9284;
    public static final short SPRM_NUMRM = -14779;
    public static final short SPRM_USEPGSUSETTINGS = 9287;
    public static final short SPRM_FADJUSTRIGHT = 9288;
    protected short _istd;
    protected ParagraphProperties _props;
    protected SprmBuffer _papx;

    @Internal
    static Paragraph newParagraph(Range range, PAPX pAPX) {
        HWPFDocumentCore hWPFDocumentCore = range._doc;
        ListTables listTables = hWPFDocumentCore.getListTables();
        StyleSheet styleSheet = hWPFDocumentCore.getStyleSheet();
        ParagraphProperties paragraphProperties = new ParagraphProperties();
        paragraphProperties.setIstd(pAPX.getIstd());
        paragraphProperties = Paragraph.newParagraph_applyStyleProperties(styleSheet, pAPX, paragraphProperties);
        paragraphProperties = ParagraphSprmUncompressor.uncompressPAP(paragraphProperties, pAPX.getGrpprl(), 2);
        if (paragraphProperties.getIlfo() != 0 && listTables != null) {
            ListLevel listLevel;
            LFO lFO = null;
            try {
                lFO = listTables.getLfo(paragraphProperties.getIlfo());
            }
            catch (NoSuchElementException noSuchElementException) {
                log.log(5, "Paragraph refers to LFO #", paragraphProperties.getIlfo(), " that does not exists");
            }
            if (lFO != null && (listLevel = listTables.getLevel(lFO.getLsid(), paragraphProperties.getIlvl())) != null && listLevel.getGrpprlPapx() != null) {
                paragraphProperties = ParagraphSprmUncompressor.uncompressPAP(paragraphProperties, listLevel.getGrpprlPapx(), 0);
                paragraphProperties = Paragraph.newParagraph_applyStyleProperties(styleSheet, pAPX, paragraphProperties);
                paragraphProperties = ParagraphSprmUncompressor.uncompressPAP(paragraphProperties, pAPX.getGrpprl(), 2);
            }
        }
        if (paragraphProperties.getIlfo() > 0) {
            return new ListEntry(pAPX, paragraphProperties, range);
        }
        return new Paragraph(pAPX, paragraphProperties, range);
    }

    protected static ParagraphProperties newParagraph_applyStyleProperties(StyleSheet styleSheet, PAPX pAPX, ParagraphProperties paragraphProperties) {
        if (styleSheet == null) {
            return paragraphProperties;
        }
        short s = pAPX.getIstd();
        byte[] byArray = styleSheet.getPAPX(s);
        return ParagraphSprmUncompressor.uncompressPAP(paragraphProperties, byArray, 2);
    }

    @Deprecated
    protected Paragraph(int n, int n2, Table table) {
        super(n, n2, table);
        this.initAll();
        PAPX pAPX = (PAPX)this._paragraphs.get(this._parEnd - 1);
        this._props = pAPX.getParagraphProperties(this._doc.getStyleSheet());
        this._papx = pAPX.getSprmBuf();
        this._istd = pAPX.getIstd();
    }

    @Deprecated
    protected Paragraph(PAPX pAPX, Range range) {
        super(Math.max(range._start, pAPX.getStart()), Math.min(range._end, pAPX.getEnd()), range);
        this._props = pAPX.getParagraphProperties(this._doc.getStyleSheet());
        this._papx = pAPX.getSprmBuf();
        this._istd = pAPX.getIstd();
    }

    @Deprecated
    protected Paragraph(PAPX pAPX, Range range, int n) {
        super(Math.max(range._start, n), Math.min(range._end, pAPX.getEnd()), range);
        this._props = pAPX.getParagraphProperties(this._doc.getStyleSheet());
        this._papx = pAPX.getSprmBuf();
        this._istd = pAPX.getIstd();
    }

    @Internal
    Paragraph(PAPX pAPX, ParagraphProperties paragraphProperties, Range range) {
        super(Math.max(range._start, pAPX.getStart()), Math.min(range._end, pAPX.getEnd()), range);
        this._props = paragraphProperties;
        this._papx = pAPX.getSprmBuf();
        this._istd = pAPX.getIstd();
    }

    public short getStyleIndex() {
        return this._istd;
    }

    @Deprecated
    public int type() {
        return 0;
    }

    public boolean isInTable() {
        return this._props.getFInTable();
    }

    public boolean isTableRowEnd() {
        return this._props.getFTtp() || this._props.getFTtpEmbedded();
    }

    public int getTableLevel() {
        return this._props.getItap();
    }

    public boolean isEmbeddedCellMark() {
        return this._props.getFInnerTableCell();
    }

    public int getJustification() {
        return this._props.getJc();
    }

    public void setJustification(byte by) {
        this._props.setJc(by);
        this._papx.updateSprm((short)9219, by);
    }

    public boolean keepOnPage() {
        return this._props.getFKeep();
    }

    public void setKeepOnPage(boolean bl) {
        this._props.setFKeep(bl);
        this._papx.updateSprm((short)9221, bl);
    }

    public boolean keepWithNext() {
        return this._props.getFKeepFollow();
    }

    public void setKeepWithNext(boolean bl) {
        this._props.setFKeepFollow(bl);
        this._papx.updateSprm((short)9222, bl);
    }

    public boolean pageBreakBefore() {
        return this._props.getFPageBreakBefore();
    }

    public void setPageBreakBefore(boolean bl) {
        this._props.setFPageBreakBefore(bl);
        this._papx.updateSprm((short)9223, bl);
    }

    public boolean isLineNotNumbered() {
        return this._props.getFNoLnn();
    }

    public void setLineNotNumbered(boolean bl) {
        this._props.setFNoLnn(bl);
        this._papx.updateSprm((short)9228, bl);
    }

    public boolean isSideBySide() {
        return this._props.getFSideBySide();
    }

    public void setSideBySide(boolean bl) {
        this._props.setFSideBySide(bl);
        this._papx.updateSprm((short)9220, bl);
    }

    public boolean isAutoHyphenated() {
        return !this._props.getFNoAutoHyph();
    }

    public void setAutoHyphenated(boolean bl) {
        this._props.setFNoAutoHyph(!bl);
        this._papx.updateSprm((short)9258, !bl);
    }

    public boolean isWidowControlled() {
        return this._props.getFWidowControl();
    }

    public void setWidowControl(boolean bl) {
        this._props.setFWidowControl(bl);
        this._papx.updateSprm((short)9265, bl);
    }

    public int getIndentFromRight() {
        return this._props.getDxaRight();
    }

    public void setIndentFromRight(int n) {
        this._props.setDxaRight(n);
        this._papx.updateSprm((short)-31730, (short)n);
    }

    public int getIndentFromLeft() {
        return this._props.getDxaLeft();
    }

    public void setIndentFromLeft(int n) {
        this._props.setDxaLeft(n);
        this._papx.updateSprm((short)-31729, (short)n);
    }

    public int getFirstLineIndent() {
        return this._props.getDxaLeft1();
    }

    public void setFirstLineIndent(int n) {
        this._props.setDxaLeft1(n);
        this._papx.updateSprm((short)-31727, (short)n);
    }

    public LineSpacingDescriptor getLineSpacing() {
        return this._props.getLspd();
    }

    public void setLineSpacing(LineSpacingDescriptor lineSpacingDescriptor) {
        this._props.setLspd(lineSpacingDescriptor);
        this._papx.updateSprm((short)25618, lineSpacingDescriptor.toInt());
    }

    public int getSpacingBefore() {
        return this._props.getDyaBefore();
    }

    public void setSpacingBefore(int n) {
        this._props.setDyaBefore(n);
        this._papx.updateSprm((short)-23533, (short)n);
    }

    public int getSpacingAfter() {
        return this._props.getDyaAfter();
    }

    public void setSpacingAfter(int n) {
        this._props.setDyaAfter(n);
        this._papx.updateSprm((short)-23532, (short)n);
    }

    public boolean isKinsoku() {
        return this._props.getFKinsoku();
    }

    public void setKinsoku(boolean bl) {
        this._props.setFKinsoku(bl);
        this._papx.updateSprm((short)9267, bl);
    }

    public boolean isWordWrapped() {
        return this._props.getFWordWrap();
    }

    public void setWordWrapped(boolean bl) {
        this._props.setFWordWrap(bl);
        this._papx.updateSprm((short)9268, bl);
    }

    public int getFontAlignment() {
        return this._props.getWAlignFont();
    }

    public void setFontAlignment(int n) {
        this._props.setWAlignFont(n);
        this._papx.updateSprm((short)17465, (short)n);
    }

    public boolean isVertical() {
        return this._props.isFVertical();
    }

    public void setVertical(boolean bl) {
        this._props.setFVertical(bl);
        this._papx.updateSprm((short)17466, this.getFrameTextFlow());
    }

    public boolean isBackward() {
        return this._props.isFBackward();
    }

    public void setBackward(boolean bl) {
        this._props.setFBackward(bl);
        this._papx.updateSprm((short)17466, this.getFrameTextFlow());
    }

    public BorderCode getTopBorder() {
        return this._props.getBrcTop();
    }

    public void setTopBorder(BorderCode borderCode) {
        this._props.setBrcTop(borderCode);
        this._papx.updateSprm((short)25636, borderCode.toInt());
    }

    public BorderCode getLeftBorder() {
        return this._props.getBrcLeft();
    }

    public void setLeftBorder(BorderCode borderCode) {
        this._props.setBrcLeft(borderCode);
        this._papx.updateSprm((short)25637, borderCode.toInt());
    }

    public BorderCode getBottomBorder() {
        return this._props.getBrcBottom();
    }

    public void setBottomBorder(BorderCode borderCode) {
        this._props.setBrcBottom(borderCode);
        this._papx.updateSprm((short)25638, borderCode.toInt());
    }

    public BorderCode getRightBorder() {
        return this._props.getBrcRight();
    }

    public void setRightBorder(BorderCode borderCode) {
        this._props.setBrcRight(borderCode);
        this._papx.updateSprm((short)25639, borderCode.toInt());
    }

    public BorderCode getBarBorder() {
        return this._props.getBrcBar();
    }

    public void setBarBorder(BorderCode borderCode) {
        this._props.setBrcBar(borderCode);
        this._papx.updateSprm((short)26153, borderCode.toInt());
    }

    public ShadingDescriptor getShading() {
        return this._props.getShd();
    }

    public void setShading(ShadingDescriptor shadingDescriptor) {
        this._props.setShd(shadingDescriptor);
        this._papx.addSprm((short)-14771, shadingDescriptor.serialize());
    }

    public DropCapSpecifier getDropCap() {
        return this._props.getDcs();
    }

    public void setDropCap(DropCapSpecifier dropCapSpecifier) {
        this._props.setDcs(dropCapSpecifier);
        this._papx.updateSprm((short)17452, dropCapSpecifier.toShort());
    }

    public int getIlfo() {
        return this._props.getIlfo();
    }

    public int getIlvl() {
        return this._props.getIlvl();
    }

    public int getLvl() {
        return this._props.getLvl();
    }

    void setTableRowEnd(TableProperties tableProperties) {
        this.setTableRowEnd(true);
        byte[] byArray = TableSprmCompressor.compressTableProperty(tableProperties);
        this._papx.append(byArray);
    }

    private void setTableRowEnd(boolean bl) {
        this._props.setFTtp(bl);
        this._papx.updateSprm((short)9239, bl);
    }

    public int getTabStopsNumber() {
        return this._props.getItbdMac();
    }

    public int[] getTabStopsPositions() {
        return this._props.getRgdxaTab();
    }

    public HWPFList getList() {
        if (this.getIlfo() == 0 || this.getIlfo() == 63489) {
            throw new IllegalStateException("Paragraph not in list");
        }
        HWPFList hWPFList = new HWPFList(this.getDocument().getStyleSheet(), this.getDocument().getListTables(), this.getIlfo());
        return hWPFList;
    }

    public boolean isInList() {
        return this.getIlfo() != 0 && this.getIlfo() != 63489;
    }

    public ParagraphProperties cloneProperties() {
        try {
            return (ParagraphProperties)this._props.clone();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Paragraph paragraph = (Paragraph)super.clone();
        paragraph._props = (ParagraphProperties)this._props.clone();
        paragraph._papx = new SprmBuffer(0);
        return paragraph;
    }

    private short getFrameTextFlow() {
        short s = 0;
        if (this._props.isFVertical()) {
            s = (short)(s | 1);
        }
        if (this._props.isFBackward()) {
            s = (short)(s | 2);
        }
        if (this._props.isFRotateFont()) {
            s = (short)(s | 4);
        }
        return s;
    }

    public String toString() {
        return "Paragraph [" + this.getStartOffset() + "; " + this.getEndOffset() + ")";
    }
}

