/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.model.NotesTables;
import ai2.org.apache.poi.hwpf.usermodel.Notes;
import java.util.HashMap;
import java.util.Map;

public class NotesImpl
implements Notes {
    private Map<Integer, Integer> anchorToIndexMap = null;
    private final NotesTables notesTables;

    public NotesImpl(NotesTables notesTables) {
        this.notesTables = notesTables;
    }

    public int getNoteAnchorPosition(int n) {
        return this.notesTables.getDescriptor(n).getStart();
    }

    public int getNoteIndexByAnchorPosition(int n) {
        this.updateAnchorToIndexMap();
        Integer n2 = this.anchorToIndexMap.get(n);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    public int getNotesCount() {
        return this.notesTables.getDescriptorsCount();
    }

    public int getNoteTextEndOffset(int n) {
        return this.notesTables.getTextPosition(n).getEnd();
    }

    public int getNoteTextStartOffset(int n) {
        return this.notesTables.getTextPosition(n).getStart();
    }

    private void updateAnchorToIndexMap() {
        if (this.anchorToIndexMap != null) {
            return;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.notesTables.getDescriptorsCount(); ++i) {
            int n = this.notesTables.getDescriptor(i).getStart();
            hashMap.put(n, i);
        }
        this.anchorToIndexMap = hashMap;
    }
}

