/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.model.PlexOfField;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.Field;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.util.Internal;

@Internal
class FieldImpl
implements Field {
    private PlexOfField endPlex;
    private PlexOfField separatorPlex;
    private PlexOfField startPlex;

    public FieldImpl(PlexOfField plexOfField, PlexOfField plexOfField2, PlexOfField plexOfField3) {
        if (plexOfField == null) {
            throw new IllegalArgumentException("startPlex == null");
        }
        if (plexOfField3 == null) {
            throw new IllegalArgumentException("endPlex == null");
        }
        if (plexOfField.getFld().getBoundaryType() != 19) {
            throw new IllegalArgumentException("startPlex (" + plexOfField + ") is not type of FIELD_BEGIN");
        }
        if (plexOfField2 != null && plexOfField2.getFld().getBoundaryType() != 20) {
            throw new IllegalArgumentException("separatorPlex" + plexOfField2 + ") is not type of FIELD_SEPARATOR");
        }
        if (plexOfField3.getFld().getBoundaryType() != 21) {
            throw new IllegalArgumentException("endPlex (" + plexOfField3 + ") is not type of FIELD_END");
        }
        this.startPlex = plexOfField;
        this.separatorPlex = plexOfField2;
        this.endPlex = plexOfField3;
    }

    public Range firstSubrange(Range range) {
        if (this.hasSeparator()) {
            if (this.getMarkStartOffset() + 1 == this.getMarkSeparatorOffset()) {
                return null;
            }
            return new Range(this.getMarkStartOffset() + 1, this.getMarkSeparatorOffset(), range){

                public String toString() {
                    return "FieldSubrange1 (" + super.toString() + ")";
                }
            };
        }
        if (this.getMarkStartOffset() + 1 == this.getMarkEndOffset()) {
            return null;
        }
        return new Range(this.getMarkStartOffset() + 1, this.getMarkEndOffset(), range){

            public String toString() {
                return "FieldSubrange1 (" + super.toString() + ")";
            }
        };
    }

    public int getFieldEndOffset() {
        return this.endPlex.getFcStart() + 1;
    }

    public int getFieldStartOffset() {
        return this.startPlex.getFcStart();
    }

    public CharacterRun getMarkEndCharacterRun(Range range) {
        return new Range(this.getMarkEndOffset(), this.getMarkEndOffset() + 1, range).getCharacterRun(0);
    }

    public int getMarkEndOffset() {
        return this.endPlex.getFcStart();
    }

    public CharacterRun getMarkSeparatorCharacterRun(Range range) {
        if (!this.hasSeparator()) {
            return null;
        }
        return new Range(this.getMarkSeparatorOffset(), this.getMarkSeparatorOffset() + 1, range).getCharacterRun(0);
    }

    public int getMarkSeparatorOffset() {
        return this.separatorPlex.getFcStart();
    }

    public CharacterRun getMarkStartCharacterRun(Range range) {
        return new Range(this.getMarkStartOffset(), this.getMarkStartOffset() + 1, range).getCharacterRun(0);
    }

    public int getMarkStartOffset() {
        return this.startPlex.getFcStart();
    }

    public int getType() {
        return this.startPlex.getFld().getFieldType();
    }

    public boolean hasSeparator() {
        return this.separatorPlex != null;
    }

    public boolean isHasSep() {
        return this.endPlex.getFld().isFHasSep();
    }

    public boolean isLocked() {
        return this.endPlex.getFld().isFLocked();
    }

    public boolean isNested() {
        return this.endPlex.getFld().isFNested();
    }

    public boolean isPrivateResult() {
        return this.endPlex.getFld().isFPrivateResult();
    }

    public boolean isResultDirty() {
        return this.endPlex.getFld().isFResultDirty();
    }

    public boolean isResultEdited() {
        return this.endPlex.getFld().isFResultEdited();
    }

    public boolean isZombieEmbed() {
        return this.endPlex.getFld().isFZombieEmbed();
    }

    public Range secondSubrange(Range range) {
        if (!this.hasSeparator() || this.getMarkSeparatorOffset() + 1 == this.getMarkEndOffset()) {
            return null;
        }
        return new Range(this.getMarkSeparatorOffset() + 1, this.getMarkEndOffset(), range){

            public String toString() {
                return "FieldSubrange2 (" + super.toString() + ")";
            }
        };
    }

    public String toString() {
        return "Field [" + this.getFieldStartOffset() + "; " + this.getFieldEndOffset() + "] (type: 0x" + Integer.toHexString(this.getType()) + " = " + this.getType() + " )";
    }
}

