/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.model.CHPX;
import ai2.org.apache.poi.hwpf.model.FFData;
import ai2.org.apache.poi.hwpf.model.Ffn;
import ai2.org.apache.poi.hwpf.model.NilPICFAndBinData;
import ai2.org.apache.poi.hwpf.model.StyleSheet;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.CharacterProperties;
import ai2.org.apache.poi.hwpf.usermodel.DateAndTime;
import ai2.org.apache.poi.hwpf.usermodel.Range;

public final class CharacterRun
extends Range
implements Cloneable,
ai2.org.apache.poi.wp.usermodel.CharacterRun {
    public static final short SPRM_FRMARKDEL = 2048;
    public static final short SPRM_FRMARK = 2049;
    public static final short SPRM_FFLDVANISH = 2050;
    public static final short SPRM_PICLOCATION = 27139;
    public static final short SPRM_IBSTRMARK = 18436;
    public static final short SPRM_DTTMRMARK = 26629;
    public static final short SPRM_FDATA = 2054;
    public static final short SPRM_SYMBOL = 27145;
    public static final short SPRM_FOLE2 = 2058;
    public static final short SPRM_HIGHLIGHT = 10764;
    public static final short SPRM_OBJLOCATION = 26638;
    public static final short SPRM_ISTD = 18992;
    public static final short SPRM_FBOLD = 2101;
    public static final short SPRM_FITALIC = 2102;
    public static final short SPRM_FSTRIKE = 2103;
    public static final short SPRM_FOUTLINE = 2104;
    public static final short SPRM_FSHADOW = 2105;
    public static final short SPRM_FSMALLCAPS = 2106;
    public static final short SPRM_FCAPS = 2107;
    public static final short SPRM_FVANISH = 2108;
    public static final short SPRM_KUL = 10814;
    public static final short SPRM_DXASPACE = -30656;
    public static final short SPRM_LID = 19009;
    public static final short SPRM_ICO = 10818;
    public static final short SPRM_HPS = 19011;
    public static final short SPRM_HPSPOS = 18501;
    public static final short SPRM_ISS = 10824;
    public static final short SPRM_HPSKERN = 18507;
    public static final short SPRM_YSRI = 18510;
    public static final short SPRM_RGFTCASCII = 19023;
    public static final short SPRM_RGFTCFAREAST = 19024;
    public static final short SPRM_RGFTCNOTFAREAST = 19025;
    public static final short SPRM_CHARSCALE = 18514;
    public static final short SPRM_FDSTRIKE = 10835;
    public static final short SPRM_FIMPRINT = 2132;
    public static final short SPRM_FSPEC = 2133;
    public static final short SPRM_FOBJ = 2134;
    public static final short SPRM_PROPRMARK = -13737;
    public static final short SPRM_FEMBOSS = 2136;
    public static final short SPRM_SFXTEXT = 10329;
    public static final short SPRM_DISPFLDRMARK = -13726;
    public static final short SPRM_IBSTRMARKDEL = 18531;
    public static final short SPRM_DTTMRMARKDEL = 26724;
    public static final short SPRM_BRC = 26725;
    public static final short SPRM_SHD = 18534;
    public static final short SPRM_IDSIRMARKDEL = 18535;
    public static final short SPRM_CPG = 18539;
    public static final short SPRM_NONFELID = 18541;
    public static final short SPRM_FELID = 18542;
    public static final short SPRM_IDCTHINT = 10351;
    protected short _istd;
    protected SprmBuffer _chpx;
    protected CharacterProperties _props;

    CharacterRun(CHPX cHPX, StyleSheet styleSheet, short s, Range range) {
        super(Math.max(range._start, cHPX.getStart()), Math.min(range._end, cHPX.getEnd()), range);
        this._props = cHPX.getCharacterProperties(styleSheet, s);
        this._chpx = cHPX.getSprmBuf();
        this._istd = s;
    }

    public int type() {
        return 1;
    }

    public boolean isMarkedDeleted() {
        return this._props.isFRMarkDel();
    }

    public void markDeleted(boolean bl) {
        this._props.setFRMarkDel(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2048, by);
    }

    public boolean isBold() {
        return this._props.isFBold();
    }

    public void setBold(boolean bl) {
        this._props.setFBold(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2101, by);
    }

    public boolean isItalic() {
        return this._props.isFItalic();
    }

    public void setItalic(boolean bl) {
        this._props.setFItalic(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2102, by);
    }

    public boolean isOutlined() {
        return this._props.isFOutline();
    }

    public void setOutline(boolean bl) {
        this._props.setFOutline(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2104, by);
    }

    public boolean isFldVanished() {
        return this._props.isFFldVanish();
    }

    public void setFldVanish(boolean bl) {
        this._props.setFFldVanish(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2050, by);
    }

    public boolean isSmallCaps() {
        return this._props.isFSmallCaps();
    }

    public void setSmallCaps(boolean bl) {
        this._props.setFSmallCaps(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2106, by);
    }

    public boolean isCapitalized() {
        return this._props.isFCaps();
    }

    public void setCapitalized(boolean bl) {
        this._props.setFCaps(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2107, by);
    }

    public boolean isVanished() {
        return this._props.isFVanish();
    }

    public void setVanished(boolean bl) {
        this._props.setFVanish(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2108, by);
    }

    public boolean isMarkedInserted() {
        return this._props.isFRMark();
    }

    public void markInserted(boolean bl) {
        this._props.setFRMark(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2049, by);
    }

    public boolean isStrikeThrough() {
        return this._props.isFStrike();
    }

    public void setStrikeThrough(boolean bl) {
        this.strikeThrough(bl);
    }

    public void strikeThrough(boolean bl) {
        this._props.setFStrike(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2103, by);
    }

    public boolean isShadowed() {
        return this._props.isFShadow();
    }

    public void setShadow(boolean bl) {
        this._props.setFShadow(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2105, by);
    }

    public boolean isEmbossed() {
        return this._props.isFEmboss();
    }

    public void setEmbossed(boolean bl) {
        this._props.setFEmboss(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2136, by);
    }

    public boolean isImprinted() {
        return this._props.isFImprint();
    }

    public void setImprinted(boolean bl) {
        this._props.setFImprint(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2132, by);
    }

    public boolean isDoubleStrikeThrough() {
        return this._props.isFDStrike();
    }

    public void setDoubleStrikethrough(boolean bl) {
        this._props.setFDStrike(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)10835, by);
    }

    public void setFtcAscii(int n) {
        this._props.setFtcAscii(n);
        this._chpx.updateSprm((short)19023, (short)n);
    }

    public void setFtcFE(int n) {
        this._props.setFtcFE(n);
        this._chpx.updateSprm((short)19024, (short)n);
    }

    public void setFtcOther(int n) {
        this._props.setFtcOther(n);
        this._chpx.updateSprm((short)19025, (short)n);
    }

    public int getFontSize() {
        return this._props.getHps();
    }

    public void setFontSize(int n) {
        this._props.setHps(n);
        this._chpx.updateSprm((short)19011, (short)n);
    }

    public int getCharacterSpacing() {
        return this._props.getDxaSpace();
    }

    public void setCharacterSpacing(int n) {
        this._props.setDxaSpace(n);
        this._chpx.updateSprm((short)-30656, n);
    }

    public short getSubSuperScriptIndex() {
        return this._props.getIss();
    }

    public void setSubSuperScriptIndex(short s) {
        this._props.setDxaSpace(s);
        this._chpx.updateSprm((short)-30656, s);
    }

    public int getUnderlineCode() {
        return this._props.getKul();
    }

    public void setUnderlineCode(int n) {
        this._props.setKul((byte)n);
        this._chpx.updateSprm((short)10814, (byte)n);
    }

    public int getColor() {
        return this._props.getIco();
    }

    public void setColor(int n) {
        this._props.setIco((byte)n);
        this._chpx.updateSprm((short)10818, (byte)n);
    }

    public int getVerticalOffset() {
        return this._props.getHpsPos();
    }

    public void setVerticalOffset(int n) {
        this._props.setHpsPos((short)n);
        this._chpx.updateSprm((short)18501, (byte)n);
    }

    public int getKerning() {
        return this._props.getHpsKern();
    }

    public void setKerning(int n) {
        this._props.setHpsKern(n);
        this._chpx.updateSprm((short)18507, (short)n);
    }

    public boolean isHighlighted() {
        return this._props.isFHighlight();
    }

    public byte getHighlightedColor() {
        return this._props.getIcoHighlight();
    }

    public void setHighlighted(byte by) {
        this._props.setFHighlight(true);
        this._props.setIcoHighlight(by);
        this._chpx.updateSprm((short)10764, by);
    }

    public String getFontName() {
        if (this._doc.getFontTable() == null) {
            return null;
        }
        return this._doc.getFontTable().getMainFont(this._props.getFtcAscii());
    }

    public boolean isSpecialCharacter() {
        return this._props.isFSpec();
    }

    public void setSpecialCharacter(boolean bl) {
        this._props.setFSpec(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2133, by);
    }

    public boolean isObj() {
        return this._props.isFObj();
    }

    public void setObj(boolean bl) {
        this._props.setFObj(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2134, by);
    }

    public int getPicOffset() {
        return this._props.getFcPic();
    }

    public void setPicOffset(int n) {
        this._props.setFcPic(n);
        this._chpx.updateSprm((short)27139, n);
    }

    public boolean isData() {
        return this._props.isFData();
    }

    public void setData(boolean bl) {
        this._props.setFData(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2134, by);
    }

    public boolean isOle2() {
        return this._props.isFOle2();
    }

    public void setOle2(boolean bl) {
        this._props.setFOle2(bl);
        byte by = (byte)(bl ? 1 : 0);
        this._chpx.updateSprm((short)2134, by);
    }

    public int getObjOffset() {
        return this._props.getFcObj();
    }

    public void setObjOffset(int n) {
        this._props.setFcObj(n);
        this._chpx.updateSprm((short)26638, n);
    }

    public int getIco24() {
        return this._props.getIco24();
    }

    public void setIco24(int n) {
        this._props.setIco24(n);
    }

    @Deprecated
    public CharacterProperties cloneProperties() {
        return this._props.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        CharacterRun characterRun = (CharacterRun)super.clone();
        characterRun._props.setDttmRMark((DateAndTime)this._props.getDttmRMark().clone());
        characterRun._props.setDttmRMarkDel((DateAndTime)this._props.getDttmRMarkDel().clone());
        characterRun._props.setDttmPropRMark((DateAndTime)this._props.getDttmPropRMark().clone());
        characterRun._props.setDttmDispFldRMark((DateAndTime)this._props.getDttmDispFldRMark().clone());
        characterRun._props.setXstDispFldRMark((byte[])this._props.getXstDispFldRMark().clone());
        characterRun._props.setShd(this._props.getShd().clone());
        return characterRun;
    }

    public boolean isSymbol() {
        return this.isSpecialCharacter() && this.text().equals("(");
    }

    public char getSymbolCharacter() {
        if (this.isSymbol()) {
            return (char)this._props.getXchSym();
        }
        throw new IllegalStateException("Not a symbol CharacterRun");
    }

    public Ffn getSymbolFont() {
        if (this.isSymbol()) {
            if (this._doc.getFontTable() == null) {
                return null;
            }
            Ffn[] ffnArray = this._doc.getFontTable().getFontNames();
            if (ffnArray.length <= this._props.getFtcSym()) {
                return null;
            }
            return ffnArray[this._props.getFtcSym()];
        }
        throw new IllegalStateException("Not a symbol CharacterRun");
    }

    public BorderCode getBorder() {
        return this._props.getBrc();
    }

    public int getLanguageCode() {
        return this._props.getLidDefault();
    }

    public short getStyleIndex() {
        return this._istd;
    }

    public String toString() {
        String string = this.text();
        return "CharacterRun of " + string.length() + " characters - " + string;
    }

    public String[] getDropDownListValues() {
        char c;
        if (this.getDocument() instanceof HWPFDocument && (c = this._text.charAt(this._start)) == '\u0001') {
            NilPICFAndBinData nilPICFAndBinData = new NilPICFAndBinData(((HWPFDocument)this.getDocument()).getDataStream(), this.getPicOffset());
            FFData fFData = new FFData(nilPICFAndBinData.getBinData(), 0);
            String[] stringArray = fFData.getDropList();
            return stringArray;
        }
        return null;
    }

    public Integer getDropDownListDefaultItemIndex() {
        char c;
        if (this.getDocument() instanceof HWPFDocument && (c = this._text.charAt(this._start)) == '\u0001') {
            NilPICFAndBinData nilPICFAndBinData = new NilPICFAndBinData(((HWPFDocument)this.getDocument()).getDataStream(), this.getPicOffset());
            FFData fFData = new FFData(nilPICFAndBinData.getBinData(), 0);
            return fFData.getDefaultDropDownItemIndex();
        }
        return null;
    }
}

