/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.usermodel;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.LittleEndian;

public final class BorderCode
implements Cloneable {
    public static final int SIZE = 4;
    private short _info;
    private static final BitField _dptLineWidth = BitFieldFactory.getInstance(255);
    private static final BitField _brcType = BitFieldFactory.getInstance(65280);
    private short _info2;
    private static final BitField _ico = BitFieldFactory.getInstance(255);
    private static final BitField _dptSpace = BitFieldFactory.getInstance(7936);
    private static final BitField _fShadow = BitFieldFactory.getInstance(8192);
    private static final BitField _fFrame = BitFieldFactory.getInstance(16384);

    public BorderCode() {
    }

    public BorderCode(byte[] byArray, int n) {
        this._info = LittleEndian.getShort(byArray, n);
        this._info2 = LittleEndian.getShort(byArray, n + 2);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this._info);
        LittleEndian.putShort(byArray, n + 2, this._info2);
    }

    public int toInt() {
        byte[] byArray = new byte[4];
        this.serialize(byArray, 0);
        return LittleEndian.getInt(byArray);
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0 || this._info == -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BorderCode)) {
            return false;
        }
        BorderCode borderCode = (BorderCode)object;
        return this._info == borderCode._info && this._info2 == borderCode._info2;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getLineWidth() {
        return _dptLineWidth.getShortValue(this._info);
    }

    public void setLineWidth(int n) {
        _dptLineWidth.setValue(this._info, n);
    }

    public int getBorderType() {
        return _brcType.getShortValue(this._info);
    }

    public void setBorderType(int n) {
        _brcType.setValue(this._info, n);
    }

    public short getColor() {
        return _ico.getShortValue(this._info2);
    }

    public void setColor(short s) {
        _ico.setValue(this._info2, s);
    }

    public int getSpace() {
        return _dptSpace.getShortValue(this._info2);
    }

    public void setSpace(int n) {
        _dptSpace.setValue(this._info2, n);
    }

    public boolean isShadow() {
        return _fShadow.getValue(this._info2) != 0;
    }

    public void setShadow(boolean bl) {
        _fShadow.setValue(this._info2, bl ? 1 : 0);
    }

    public boolean isFrame() {
        return _fFrame.getValue(this._info2) != 0;
    }

    public void setFrame(boolean bl) {
        _fFrame.setValue(this._info2, bl ? 1 : 0);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[BRC] EMPTY";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BRC]\n");
        stringBuffer.append("        .dptLineWidth         = ");
        stringBuffer.append(" (").append(this.getLineWidth()).append(" )\n");
        stringBuffer.append("        .brcType              = ");
        stringBuffer.append(" (").append(this.getBorderType()).append(" )\n");
        stringBuffer.append("        .ico                  = ");
        stringBuffer.append(" (").append(this.getColor()).append(" )\n");
        stringBuffer.append("        .dptSpace             = ");
        stringBuffer.append(" (").append(this.getSpace()).append(" )\n");
        stringBuffer.append("        .fShadow              = ");
        stringBuffer.append(" (").append(this.isShadow()).append(" )\n");
        stringBuffer.append("        .fFrame               = ");
        stringBuffer.append(" (").append(this.isFrame()).append(" )\n");
        return stringBuffer.toString();
    }
}

