/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.sprm.SprmIterator;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.hwpf.sprm.SprmUncompressor;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.TableCellDescriptor;
import ai2.org.apache.poi.hwpf.usermodel.TableProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

@Internal
public final class TableSprmUncompressor
extends SprmUncompressor {
    private static final POILogger logger = POILogFactory.getLogger(TableSprmUncompressor.class);

    @Deprecated
    public static TableProperties uncompressTAP(byte[] byArray, int n) {
        TableProperties tableProperties = new TableProperties();
        SprmIterator sprmIterator = new SprmIterator(byArray, n);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            if (sprmOperation.getType() != 5) continue;
            try {
                TableSprmUncompressor.unCompressTAPOperation(tableProperties, sprmOperation);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.log(7, "Unable to apply ", sprmOperation, ": ", arrayIndexOutOfBoundsException, arrayIndexOutOfBoundsException);
            }
        }
        return tableProperties;
    }

    public static TableProperties uncompressTAP(SprmBuffer sprmBuffer) {
        TableProperties tableProperties;
        Object object;
        SprmOperation sprmOperation = sprmBuffer.findSprm((short)-10744);
        if (sprmOperation != null) {
            object = sprmOperation.getGrpprl();
            int n = sprmOperation.getGrpprlOffset();
            short s = object[n];
            tableProperties = new TableProperties(s);
        } else {
            logger.log(5, new Object[]{"Some table rows didn't specify number of columns in SPRMs"});
            tableProperties = new TableProperties(1);
        }
        object = sprmBuffer.iterator();
        while (((SprmIterator)object).hasNext()) {
            SprmOperation sprmOperation2 = ((SprmIterator)object).next();
            if (sprmOperation2.getType() != 5) continue;
            try {
                TableSprmUncompressor.unCompressTAPOperation(tableProperties, sprmOperation2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.log(7, "Unable to apply ", sprmOperation2, ": ", arrayIndexOutOfBoundsException, arrayIndexOutOfBoundsException);
            }
        }
        return tableProperties;
    }

    static void unCompressTAPOperation(TableProperties tableProperties, SprmOperation sprmOperation) {
        switch (sprmOperation.getOperation()) {
            case 0: {
                tableProperties.setJc((short)sprmOperation.getOperand());
                break;
            }
            case 1: {
                short[] sArray = tableProperties.getRgdxaCenter();
                int n = tableProperties.getItcMac();
                int n2 = sprmOperation.getOperand() - (sArray[0] + tableProperties.getDxaGapHalf());
                int n3 = 0;
                while (n3 < n) {
                    int n4 = n3++;
                    sArray[n4] = (short)(sArray[n4] + n2);
                }
                break;
            }
            case 2: {
                short[] sArray = tableProperties.getRgdxaCenter();
                if (sArray != null) {
                    int n = tableProperties.getDxaGapHalf() - sprmOperation.getOperand();
                    sArray[0] = (short)(sArray[0] + n);
                }
                tableProperties.setDxaGapHalf(sprmOperation.getOperand());
                break;
            }
            case 3: {
                tableProperties.setFCantSplit(TableSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 4: {
                tableProperties.setFTableHeader(TableSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 5: {
                byte[] byArray = sprmOperation.getGrpprl();
                int n = sprmOperation.getGrpprlOffset();
                tableProperties.setBrcTop(new BorderCode(byArray, n));
                tableProperties.setBrcLeft(new BorderCode(byArray, n += 4));
                tableProperties.setBrcBottom(new BorderCode(byArray, n += 4));
                tableProperties.setBrcRight(new BorderCode(byArray, n += 4));
                tableProperties.setBrcHorizontal(new BorderCode(byArray, n += 4));
                tableProperties.setBrcVertical(new BorderCode(byArray, n += 4));
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                tableProperties.setDyaRowHeight(sprmOperation.getOperand());
                break;
            }
            case 8: {
                int n;
                byte[] byArray = sprmOperation.getGrpprl();
                int n5 = sprmOperation.getGrpprlOffset();
                int n6 = byArray[n5];
                short[] sArray = new short[n6 + 1];
                TableCellDescriptor[] tableCellDescriptorArray = new TableCellDescriptor[n6];
                tableProperties.setItcMac((short)n6);
                tableProperties.setRgdxaCenter(sArray);
                tableProperties.setRgtc(tableCellDescriptorArray);
                for (n = 0; n < n6; ++n) {
                    sArray[n] = LittleEndian.getShort(byArray, n5 + (1 + n * 2));
                }
                int n7 = n5 + (1 + (n6 + 1) * 2);
                n = n5 + sprmOperation.size() - 6;
                boolean bl = n7 < n;
                for (int i = 0; i < n6; ++i) {
                    tableCellDescriptorArray[i] = bl && n5 + (1 + (n6 + 1) * 2 + i * 20) < byArray.length ? TableCellDescriptor.convertBytesToTC(byArray, n5 + (1 + (n6 + 1) * 2 + i * 20)) : new TableCellDescriptor();
                }
                sArray[n6] = LittleEndian.getShort(byArray, n5 + (1 + n6 * 2));
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                int n = sprmOperation.getOperand();
                int n8 = (n & 0xFF000000) >> 24;
                int n9 = (n & 0xFF0000) >> 16;
                int n10 = n & 0xFFFF;
                short s = tableProperties.getItcMac();
                short[] sArray = new short[s + n9 + 1];
                TableCellDescriptor[] tableCellDescriptorArray = new TableCellDescriptor[s + n9];
                if (n8 >= s) {
                    n8 = s;
                    System.arraycopy(tableProperties.getRgdxaCenter(), 0, sArray, 0, s + 1);
                    System.arraycopy(tableProperties.getRgtc(), 0, tableCellDescriptorArray, 0, s);
                } else {
                    System.arraycopy(tableProperties.getRgdxaCenter(), 0, sArray, 0, n8 + 1);
                    System.arraycopy(tableProperties.getRgdxaCenter(), n8 + 1, sArray, n8 + n9, s - n8);
                    System.arraycopy(tableProperties.getRgtc(), 0, tableCellDescriptorArray, 0, n8);
                    System.arraycopy(tableProperties.getRgtc(), n8, tableCellDescriptorArray, n8 + n9, s - n8);
                }
                for (int i = n8; i < n8 + n9; ++i) {
                    tableCellDescriptorArray[i] = new TableCellDescriptor();
                    sArray[i] = (short)(sArray[i - 1] + n10);
                }
                sArray[n8 + n9] = (short)(sArray[n8 + n9 - 1] + n10);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 52: {
                int n = sprmOperation.getGrpprl()[sprmOperation.getGrpprlOffset()];
                byte by = sprmOperation.getGrpprl()[sprmOperation.getGrpprlOffset() + 1];
                byte by2 = sprmOperation.getGrpprl()[sprmOperation.getGrpprlOffset() + 2];
                byte by3 = sprmOperation.getGrpprl()[sprmOperation.getGrpprlOffset() + 3];
                short s = LittleEndian.getShort(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset() + 4);
                for (int i = n; i < by; ++i) {
                    TableCellDescriptor tableCellDescriptor = tableProperties.getRgtc()[i];
                    if ((by2 & 1) != 0) {
                        tableCellDescriptor.setFtsCellPaddingTop(by3);
                        tableCellDescriptor.setWCellPaddingTop(s);
                    }
                    if ((by2 & 2) != 0) {
                        tableCellDescriptor.setFtsCellPaddingLeft(by3);
                        tableCellDescriptor.setWCellPaddingLeft(s);
                    }
                    if ((by2 & 4) != 0) {
                        tableCellDescriptor.setFtsCellPaddingBottom(by3);
                        tableCellDescriptor.setWCellPaddingBottom(s);
                    }
                    if ((by2 & 8) == 0) continue;
                    tableCellDescriptor.setFtsCellPaddingRight(by3);
                    tableCellDescriptor.setWCellPaddingRight(s);
                }
                break;
            }
        }
    }
}

