/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class SprmUtils {
    public static byte[] shortArrayToByteArray(short[] sArray) {
        byte[] byArray = new byte[sArray.length * 2];
        for (int i = 0; i < sArray.length; ++i) {
            LittleEndian.putShort(byArray, i * 2, sArray[i]);
        }
        return byArray;
    }

    public static int addSpecialSprm(short s, byte[] byArray, List<byte[]> list) {
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        LittleEndian.putShort(byArray2, s);
        LittleEndian.putShort(byArray2, 2, (short)(byArray.length + 1));
        list.add(byArray2);
        return byArray2.length;
    }

    public static int addSprm(short s, boolean bl, List<byte[]> list) {
        return SprmUtils.addSprm(s, bl ? 1 : 0, null, list);
    }

    public static int addSprm(short s, int n, byte[] byArray, List<byte[]> list) {
        int n2 = (s & 0xE000) >> 13;
        byte[] byArray2 = null;
        switch (n2) {
            case 0: 
            case 1: {
                byArray2 = new byte[3];
                byArray2[2] = (byte)n;
                break;
            }
            case 2: {
                byArray2 = new byte[4];
                LittleEndian.putShort(byArray2, 2, (short)n);
                break;
            }
            case 3: {
                byArray2 = new byte[6];
                LittleEndian.putInt(byArray2, 2, n);
                break;
            }
            case 4: 
            case 5: {
                byArray2 = new byte[4];
                LittleEndian.putShort(byArray2, 2, (short)n);
                break;
            }
            case 6: {
                byArray2 = new byte[3 + byArray.length];
                byArray2[2] = (byte)byArray.length;
                System.arraycopy(byArray, 0, byArray2, 3, byArray.length);
                break;
            }
            case 7: {
                byArray2 = new byte[5];
                byte[] byArray3 = new byte[4];
                LittleEndian.putInt(byArray3, 0, n);
                System.arraycopy(byArray3, 0, byArray2, 2, 3);
                break;
            }
            default: {
                throw new RuntimeException("Invalid sprm type");
            }
        }
        LittleEndian.putShort(byArray2, 0, s);
        list.add(byArray2);
        return byArray2.length;
    }

    public static byte[] getGrpprl(List<byte[]> list, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = list.size() - 1; i >= 0; --i) {
            byte[] byArray2 = list.remove(0);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    public static int convertBrcToInt(short[] sArray) {
        byte[] byArray = new byte[4];
        LittleEndian.putShort(byArray, sArray[0]);
        LittleEndian.putShort(byArray, 2, sArray[1]);
        return LittleEndian.getInt(byArray);
    }
}

