/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public final class SprmOperation {
    private static final BitField BITFIELD_OP = BitFieldFactory.getInstance(511);
    private static final BitField BITFIELD_SIZECODE = BitFieldFactory.getInstance(57344);
    private static final BitField BITFIELD_SPECIAL = BitFieldFactory.getInstance(512);
    private static final BitField BITFIELD_TYPE = BitFieldFactory.getInstance(7168);
    private static final short SPRM_LONG_PARAGRAPH = -14827;
    private static final short SPRM_LONG_TABLE = -10744;
    public static final int TYPE_PAP = 1;
    public static final int TYPE_CHP = 2;
    public static final int TYPE_PIC = 3;
    public static final int TYPE_SEP = 4;
    public static final int TYPE_TAP = 5;
    @Deprecated
    public static final int PAP_TYPE = 1;
    @Deprecated
    public static final int TAP_TYPE = 5;
    private int _offset;
    private int _gOffset;
    private byte[] _grpprl;
    private int _size;
    private short _value;

    public static int getOperationFromOpcode(short s) {
        return BITFIELD_OP.getValue(s);
    }

    public static int getTypeFromOpcode(short s) {
        return BITFIELD_TYPE.getValue(s);
    }

    public SprmOperation(byte[] byArray, int n) {
        this._grpprl = byArray;
        this._value = LittleEndian.getShort(byArray, n);
        this._offset = n;
        this._gOffset = n + 2;
        this._size = this.initSize(this._value);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        System.arraycopy(this._grpprl, this._offset, byArray, 0, this.size());
        return byArray;
    }

    public byte[] getGrpprl() {
        return this._grpprl;
    }

    public int getGrpprlOffset() {
        return this._gOffset;
    }

    public int getOperand() {
        switch (this.getSizeCode()) {
            case 0: 
            case 1: {
                return this._grpprl[this._gOffset];
            }
            case 2: 
            case 4: 
            case 5: {
                return LittleEndian.getShort(this._grpprl, this._gOffset);
            }
            case 3: {
                return LittleEndian.getInt(this._grpprl, this._gOffset);
            }
            case 6: {
                int n = this._grpprl[this._gOffset + 1];
                byte[] byArray = new byte[4];
                for (int i = 0; i < n; ++i) {
                    if (this._gOffset + i >= this._grpprl.length) continue;
                    byArray[i] = this._grpprl[this._gOffset + 1 + i];
                }
                return LittleEndian.getInt(byArray, 0);
            }
            case 7: {
                byte[] byArray = new byte[]{this._grpprl[this._gOffset], this._grpprl[this._gOffset + 1], this._grpprl[this._gOffset + 2], 0};
                return LittleEndian.getInt(byArray, 0);
            }
        }
        throw new IllegalArgumentException("SPRM contains an invalid size code");
    }

    public short getOperandShortSigned() {
        if (this.getSizeCode() != 2 && this.getSizeCode() != 4 && this.getSizeCode() != 5) {
            throw new UnsupportedOperationException("Current SPRM doesn't have signed short operand: " + this);
        }
        return LittleEndian.getShort(this._grpprl, this._gOffset);
    }

    public int getOperation() {
        return BITFIELD_OP.getValue(this._value);
    }

    public int getSizeCode() {
        return BITFIELD_SIZECODE.getValue(this._value);
    }

    public int getType() {
        return BITFIELD_TYPE.getValue(this._value);
    }

    private int initSize(short s) {
        switch (this.getSizeCode()) {
            case 0: 
            case 1: {
                return 3;
            }
            case 2: 
            case 4: 
            case 5: {
                return 4;
            }
            case 3: {
                return 6;
            }
            case 6: {
                int n = this._gOffset;
                if (s == -10744 || s == -14827) {
                    int n2 = (0xFFFF & LittleEndian.getShort(this._grpprl, n)) + 3;
                    this._gOffset += 2;
                    return n2;
                }
                return (0xFF & this._grpprl[this._gOffset++]) + 3;
            }
            case 7: {
                return 5;
            }
        }
        throw new IllegalArgumentException("SPRM contains an invalid size code");
    }

    public int size() {
        return this._size;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[SPRM] (0x");
        stringBuilder.append(Integer.toHexString(this._value & 0xFFFF));
        stringBuilder.append("): ");
        try {
            stringBuilder.append(this.getOperand());
        }
        catch (Exception exception) {
            stringBuilder.append("(error)");
        }
        return stringBuilder.toString();
    }
}

