/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.hwpf.sprm.SprmIterator;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

@Internal
public final class SprmBuffer
implements Cloneable {
    byte[] _buf;
    boolean _istd;
    int _offset;
    private final int _sprmsStartOffset;

    @Deprecated
    public SprmBuffer() {
        this(0);
    }

    @Deprecated
    public SprmBuffer(byte[] byArray) {
        this(byArray, 0);
    }

    @Deprecated
    public SprmBuffer(byte[] byArray, boolean bl) {
        this(byArray, bl, 0);
    }

    public SprmBuffer(byte[] byArray, boolean bl, int n) {
        this._offset = byArray.length;
        this._buf = byArray;
        this._istd = bl;
        this._sprmsStartOffset = n;
    }

    public SprmBuffer(byte[] byArray, int n) {
        this(byArray, false, n);
    }

    public SprmBuffer(int n) {
        this._buf = new byte[n + 4];
        this._offset = n;
        this._sprmsStartOffset = n;
    }

    public void addSprm(short s, byte by) {
        int n = 3;
        this.ensureCapacity(n);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        this._buf[this._offset++] = by;
    }

    public void addSprm(short s, byte[] byArray) {
        int n = 3 + byArray.length;
        this.ensureCapacity(n);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        this._buf[this._offset++] = (byte)byArray.length;
        System.arraycopy(byArray, 0, this._buf, this._offset, byArray.length);
    }

    public void addSprm(short s, int n) {
        int n2 = 6;
        this.ensureCapacity(n2);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        LittleEndian.putInt(this._buf, this._offset, n);
        this._offset += 4;
    }

    public void addSprm(short s, short s2) {
        int n = 4;
        this.ensureCapacity(n);
        LittleEndian.putShort(this._buf, this._offset, s);
        this._offset += 2;
        LittleEndian.putShort(this._buf, this._offset, s2);
        this._offset += 2;
    }

    public void append(byte[] byArray) {
        this.append(byArray, 0);
    }

    public void append(byte[] byArray, int n) {
        this.ensureCapacity(byArray.length - n);
        System.arraycopy(byArray, n, this._buf, this._offset, byArray.length - n);
        this._offset += byArray.length - n;
    }

    public Object clone() throws CloneNotSupportedException {
        SprmBuffer sprmBuffer = (SprmBuffer)super.clone();
        sprmBuffer._buf = new byte[this._buf.length];
        System.arraycopy(this._buf, 0, sprmBuffer._buf, 0, this._buf.length);
        return sprmBuffer;
    }

    private void ensureCapacity(int n) {
        if (this._offset + n >= this._buf.length) {
            byte[] byArray = new byte[this._offset + n];
            System.arraycopy(this._buf, 0, byArray, 0, this._buf.length);
            this._buf = byArray;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SprmBuffer)) {
            return false;
        }
        SprmBuffer sprmBuffer = (SprmBuffer)object;
        return Arrays.equals(this._buf, sprmBuffer._buf);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public SprmOperation findSprm(short s) {
        int n = SprmOperation.getOperationFromOpcode(s);
        int n2 = SprmOperation.getTypeFromOpcode(s);
        SprmIterator sprmIterator = new SprmIterator(this._buf, 2);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            if (sprmOperation.getOperation() != n || sprmOperation.getType() != n2) continue;
            return sprmOperation;
        }
        return null;
    }

    private int findSprmOffset(short s) {
        SprmOperation sprmOperation = this.findSprm(s);
        if (sprmOperation == null) {
            return -1;
        }
        return sprmOperation.getGrpprlOffset();
    }

    public byte[] toByteArray() {
        return this._buf;
    }

    public SprmIterator iterator() {
        return new SprmIterator(this._buf, this._sprmsStartOffset);
    }

    public void updateSprm(short s, byte by) {
        int n = this.findSprmOffset(s);
        if (n != -1) {
            this._buf[n] = by;
            return;
        }
        this.addSprm(s, by);
    }

    public void updateSprm(short s, boolean bl) {
        int n = this.findSprmOffset(s);
        if (n != -1) {
            this._buf[n] = (byte)(bl ? 1 : 0);
            return;
        }
        this.addSprm(s, bl ? 1 : 0);
    }

    public void updateSprm(short s, int n) {
        int n2 = this.findSprmOffset(s);
        if (n2 != -1) {
            LittleEndian.putInt(this._buf, n2, n);
            return;
        }
        this.addSprm(s, n);
    }

    public void updateSprm(short s, short s2) {
        int n = this.findSprmOffset(s);
        if (n != -1) {
            LittleEndian.putShort(this._buf, n, s2);
            return;
        }
        this.addSprm(s, s2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Sprms (");
        stringBuilder.append(this._buf.length);
        stringBuilder.append(" byte(s)): ");
        SprmIterator sprmIterator = this.iterator();
        while (sprmIterator.hasNext()) {
            try {
                stringBuilder.append(sprmIterator.next());
            }
            catch (Exception exception) {
                stringBuilder.append("error");
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }
}

