/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.hwpf.sprm.SprmIterator;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.hwpf.sprm.SprmUncompressor;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.SectionProperties;
import ai2.org.apache.poi.util.Internal;

@Internal
public final class SectionSprmUncompressor
extends SprmUncompressor {
    public static SectionProperties uncompressSEP(byte[] byArray, int n) {
        SectionProperties sectionProperties = new SectionProperties();
        SprmIterator sprmIterator = new SprmIterator(byArray, n);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            SectionSprmUncompressor.unCompressSEPOperation(sectionProperties, sprmOperation);
        }
        return sectionProperties;
    }

    static void unCompressSEPOperation(SectionProperties sectionProperties, SprmOperation sprmOperation) {
        switch (sprmOperation.getOperation()) {
            case 0: {
                sectionProperties.setCnsPgn((byte)sprmOperation.getOperand());
                break;
            }
            case 1: {
                sectionProperties.setIHeadingPgn((byte)sprmOperation.getOperand());
                break;
            }
            case 2: {
                byte[] byArray = new byte[sprmOperation.size() - 3];
                System.arraycopy(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset(), byArray, 0, byArray.length);
                sectionProperties.setOlstAnm(byArray);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                sectionProperties.setFEvenlySpaced(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 6: {
                sectionProperties.setFUnlocked(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 7: {
                sectionProperties.setDmBinFirst((short)sprmOperation.getOperand());
                break;
            }
            case 8: {
                sectionProperties.setDmBinOther((short)sprmOperation.getOperand());
                break;
            }
            case 9: {
                sectionProperties.setBkc((byte)sprmOperation.getOperand());
                break;
            }
            case 10: {
                sectionProperties.setFTitlePage(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 11: {
                sectionProperties.setCcolM1((short)sprmOperation.getOperand());
                break;
            }
            case 12: {
                sectionProperties.setDxaColumns(sprmOperation.getOperand());
                break;
            }
            case 13: {
                sectionProperties.setFAutoPgn(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 14: {
                sectionProperties.setNfcPgn((byte)sprmOperation.getOperand());
                break;
            }
            case 15: {
                sectionProperties.setDyaPgn((short)sprmOperation.getOperand());
                break;
            }
            case 16: {
                sectionProperties.setDxaPgn((short)sprmOperation.getOperand());
                break;
            }
            case 17: {
                sectionProperties.setFPgnRestart(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 18: {
                sectionProperties.setFEndNote(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 19: {
                sectionProperties.setLnc((byte)sprmOperation.getOperand());
                break;
            }
            case 20: {
                sectionProperties.setGrpfIhdt((byte)sprmOperation.getOperand());
                break;
            }
            case 21: {
                sectionProperties.setNLnnMod((short)sprmOperation.getOperand());
                break;
            }
            case 22: {
                sectionProperties.setDxaLnn(sprmOperation.getOperand());
                break;
            }
            case 23: {
                sectionProperties.setDyaHdrTop(sprmOperation.getOperand());
                break;
            }
            case 24: {
                sectionProperties.setDyaHdrBottom(sprmOperation.getOperand());
                break;
            }
            case 25: {
                sectionProperties.setFLBetween(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 26: {
                sectionProperties.setVjc((byte)sprmOperation.getOperand());
                break;
            }
            case 27: {
                sectionProperties.setLnnMin((short)sprmOperation.getOperand());
                break;
            }
            case 28: {
                sectionProperties.setPgnStart((short)sprmOperation.getOperand());
                break;
            }
            case 29: {
                sectionProperties.setDmOrientPage(sprmOperation.getOperand() != 0);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                sectionProperties.setXaPage(sprmOperation.getOperand());
                break;
            }
            case 32: {
                sectionProperties.setYaPage(sprmOperation.getOperand());
                break;
            }
            case 33: {
                sectionProperties.setDxaLeft(sprmOperation.getOperand());
                break;
            }
            case 34: {
                sectionProperties.setDxaRight(sprmOperation.getOperand());
                break;
            }
            case 35: {
                sectionProperties.setDyaTop(sprmOperation.getOperand());
                break;
            }
            case 36: {
                sectionProperties.setDyaBottom(sprmOperation.getOperand());
                break;
            }
            case 37: {
                sectionProperties.setDzaGutter(sprmOperation.getOperand());
                break;
            }
            case 38: {
                sectionProperties.setDmPaperReq((short)sprmOperation.getOperand());
                break;
            }
            case 39: {
                sectionProperties.setFPropMark(SectionSprmUncompressor.getFlag(sprmOperation.getOperand()));
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                sectionProperties.setBrcTop(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 44: {
                sectionProperties.setBrcLeft(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 45: {
                sectionProperties.setBrcBottom(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 46: {
                sectionProperties.setBrcRight(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 47: {
                sectionProperties.setPgbProp(sprmOperation.getOperand());
                break;
            }
            case 48: {
                sectionProperties.setDxtCharSpace(sprmOperation.getOperand());
                break;
            }
            case 49: {
                sectionProperties.setDyaLinePitch(sprmOperation.getOperand());
                break;
            }
            case 51: {
                sectionProperties.setWTextFlow((short)sprmOperation.getOperand());
                break;
            }
        }
    }
}

