/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.sprm;

import ai2.org.apache.poi.hwpf.sprm.SprmUtils;
import ai2.org.apache.poi.hwpf.usermodel.SectionProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Arrays;

@Internal
public final class SectionSprmCompressor {
    private static final SectionProperties DEFAULT_SEP = new SectionProperties();

    public static byte[] compressSectionProperty(SectionProperties sectionProperties) {
        int n = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (sectionProperties.getCnsPgn() != DEFAULT_SEP.getCnsPgn()) {
            n += SprmUtils.addSprm((short)12288, sectionProperties.getCnsPgn(), null, arrayList);
        }
        if (sectionProperties.getIHeadingPgn() != DEFAULT_SEP.getIHeadingPgn()) {
            n += SprmUtils.addSprm((short)12289, sectionProperties.getIHeadingPgn(), null, arrayList);
        }
        if (!Arrays.equals(sectionProperties.getOlstAnm(), DEFAULT_SEP.getOlstAnm())) {
            n += SprmUtils.addSprm((short)-11774, 0, sectionProperties.getOlstAnm(), arrayList);
        }
        if (sectionProperties.getFEvenlySpaced() != DEFAULT_SEP.getFEvenlySpaced()) {
            n += SprmUtils.addSprm((short)12293, sectionProperties.getFEvenlySpaced() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getFUnlocked() != DEFAULT_SEP.getFUnlocked()) {
            n += SprmUtils.addSprm((short)12294, sectionProperties.getFUnlocked() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getDmBinFirst() != DEFAULT_SEP.getDmBinFirst()) {
            n += SprmUtils.addSprm((short)20487, sectionProperties.getDmBinFirst(), null, arrayList);
        }
        if (sectionProperties.getDmBinOther() != DEFAULT_SEP.getDmBinOther()) {
            n += SprmUtils.addSprm((short)20488, sectionProperties.getDmBinOther(), null, arrayList);
        }
        if (sectionProperties.getBkc() != DEFAULT_SEP.getBkc()) {
            n += SprmUtils.addSprm((short)12297, sectionProperties.getBkc(), null, arrayList);
        }
        if (sectionProperties.getFTitlePage() != DEFAULT_SEP.getFTitlePage()) {
            n += SprmUtils.addSprm((short)12298, sectionProperties.getFTitlePage() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getCcolM1() != DEFAULT_SEP.getCcolM1()) {
            n += SprmUtils.addSprm((short)20491, sectionProperties.getCcolM1(), null, arrayList);
        }
        if (sectionProperties.getDxaColumns() != DEFAULT_SEP.getDxaColumns()) {
            n += SprmUtils.addSprm((short)-28660, sectionProperties.getDxaColumns(), null, arrayList);
        }
        if (sectionProperties.getFAutoPgn() != DEFAULT_SEP.getFAutoPgn()) {
            n += SprmUtils.addSprm((short)12301, sectionProperties.getFAutoPgn() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getNfcPgn() != DEFAULT_SEP.getNfcPgn()) {
            n += SprmUtils.addSprm((short)12302, sectionProperties.getNfcPgn(), null, arrayList);
        }
        if (sectionProperties.getDyaPgn() != DEFAULT_SEP.getDyaPgn()) {
            n += SprmUtils.addSprm((short)-20465, sectionProperties.getDyaPgn(), null, arrayList);
        }
        if (sectionProperties.getDxaPgn() != DEFAULT_SEP.getDxaPgn()) {
            n += SprmUtils.addSprm((short)-20464, sectionProperties.getDxaPgn(), null, arrayList);
        }
        if (sectionProperties.getFPgnRestart() != DEFAULT_SEP.getFPgnRestart()) {
            n += SprmUtils.addSprm((short)12305, sectionProperties.getFPgnRestart() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getFEndNote() != DEFAULT_SEP.getFEndNote()) {
            n += SprmUtils.addSprm((short)12306, sectionProperties.getFEndNote() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getLnc() != DEFAULT_SEP.getLnc()) {
            n += SprmUtils.addSprm((short)12307, sectionProperties.getLnc(), null, arrayList);
        }
        if (sectionProperties.getGrpfIhdt() != DEFAULT_SEP.getGrpfIhdt()) {
            n += SprmUtils.addSprm((short)12308, sectionProperties.getGrpfIhdt(), null, arrayList);
        }
        if (sectionProperties.getNLnnMod() != DEFAULT_SEP.getNLnnMod()) {
            n += SprmUtils.addSprm((short)20501, sectionProperties.getNLnnMod(), null, arrayList);
        }
        if (sectionProperties.getDxaLnn() != DEFAULT_SEP.getDxaLnn()) {
            n += SprmUtils.addSprm((short)-28650, sectionProperties.getDxaLnn(), null, arrayList);
        }
        if (sectionProperties.getDyaHdrTop() != DEFAULT_SEP.getDyaHdrTop()) {
            n += SprmUtils.addSprm((short)-20457, sectionProperties.getDyaHdrTop(), null, arrayList);
        }
        if (sectionProperties.getDyaHdrBottom() != DEFAULT_SEP.getDyaHdrBottom()) {
            n += SprmUtils.addSprm((short)-20456, sectionProperties.getDyaHdrBottom(), null, arrayList);
        }
        if (sectionProperties.getFLBetween() != DEFAULT_SEP.getFLBetween()) {
            n += SprmUtils.addSprm((short)12313, sectionProperties.getFLBetween() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getVjc() != DEFAULT_SEP.getVjc()) {
            n += SprmUtils.addSprm((short)12314, sectionProperties.getVjc(), null, arrayList);
        }
        if (sectionProperties.getLnnMin() != DEFAULT_SEP.getLnnMin()) {
            n += SprmUtils.addSprm((short)20507, sectionProperties.getLnnMin(), null, arrayList);
        }
        if (sectionProperties.getPgnStart() != DEFAULT_SEP.getPgnStart()) {
            n += SprmUtils.addSprm((short)20508, sectionProperties.getPgnStart(), null, arrayList);
        }
        if (sectionProperties.getDmOrientPage() != DEFAULT_SEP.getDmOrientPage()) {
            n += SprmUtils.addSprm((short)12317, sectionProperties.getDmOrientPage() ? 1 : 0, null, arrayList);
        }
        if (sectionProperties.getXaPage() != DEFAULT_SEP.getXaPage()) {
            n += SprmUtils.addSprm((short)-20449, sectionProperties.getXaPage(), null, arrayList);
        }
        if (sectionProperties.getYaPage() != DEFAULT_SEP.getYaPage()) {
            n += SprmUtils.addSprm((short)-20448, sectionProperties.getYaPage(), null, arrayList);
        }
        if (sectionProperties.getDxaLeft() != DEFAULT_SEP.getDxaLeft()) {
            n += SprmUtils.addSprm((short)-20447, sectionProperties.getDxaLeft(), null, arrayList);
        }
        if (sectionProperties.getDxaRight() != DEFAULT_SEP.getDxaRight()) {
            n += SprmUtils.addSprm((short)-20446, sectionProperties.getDxaRight(), null, arrayList);
        }
        if (sectionProperties.getDyaTop() != DEFAULT_SEP.getDyaTop()) {
            n += SprmUtils.addSprm((short)-28637, sectionProperties.getDyaTop(), null, arrayList);
        }
        if (sectionProperties.getDyaBottom() != DEFAULT_SEP.getDyaBottom()) {
            n += SprmUtils.addSprm((short)-28636, sectionProperties.getDyaBottom(), null, arrayList);
        }
        if (sectionProperties.getDzaGutter() != DEFAULT_SEP.getDzaGutter()) {
            n += SprmUtils.addSprm((short)-20443, sectionProperties.getDzaGutter(), null, arrayList);
        }
        if (sectionProperties.getDmPaperReq() != DEFAULT_SEP.getDmPaperReq()) {
            n += SprmUtils.addSprm((short)20518, sectionProperties.getDmPaperReq(), null, arrayList);
        }
        if (sectionProperties.getFPropMark() != DEFAULT_SEP.getFPropMark() || sectionProperties.getIbstPropRMark() != DEFAULT_SEP.getIbstPropRMark() || !sectionProperties.getDttmPropRMark().equals(DEFAULT_SEP.getDttmPropRMark())) {
            byte[] byArray = new byte[7];
            byArray[0] = (byte)(sectionProperties.getFPropMark() ? 1 : 0);
            int n2 = 1;
            LittleEndian.putShort(byArray, (short)sectionProperties.getIbstPropRMark());
            sectionProperties.getDttmPropRMark().serialize(byArray, n2 += 2);
            n += SprmUtils.addSprm((short)-11737, -1, byArray, arrayList);
        }
        if (!sectionProperties.getBrcTop().equals(DEFAULT_SEP.getBrcTop())) {
            n += SprmUtils.addSprm((short)28715, sectionProperties.getBrcTop().toInt(), null, arrayList);
        }
        if (!sectionProperties.getBrcLeft().equals(DEFAULT_SEP.getBrcLeft())) {
            n += SprmUtils.addSprm((short)28716, sectionProperties.getBrcLeft().toInt(), null, arrayList);
        }
        if (!sectionProperties.getBrcBottom().equals(DEFAULT_SEP.getBrcBottom())) {
            n += SprmUtils.addSprm((short)28717, sectionProperties.getBrcBottom().toInt(), null, arrayList);
        }
        if (!sectionProperties.getBrcRight().equals(DEFAULT_SEP.getBrcRight())) {
            n += SprmUtils.addSprm((short)28718, sectionProperties.getBrcRight().toInt(), null, arrayList);
        }
        if (sectionProperties.getPgbProp() != DEFAULT_SEP.getPgbProp()) {
            n += SprmUtils.addSprm((short)21039, sectionProperties.getPgbProp(), null, arrayList);
        }
        if (sectionProperties.getDxtCharSpace() != DEFAULT_SEP.getDxtCharSpace()) {
            n += SprmUtils.addSprm((short)28720, sectionProperties.getDxtCharSpace(), null, arrayList);
        }
        if (sectionProperties.getDyaLinePitch() != DEFAULT_SEP.getDyaLinePitch()) {
            n += SprmUtils.addSprm((short)-28623, sectionProperties.getDyaLinePitch(), null, arrayList);
        }
        if (sectionProperties.getClm() != DEFAULT_SEP.getClm()) {
            n += SprmUtils.addSprm((short)20530, sectionProperties.getClm(), null, arrayList);
        }
        if (sectionProperties.getWTextFlow() != DEFAULT_SEP.getWTextFlow()) {
            n += SprmUtils.addSprm((short)20531, sectionProperties.getWTextFlow(), null, arrayList);
        }
        return SprmUtils.getGrpprl(arrayList, n);
    }
}

