/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.hdf.model.hdftypes.HDFType;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class TLPAbstractType
implements HDFType {
    protected short field_1_itl;
    protected byte field_2_tlp_flags;
    private static BitField fBorders = new BitField(1);
    private static BitField fShading = new BitField(2);
    private static BitField fFont = new BitField(4);
    private static BitField fColor = new BitField(8);
    private static BitField fBestFit = new BitField(16);
    private static BitField fHdrRows = new BitField(32);
    private static BitField fLastRow = new BitField(64);

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_itl = LittleEndian.getShort(byArray, 0 + n);
        this.field_2_tlp_flags = byArray[2 + n];
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, 0 + n, this.field_1_itl);
        byArray[2 + n] = this.field_2_tlp_flags;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TLP]\n");
        stringBuffer.append("    .itl                  = ");
        stringBuffer.append(" (").append(this.getItl()).append(" )\n");
        stringBuffer.append("    .tlp_flags            = ");
        stringBuffer.append(" (").append(this.getTlp_flags()).append(" )\n");
        stringBuffer.append("         .fBorders                 = ").append(this.isFBorders()).append('\n');
        stringBuffer.append("         .fShading                 = ").append(this.isFShading()).append('\n');
        stringBuffer.append("         .fFont                    = ").append(this.isFFont()).append('\n');
        stringBuffer.append("         .fColor                   = ").append(this.isFColor()).append('\n');
        stringBuffer.append("         .fBestFit                 = ").append(this.isFBestFit()).append('\n');
        stringBuffer.append("         .fHdrRows                 = ").append(this.isFHdrRows()).append('\n');
        stringBuffer.append("         .fLastRow                 = ").append(this.isFLastRow()).append('\n');
        stringBuffer.append("[/TLP]\n");
        return stringBuffer.toString();
    }

    public int getSize() {
        return 7;
    }

    public short getItl() {
        return this.field_1_itl;
    }

    public void setItl(short s) {
        this.field_1_itl = s;
    }

    public byte getTlp_flags() {
        return this.field_2_tlp_flags;
    }

    public void setTlp_flags(byte by) {
        this.field_2_tlp_flags = by;
    }

    public void setFBorders(boolean bl) {
        this.field_2_tlp_flags = (byte)fBorders.setBoolean(this.field_2_tlp_flags, bl);
    }

    public boolean isFBorders() {
        return fBorders.isSet(this.field_2_tlp_flags);
    }

    public void setFShading(boolean bl) {
        this.field_2_tlp_flags = (byte)fShading.setBoolean(this.field_2_tlp_flags, bl);
    }

    public boolean isFShading() {
        return fShading.isSet(this.field_2_tlp_flags);
    }

    public void setFFont(boolean bl) {
        this.field_2_tlp_flags = (byte)fFont.setBoolean(this.field_2_tlp_flags, bl);
    }

    public boolean isFFont() {
        return fFont.isSet(this.field_2_tlp_flags);
    }

    public void setFColor(boolean bl) {
        this.field_2_tlp_flags = (byte)fColor.setBoolean(this.field_2_tlp_flags, bl);
    }

    public boolean isFColor() {
        return fColor.isSet(this.field_2_tlp_flags);
    }

    public void setFBestFit(boolean bl) {
        this.field_2_tlp_flags = (byte)fBestFit.setBoolean(this.field_2_tlp_flags, bl);
    }

    public boolean isFBestFit() {
        return fBestFit.isSet(this.field_2_tlp_flags);
    }

    public void setFHdrRows(boolean bl) {
        this.field_2_tlp_flags = (byte)fHdrRows.setBoolean(this.field_2_tlp_flags, bl);
    }

    public boolean isFHdrRows() {
        return fHdrRows.isSet(this.field_2_tlp_flags);
    }

    public void setFLastRow(boolean bl) {
        this.field_2_tlp_flags = (byte)fLastRow.setBoolean(this.field_2_tlp_flags, bl);
    }

    public boolean isFLastRow() {
        return fLastRow.isSet(this.field_2_tlp_flags);
    }
}

