/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class StdfBaseAbstractType {
    protected short field_1_info1;
    private static final BitField sti = new BitField(4095);
    private static final BitField fScratch = new BitField(4096);
    private static final BitField fInvalHeight = new BitField(8192);
    private static final BitField fHasUpe = new BitField(16384);
    private static final BitField fMassCopy = new BitField(32768);
    protected short field_2_info2;
    private static final BitField stk = new BitField(15);
    private static final BitField istdBase = new BitField(65520);
    protected short field_3_info3;
    private static final BitField cupx = new BitField(15);
    private static final BitField istdNext = new BitField(65520);
    protected int field_4_bchUpe;
    protected short field_5_grfstd;
    private static final BitField fAutoRedef = new BitField(1);
    private static final BitField fHidden = new BitField(2);
    private static final BitField f97LidsSet = new BitField(4);
    private static final BitField fCopyLang = new BitField(8);
    private static final BitField fPersonalCompose = new BitField(16);
    private static final BitField fPersonalReply = new BitField(32);
    private static final BitField fPersonal = new BitField(64);
    private static final BitField fNoHtmlExport = new BitField(128);
    private static final BitField fSemiHidden = new BitField(256);
    private static final BitField fLocked = new BitField(512);
    private static final BitField fInternalUse = new BitField(1024);
    private static final BitField fUnhideWhenUsed = new BitField(2048);
    private static final BitField fQFormat = new BitField(4096);
    private static final BitField fReserved = new BitField(57344);

    protected StdfBaseAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_info1 = LittleEndian.getShort(byArray, 0 + n);
        this.field_2_info2 = LittleEndian.getShort(byArray, 2 + n);
        this.field_3_info3 = LittleEndian.getShort(byArray, 4 + n);
        this.field_4_bchUpe = LittleEndian.getShort(byArray, 6 + n);
        this.field_5_grfstd = LittleEndian.getShort(byArray, 8 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, 0 + n, this.field_1_info1);
        LittleEndian.putShort(byArray, 2 + n, this.field_2_info2);
        LittleEndian.putShort(byArray, 4 + n, this.field_3_info3);
        LittleEndian.putUShort(byArray, 6 + n, this.field_4_bchUpe);
        LittleEndian.putShort(byArray, 8 + n, this.field_5_grfstd);
    }

    public static int getSize() {
        return 10;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[StdfBase]\n");
        stringBuilder.append("    .info1                = ");
        stringBuilder.append(" (").append(this.getInfo1()).append(" )\n");
        stringBuilder.append("         .sti                      = ").append(this.getSti()).append('\n');
        stringBuilder.append("         .fScratch                 = ").append(this.isFScratch()).append('\n');
        stringBuilder.append("         .fInvalHeight             = ").append(this.isFInvalHeight()).append('\n');
        stringBuilder.append("         .fHasUpe                  = ").append(this.isFHasUpe()).append('\n');
        stringBuilder.append("         .fMassCopy                = ").append(this.isFMassCopy()).append('\n');
        stringBuilder.append("    .info2                = ");
        stringBuilder.append(" (").append(this.getInfo2()).append(" )\n");
        stringBuilder.append("         .stk                      = ").append(this.getStk()).append('\n');
        stringBuilder.append("         .istdBase                 = ").append(this.getIstdBase()).append('\n');
        stringBuilder.append("    .info3                = ");
        stringBuilder.append(" (").append(this.getInfo3()).append(" )\n");
        stringBuilder.append("         .cupx                     = ").append(this.getCupx()).append('\n');
        stringBuilder.append("         .istdNext                 = ").append(this.getIstdNext()).append('\n');
        stringBuilder.append("    .bchUpe               = ");
        stringBuilder.append(" (").append(this.getBchUpe()).append(" )\n");
        stringBuilder.append("    .grfstd               = ");
        stringBuilder.append(" (").append(this.getGrfstd()).append(" )\n");
        stringBuilder.append("         .fAutoRedef               = ").append(this.isFAutoRedef()).append('\n');
        stringBuilder.append("         .fHidden                  = ").append(this.isFHidden()).append('\n');
        stringBuilder.append("         .f97LidsSet               = ").append(this.isF97LidsSet()).append('\n');
        stringBuilder.append("         .fCopyLang                = ").append(this.isFCopyLang()).append('\n');
        stringBuilder.append("         .fPersonalCompose         = ").append(this.isFPersonalCompose()).append('\n');
        stringBuilder.append("         .fPersonalReply           = ").append(this.isFPersonalReply()).append('\n');
        stringBuilder.append("         .fPersonal                = ").append(this.isFPersonal()).append('\n');
        stringBuilder.append("         .fNoHtmlExport            = ").append(this.isFNoHtmlExport()).append('\n');
        stringBuilder.append("         .fSemiHidden              = ").append(this.isFSemiHidden()).append('\n');
        stringBuilder.append("         .fLocked                  = ").append(this.isFLocked()).append('\n');
        stringBuilder.append("         .fInternalUse             = ").append(this.isFInternalUse()).append('\n');
        stringBuilder.append("         .fUnhideWhenUsed          = ").append(this.isFUnhideWhenUsed()).append('\n');
        stringBuilder.append("         .fQFormat                 = ").append(this.isFQFormat()).append('\n');
        stringBuilder.append("         .fReserved                = ").append(this.getFReserved()).append('\n');
        stringBuilder.append("[/StdfBase]\n");
        return stringBuilder.toString();
    }

    @Internal
    public short getInfo1() {
        return this.field_1_info1;
    }

    @Internal
    public void setInfo1(short s) {
        this.field_1_info1 = s;
    }

    @Internal
    public short getInfo2() {
        return this.field_2_info2;
    }

    @Internal
    public void setInfo2(short s) {
        this.field_2_info2 = s;
    }

    @Internal
    public short getInfo3() {
        return this.field_3_info3;
    }

    @Internal
    public void setInfo3(short s) {
        this.field_3_info3 = s;
    }

    @Internal
    public int getBchUpe() {
        return this.field_4_bchUpe;
    }

    @Internal
    public void setBchUpe(int n) {
        this.field_4_bchUpe = n;
    }

    @Internal
    public short getGrfstd() {
        return this.field_5_grfstd;
    }

    @Internal
    public void setGrfstd(short s) {
        this.field_5_grfstd = s;
    }

    @Internal
    public void setSti(short s) {
        this.field_1_info1 = (short)sti.setValue(this.field_1_info1, s);
    }

    @Internal
    public short getSti() {
        return (short)sti.getValue(this.field_1_info1);
    }

    @Internal
    public void setFScratch(boolean bl) {
        this.field_1_info1 = (short)fScratch.setBoolean(this.field_1_info1, bl);
    }

    @Internal
    public boolean isFScratch() {
        return fScratch.isSet(this.field_1_info1);
    }

    @Internal
    public void setFInvalHeight(boolean bl) {
        this.field_1_info1 = (short)fInvalHeight.setBoolean(this.field_1_info1, bl);
    }

    @Internal
    public boolean isFInvalHeight() {
        return fInvalHeight.isSet(this.field_1_info1);
    }

    @Internal
    public void setFHasUpe(boolean bl) {
        this.field_1_info1 = (short)fHasUpe.setBoolean(this.field_1_info1, bl);
    }

    @Internal
    public boolean isFHasUpe() {
        return fHasUpe.isSet(this.field_1_info1);
    }

    @Internal
    public void setFMassCopy(boolean bl) {
        this.field_1_info1 = (short)fMassCopy.setBoolean(this.field_1_info1, bl);
    }

    @Internal
    public boolean isFMassCopy() {
        return fMassCopy.isSet(this.field_1_info1);
    }

    @Internal
    public void setStk(byte by) {
        this.field_2_info2 = (short)stk.setValue(this.field_2_info2, by);
    }

    @Internal
    public byte getStk() {
        return (byte)stk.getValue(this.field_2_info2);
    }

    @Internal
    public void setIstdBase(short s) {
        this.field_2_info2 = (short)istdBase.setValue(this.field_2_info2, s);
    }

    @Internal
    public short getIstdBase() {
        return (short)istdBase.getValue(this.field_2_info2);
    }

    @Internal
    public void setCupx(byte by) {
        this.field_3_info3 = (short)cupx.setValue(this.field_3_info3, by);
    }

    @Internal
    public byte getCupx() {
        return (byte)cupx.getValue(this.field_3_info3);
    }

    @Internal
    public void setIstdNext(short s) {
        this.field_3_info3 = (short)istdNext.setValue(this.field_3_info3, s);
    }

    @Internal
    public short getIstdNext() {
        return (short)istdNext.getValue(this.field_3_info3);
    }

    @Internal
    public void setFAutoRedef(boolean bl) {
        this.field_5_grfstd = (short)fAutoRedef.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFAutoRedef() {
        return fAutoRedef.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFHidden(boolean bl) {
        this.field_5_grfstd = (short)fHidden.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFHidden() {
        return fHidden.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setF97LidsSet(boolean bl) {
        this.field_5_grfstd = (short)f97LidsSet.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isF97LidsSet() {
        return f97LidsSet.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFCopyLang(boolean bl) {
        this.field_5_grfstd = (short)fCopyLang.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFCopyLang() {
        return fCopyLang.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFPersonalCompose(boolean bl) {
        this.field_5_grfstd = (short)fPersonalCompose.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFPersonalCompose() {
        return fPersonalCompose.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFPersonalReply(boolean bl) {
        this.field_5_grfstd = (short)fPersonalReply.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFPersonalReply() {
        return fPersonalReply.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFPersonal(boolean bl) {
        this.field_5_grfstd = (short)fPersonal.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFPersonal() {
        return fPersonal.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFNoHtmlExport(boolean bl) {
        this.field_5_grfstd = (short)fNoHtmlExport.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFNoHtmlExport() {
        return fNoHtmlExport.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFSemiHidden(boolean bl) {
        this.field_5_grfstd = (short)fSemiHidden.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFSemiHidden() {
        return fSemiHidden.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFLocked(boolean bl) {
        this.field_5_grfstd = (short)fLocked.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFLocked() {
        return fLocked.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFInternalUse(boolean bl) {
        this.field_5_grfstd = (short)fInternalUse.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFInternalUse() {
        return fInternalUse.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFUnhideWhenUsed(boolean bl) {
        this.field_5_grfstd = (short)fUnhideWhenUsed.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFUnhideWhenUsed() {
        return fUnhideWhenUsed.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFQFormat(boolean bl) {
        this.field_5_grfstd = (short)fQFormat.setBoolean(this.field_5_grfstd, bl);
    }

    @Internal
    public boolean isFQFormat() {
        return fQFormat.isSet(this.field_5_grfstd);
    }

    @Internal
    public void setFReserved(byte by) {
        this.field_5_grfstd = (short)fReserved.setValue(this.field_5_grfstd, by);
    }

    @Internal
    public byte getFReserved() {
        return (byte)fReserved.getValue(this.field_5_grfstd);
    }
}

