/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class SHD80AbstractType {
    protected short field_1_value;
    private static final BitField icoFore = new BitField(31);
    private static final BitField icoBack = new BitField(992);
    private static final BitField ipat = new BitField(64512);

    protected SHD80AbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_value = LittleEndian.getShort(byArray, 0 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, 0 + n, this.field_1_value);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[SHD80AbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SHD80AbstractType sHD80AbstractType = (SHD80AbstractType)object;
        return this.field_1_value == sHD80AbstractType.field_1_value;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.field_1_value;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[SHD80]\n");
        stringBuilder.append("    .value                = ");
        stringBuilder.append(" (").append(this.getValue()).append(" )\n");
        stringBuilder.append("         .icoFore                  = ").append(this.getIcoFore()).append('\n');
        stringBuilder.append("         .icoBack                  = ").append(this.getIcoBack()).append('\n');
        stringBuilder.append("         .ipat                     = ").append(this.getIpat()).append('\n');
        stringBuilder.append("[/SHD80]\n");
        return stringBuilder.toString();
    }

    @Internal
    public short getValue() {
        return this.field_1_value;
    }

    @Internal
    public void setValue(short s) {
        this.field_1_value = s;
    }

    @Internal
    public void setIcoFore(byte by) {
        this.field_1_value = (short)icoFore.setValue(this.field_1_value, by);
    }

    @Internal
    public byte getIcoFore() {
        return (byte)icoFore.getValue(this.field_1_value);
    }

    @Internal
    public void setIcoBack(byte by) {
        this.field_1_value = (short)icoBack.setValue(this.field_1_value, by);
    }

    @Internal
    public byte getIcoBack() {
        return (byte)icoBack.getValue(this.field_1_value);
    }

    @Internal
    public void setIpat(byte by) {
        this.field_1_value = (short)ipat.setValue(this.field_1_value, by);
    }

    @Internal
    public byte getIpat() {
        return (byte)ipat.getValue(this.field_1_value);
    }
}

