/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

@Internal
public abstract class PICFAbstractType {
    protected int field_1_lcb;
    protected int field_2_cbHeader;
    protected short field_3_mm;
    protected short field_4_xExt;
    protected short field_5_yExt;
    protected short field_6_swHMF;
    protected int field_7_grf;
    protected int field_8_padding;
    protected int field_9_mmPM;
    protected int field_10_padding2;
    protected short field_11_dxaGoal;
    protected short field_12_dyaGoal;
    protected int field_13_mx;
    protected int field_14_my;
    protected short field_15_dxaReserved1;
    protected short field_16_dyaReserved1;
    protected short field_17_dxaReserved2;
    protected short field_18_dyaReserved2;
    protected byte field_19_fReserved;
    protected byte field_20_bpp;
    protected byte[] field_21_brcTop80 = new byte[4];
    protected byte[] field_22_brcLeft80 = new byte[4];
    protected byte[] field_23_brcBottom80 = new byte[4];
    protected byte[] field_24_brcRight80 = new byte[4];
    protected short field_25_dxaReserved3;
    protected short field_26_dyaReserved3;
    protected short field_27_cProps;

    protected PICFAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_lcb = LittleEndian.getInt(byArray, 0 + n);
        this.field_2_cbHeader = LittleEndian.getShort(byArray, 4 + n);
        this.field_3_mm = LittleEndian.getShort(byArray, 6 + n);
        this.field_4_xExt = LittleEndian.getShort(byArray, 8 + n);
        this.field_5_yExt = LittleEndian.getShort(byArray, 10 + n);
        this.field_6_swHMF = LittleEndian.getShort(byArray, 12 + n);
        this.field_7_grf = LittleEndian.getInt(byArray, 14 + n);
        this.field_8_padding = LittleEndian.getInt(byArray, 18 + n);
        this.field_9_mmPM = LittleEndian.getShort(byArray, 22 + n);
        this.field_10_padding2 = LittleEndian.getInt(byArray, 24 + n);
        this.field_11_dxaGoal = LittleEndian.getShort(byArray, 28 + n);
        this.field_12_dyaGoal = LittleEndian.getShort(byArray, 30 + n);
        this.field_13_mx = LittleEndian.getShort(byArray, 32 + n);
        this.field_14_my = LittleEndian.getShort(byArray, 34 + n);
        this.field_15_dxaReserved1 = LittleEndian.getShort(byArray, 36 + n);
        this.field_16_dyaReserved1 = LittleEndian.getShort(byArray, 38 + n);
        this.field_17_dxaReserved2 = LittleEndian.getShort(byArray, 40 + n);
        this.field_18_dyaReserved2 = LittleEndian.getShort(byArray, 42 + n);
        this.field_19_fReserved = byArray[44 + n];
        this.field_20_bpp = byArray[45 + n];
        this.field_21_brcTop80 = LittleEndian.getByteArray(byArray, 46 + n, 4);
        this.field_22_brcLeft80 = LittleEndian.getByteArray(byArray, 50 + n, 4);
        this.field_23_brcBottom80 = LittleEndian.getByteArray(byArray, 54 + n, 4);
        this.field_24_brcRight80 = LittleEndian.getByteArray(byArray, 58 + n, 4);
        this.field_25_dxaReserved3 = LittleEndian.getShort(byArray, 62 + n);
        this.field_26_dyaReserved3 = LittleEndian.getShort(byArray, 64 + n);
        this.field_27_cProps = LittleEndian.getShort(byArray, 66 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0 + n, this.field_1_lcb);
        LittleEndian.putUShort(byArray, 4 + n, this.field_2_cbHeader);
        LittleEndian.putShort(byArray, 6 + n, this.field_3_mm);
        LittleEndian.putShort(byArray, 8 + n, this.field_4_xExt);
        LittleEndian.putShort(byArray, 10 + n, this.field_5_yExt);
        LittleEndian.putShort(byArray, 12 + n, this.field_6_swHMF);
        LittleEndian.putInt(byArray, 14 + n, this.field_7_grf);
        LittleEndian.putInt(byArray, 18 + n, this.field_8_padding);
        LittleEndian.putUShort(byArray, 22 + n, this.field_9_mmPM);
        LittleEndian.putInt(byArray, 24 + n, this.field_10_padding2);
        LittleEndian.putShort(byArray, 28 + n, this.field_11_dxaGoal);
        LittleEndian.putShort(byArray, 30 + n, this.field_12_dyaGoal);
        LittleEndian.putUShort(byArray, 32 + n, this.field_13_mx);
        LittleEndian.putUShort(byArray, 34 + n, this.field_14_my);
        LittleEndian.putShort(byArray, 36 + n, this.field_15_dxaReserved1);
        LittleEndian.putShort(byArray, 38 + n, this.field_16_dyaReserved1);
        LittleEndian.putShort(byArray, 40 + n, this.field_17_dxaReserved2);
        LittleEndian.putShort(byArray, 42 + n, this.field_18_dyaReserved2);
        byArray[44 + n] = this.field_19_fReserved;
        byArray[45 + n] = this.field_20_bpp;
        System.arraycopy(this.field_21_brcTop80, 0, byArray, 46 + n, this.field_21_brcTop80.length);
        System.arraycopy(this.field_22_brcLeft80, 0, byArray, 50 + n, this.field_22_brcLeft80.length);
        System.arraycopy(this.field_23_brcBottom80, 0, byArray, 54 + n, this.field_23_brcBottom80.length);
        System.arraycopy(this.field_24_brcRight80, 0, byArray, 58 + n, this.field_24_brcRight80.length);
        LittleEndian.putShort(byArray, 62 + n, this.field_25_dxaReserved3);
        LittleEndian.putShort(byArray, 64 + n, this.field_26_dyaReserved3);
        LittleEndian.putShort(byArray, 66 + n, this.field_27_cProps);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[PICFAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 68;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PICF]\n");
        stringBuilder.append("    .lcb                  = ");
        stringBuilder.append(" (").append(this.getLcb()).append(" )\n");
        stringBuilder.append("    .cbHeader             = ");
        stringBuilder.append(" (").append(this.getCbHeader()).append(" )\n");
        stringBuilder.append("    .mm                   = ");
        stringBuilder.append(" (").append(this.getMm()).append(" )\n");
        stringBuilder.append("    .xExt                 = ");
        stringBuilder.append(" (").append(this.getXExt()).append(" )\n");
        stringBuilder.append("    .yExt                 = ");
        stringBuilder.append(" (").append(this.getYExt()).append(" )\n");
        stringBuilder.append("    .swHMF                = ");
        stringBuilder.append(" (").append(this.getSwHMF()).append(" )\n");
        stringBuilder.append("    .grf                  = ");
        stringBuilder.append(" (").append(this.getGrf()).append(" )\n");
        stringBuilder.append("    .padding              = ");
        stringBuilder.append(" (").append(this.getPadding()).append(" )\n");
        stringBuilder.append("    .mmPM                 = ");
        stringBuilder.append(" (").append(this.getMmPM()).append(" )\n");
        stringBuilder.append("    .padding2             = ");
        stringBuilder.append(" (").append(this.getPadding2()).append(" )\n");
        stringBuilder.append("    .dxaGoal              = ");
        stringBuilder.append(" (").append(this.getDxaGoal()).append(" )\n");
        stringBuilder.append("    .dyaGoal              = ");
        stringBuilder.append(" (").append(this.getDyaGoal()).append(" )\n");
        stringBuilder.append("    .mx                   = ");
        stringBuilder.append(" (").append(this.getMx()).append(" )\n");
        stringBuilder.append("    .my                   = ");
        stringBuilder.append(" (").append(this.getMy()).append(" )\n");
        stringBuilder.append("    .dxaReserved1         = ");
        stringBuilder.append(" (").append(this.getDxaReserved1()).append(" )\n");
        stringBuilder.append("    .dyaReserved1         = ");
        stringBuilder.append(" (").append(this.getDyaReserved1()).append(" )\n");
        stringBuilder.append("    .dxaReserved2         = ");
        stringBuilder.append(" (").append(this.getDxaReserved2()).append(" )\n");
        stringBuilder.append("    .dyaReserved2         = ");
        stringBuilder.append(" (").append(this.getDyaReserved2()).append(" )\n");
        stringBuilder.append("    .fReserved            = ");
        stringBuilder.append(" (").append(this.getFReserved()).append(" )\n");
        stringBuilder.append("    .bpp                  = ");
        stringBuilder.append(" (").append(this.getBpp()).append(" )\n");
        stringBuilder.append("    .brcTop80             = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getBrcTop80())).append(" )\n");
        stringBuilder.append("    .brcLeft80            = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getBrcLeft80())).append(" )\n");
        stringBuilder.append("    .brcBottom80          = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getBrcBottom80())).append(" )\n");
        stringBuilder.append("    .brcRight80           = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getBrcRight80())).append(" )\n");
        stringBuilder.append("    .dxaReserved3         = ");
        stringBuilder.append(" (").append(this.getDxaReserved3()).append(" )\n");
        stringBuilder.append("    .dyaReserved3         = ");
        stringBuilder.append(" (").append(this.getDyaReserved3()).append(" )\n");
        stringBuilder.append("    .cProps               = ");
        stringBuilder.append(" (").append(this.getCProps()).append(" )\n");
        stringBuilder.append("[/PICF]\n");
        return stringBuilder.toString();
    }

    @Internal
    public int getLcb() {
        return this.field_1_lcb;
    }

    @Internal
    public void setLcb(int n) {
        this.field_1_lcb = n;
    }

    @Internal
    public int getCbHeader() {
        return this.field_2_cbHeader;
    }

    @Internal
    public void setCbHeader(int n) {
        this.field_2_cbHeader = n;
    }

    @Internal
    public short getMm() {
        return this.field_3_mm;
    }

    @Internal
    public void setMm(short s) {
        this.field_3_mm = s;
    }

    @Internal
    public short getXExt() {
        return this.field_4_xExt;
    }

    @Internal
    public void setXExt(short s) {
        this.field_4_xExt = s;
    }

    @Internal
    public short getYExt() {
        return this.field_5_yExt;
    }

    @Internal
    public void setYExt(short s) {
        this.field_5_yExt = s;
    }

    @Internal
    public short getSwHMF() {
        return this.field_6_swHMF;
    }

    @Internal
    public void setSwHMF(short s) {
        this.field_6_swHMF = s;
    }

    @Internal
    public int getGrf() {
        return this.field_7_grf;
    }

    @Internal
    public void setGrf(int n) {
        this.field_7_grf = n;
    }

    @Internal
    public int getPadding() {
        return this.field_8_padding;
    }

    @Internal
    public void setPadding(int n) {
        this.field_8_padding = n;
    }

    @Internal
    public int getMmPM() {
        return this.field_9_mmPM;
    }

    @Internal
    public void setMmPM(int n) {
        this.field_9_mmPM = n;
    }

    @Internal
    public int getPadding2() {
        return this.field_10_padding2;
    }

    @Internal
    public void setPadding2(int n) {
        this.field_10_padding2 = n;
    }

    @Internal
    public short getDxaGoal() {
        return this.field_11_dxaGoal;
    }

    @Internal
    public void setDxaGoal(short s) {
        this.field_11_dxaGoal = s;
    }

    @Internal
    public short getDyaGoal() {
        return this.field_12_dyaGoal;
    }

    @Internal
    public void setDyaGoal(short s) {
        this.field_12_dyaGoal = s;
    }

    @Internal
    public int getMx() {
        return this.field_13_mx;
    }

    @Internal
    public void setMx(int n) {
        this.field_13_mx = n;
    }

    @Internal
    public int getMy() {
        return this.field_14_my;
    }

    @Internal
    public void setMy(int n) {
        this.field_14_my = n;
    }

    @Internal
    public short getDxaReserved1() {
        return this.field_15_dxaReserved1;
    }

    @Internal
    public void setDxaReserved1(short s) {
        this.field_15_dxaReserved1 = s;
    }

    @Internal
    public short getDyaReserved1() {
        return this.field_16_dyaReserved1;
    }

    @Internal
    public void setDyaReserved1(short s) {
        this.field_16_dyaReserved1 = s;
    }

    @Internal
    public short getDxaReserved2() {
        return this.field_17_dxaReserved2;
    }

    @Internal
    public void setDxaReserved2(short s) {
        this.field_17_dxaReserved2 = s;
    }

    @Internal
    public short getDyaReserved2() {
        return this.field_18_dyaReserved2;
    }

    @Internal
    public void setDyaReserved2(short s) {
        this.field_18_dyaReserved2 = s;
    }

    @Internal
    public byte getFReserved() {
        return this.field_19_fReserved;
    }

    @Internal
    public void setFReserved(byte by) {
        this.field_19_fReserved = by;
    }

    @Internal
    public byte getBpp() {
        return this.field_20_bpp;
    }

    @Internal
    public void setBpp(byte by) {
        this.field_20_bpp = by;
    }

    @Internal
    public byte[] getBrcTop80() {
        return this.field_21_brcTop80;
    }

    @Internal
    public void setBrcTop80(byte[] byArray) {
        this.field_21_brcTop80 = byArray;
    }

    @Internal
    public byte[] getBrcLeft80() {
        return this.field_22_brcLeft80;
    }

    @Internal
    public void setBrcLeft80(byte[] byArray) {
        this.field_22_brcLeft80 = byArray;
    }

    @Internal
    public byte[] getBrcBottom80() {
        return this.field_23_brcBottom80;
    }

    @Internal
    public void setBrcBottom80(byte[] byArray) {
        this.field_23_brcBottom80 = byArray;
    }

    @Internal
    public byte[] getBrcRight80() {
        return this.field_24_brcRight80;
    }

    @Internal
    public void setBrcRight80(byte[] byArray) {
        this.field_24_brcRight80 = byArray;
    }

    @Internal
    public short getDxaReserved3() {
        return this.field_25_dxaReserved3;
    }

    @Internal
    public void setDxaReserved3(short s) {
        this.field_25_dxaReserved3 = s;
    }

    @Internal
    public short getDyaReserved3() {
        return this.field_26_dyaReserved3;
    }

    @Internal
    public void setDyaReserved3(short s) {
        this.field_26_dyaReserved3 = s;
    }

    @Internal
    public short getCProps() {
        return this.field_27_cProps;
    }

    @Internal
    public void setCProps(short s) {
        this.field_27_cProps = s;
    }
}

