/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.hwpf.model.Grfhic;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

@Internal
public abstract class LSTFAbstractType {
    protected int field_1_lsid;
    protected int field_2_tplc;
    protected short[] field_3_rgistdPara = new short[0];
    protected byte field_4_flags;
    private static final BitField fSimpleList = new BitField(1);
    private static final BitField unused1 = new BitField(2);
    private static final BitField fAutoNum = new BitField(4);
    private static final BitField unused2 = new BitField(8);
    private static final BitField fHybrid = new BitField(16);
    private static final BitField reserved1 = new BitField(224);
    protected Grfhic field_5_grfhic = new Grfhic();

    protected LSTFAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_lsid = LittleEndian.getInt(byArray, 0 + n);
        this.field_2_tplc = LittleEndian.getInt(byArray, 4 + n);
        this.field_3_rgistdPara = LittleEndian.getShortArray(byArray, 8 + n, 18);
        this.field_4_flags = byArray[26 + n];
        this.field_5_grfhic = new Grfhic(byArray, 27 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0 + n, this.field_1_lsid);
        LittleEndian.putInt(byArray, 4 + n, this.field_2_tplc);
        LittleEndian.putShortArray(byArray, 8 + n, this.field_3_rgistdPara);
        byArray[26 + n] = this.field_4_flags;
        this.field_5_grfhic.serialize(byArray, 27 + n);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[LSTFAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 28;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LSTFAbstractType lSTFAbstractType = (LSTFAbstractType)object;
        if (this.field_1_lsid != lSTFAbstractType.field_1_lsid) {
            return false;
        }
        if (this.field_2_tplc != lSTFAbstractType.field_2_tplc) {
            return false;
        }
        if (!Arrays.equals(this.field_3_rgistdPara, lSTFAbstractType.field_3_rgistdPara)) {
            return false;
        }
        if (this.field_4_flags != lSTFAbstractType.field_4_flags) {
            return false;
        }
        return !(this.field_5_grfhic == null ? lSTFAbstractType.field_5_grfhic != null : !this.field_5_grfhic.equals(lSTFAbstractType.field_5_grfhic));
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.field_1_lsid;
        n = 31 * n + this.field_2_tplc;
        n = 31 * n + Arrays.hashCode(this.field_3_rgistdPara);
        n = 31 * n + this.field_4_flags;
        n = 31 * n + this.field_5_grfhic.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[LSTF]\n");
        stringBuilder.append("    .lsid                 = ");
        stringBuilder.append(" (").append(this.getLsid()).append(" )\n");
        stringBuilder.append("    .tplc                 = ");
        stringBuilder.append(" (").append(this.getTplc()).append(" )\n");
        stringBuilder.append("    .rgistdPara           = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getRgistdPara())).append(" )\n");
        stringBuilder.append("    .flags                = ");
        stringBuilder.append(" (").append(this.getFlags()).append(" )\n");
        stringBuilder.append("         .fSimpleList              = ").append(this.isFSimpleList()).append('\n');
        stringBuilder.append("         .unused1                  = ").append(this.isUnused1()).append('\n');
        stringBuilder.append("         .fAutoNum                 = ").append(this.isFAutoNum()).append('\n');
        stringBuilder.append("         .unused2                  = ").append(this.isUnused2()).append('\n');
        stringBuilder.append("         .fHybrid                  = ").append(this.isFHybrid()).append('\n');
        stringBuilder.append("         .reserved1                = ").append(this.getReserved1()).append('\n');
        stringBuilder.append("    .grfhic               = ");
        stringBuilder.append(" (").append(this.getGrfhic()).append(" )\n");
        stringBuilder.append("[/LSTF]\n");
        return stringBuilder.toString();
    }

    @Internal
    public int getLsid() {
        return this.field_1_lsid;
    }

    @Internal
    public void setLsid(int n) {
        this.field_1_lsid = n;
    }

    @Internal
    public int getTplc() {
        return this.field_2_tplc;
    }

    @Internal
    public void setTplc(int n) {
        this.field_2_tplc = n;
    }

    @Internal
    public short[] getRgistdPara() {
        return this.field_3_rgistdPara;
    }

    @Internal
    public void setRgistdPara(short[] sArray) {
        this.field_3_rgistdPara = sArray;
    }

    @Internal
    public byte getFlags() {
        return this.field_4_flags;
    }

    @Internal
    public void setFlags(byte by) {
        this.field_4_flags = by;
    }

    @Internal
    public Grfhic getGrfhic() {
        return this.field_5_grfhic;
    }

    @Internal
    public void setGrfhic(Grfhic grfhic) {
        this.field_5_grfhic = grfhic;
    }

    @Internal
    public void setFSimpleList(boolean bl) {
        this.field_4_flags = (byte)fSimpleList.setBoolean(this.field_4_flags, bl);
    }

    @Internal
    public boolean isFSimpleList() {
        return fSimpleList.isSet(this.field_4_flags);
    }

    @Internal
    public void setUnused1(boolean bl) {
        this.field_4_flags = (byte)unused1.setBoolean(this.field_4_flags, bl);
    }

    @Internal
    @Deprecated
    public boolean isUnused1() {
        return unused1.isSet(this.field_4_flags);
    }

    @Internal
    public void setFAutoNum(boolean bl) {
        this.field_4_flags = (byte)fAutoNum.setBoolean(this.field_4_flags, bl);
    }

    @Internal
    public boolean isFAutoNum() {
        return fAutoNum.isSet(this.field_4_flags);
    }

    @Internal
    public void setUnused2(boolean bl) {
        this.field_4_flags = (byte)unused2.setBoolean(this.field_4_flags, bl);
    }

    @Internal
    @Deprecated
    public boolean isUnused2() {
        return unused2.isSet(this.field_4_flags);
    }

    @Internal
    public void setFHybrid(boolean bl) {
        this.field_4_flags = (byte)fHybrid.setBoolean(this.field_4_flags, bl);
    }

    @Internal
    public boolean isFHybrid() {
        return fHybrid.isSet(this.field_4_flags);
    }

    @Internal
    public void setReserved1(byte by) {
        this.field_4_flags = (byte)reserved1.setValue(this.field_4_flags, by);
    }

    @Internal
    @Deprecated
    public byte getReserved1() {
        return (byte)reserved1.getValue(this.field_4_flags);
    }
}

