/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class LFOLVLBaseAbstractType {
    protected int field_1_iStartAt;
    protected int field_2_flags;
    private static final BitField iLvl = new BitField(15);
    private static final BitField fStartAt = new BitField(16);
    private static final BitField fFormatting = new BitField(32);
    private static final BitField grfhic = new BitField(16320);
    private static final BitField unused1 = new BitField(536854528);
    private static final BitField unused2 = new BitField(-536870912);

    protected LFOLVLBaseAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_iStartAt = LittleEndian.getInt(byArray, 0 + n);
        this.field_2_flags = LittleEndian.getInt(byArray, 4 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, 0 + n, this.field_1_iStartAt);
        LittleEndian.putInt(byArray, 4 + n, this.field_2_flags);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[LFOLVLBaseAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 8;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LFOLVLBaseAbstractType lFOLVLBaseAbstractType = (LFOLVLBaseAbstractType)object;
        if (this.field_1_iStartAt != lFOLVLBaseAbstractType.field_1_iStartAt) {
            return false;
        }
        return this.field_2_flags == lFOLVLBaseAbstractType.field_2_flags;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.field_1_iStartAt;
        n = 31 * n + this.field_2_flags;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[LFOLVLBase]\n");
        stringBuilder.append("    .iStartAt             = ");
        stringBuilder.append(" (").append(this.getIStartAt()).append(" )\n");
        stringBuilder.append("    .flags                = ");
        stringBuilder.append(" (").append(this.getFlags()).append(" )\n");
        stringBuilder.append("         .iLvl                     = ").append(this.getILvl()).append('\n');
        stringBuilder.append("         .fStartAt                 = ").append(this.isFStartAt()).append('\n');
        stringBuilder.append("         .fFormatting              = ").append(this.isFFormatting()).append('\n');
        stringBuilder.append("         .grfhic                   = ").append(this.getGrfhic()).append('\n');
        stringBuilder.append("         .unused1                  = ").append(this.getUnused1()).append('\n');
        stringBuilder.append("         .unused2                  = ").append(this.getUnused2()).append('\n');
        stringBuilder.append("[/LFOLVLBase]\n");
        return stringBuilder.toString();
    }

    @Internal
    public int getIStartAt() {
        return this.field_1_iStartAt;
    }

    @Internal
    public void setIStartAt(int n) {
        this.field_1_iStartAt = n;
    }

    @Internal
    public int getFlags() {
        return this.field_2_flags;
    }

    @Internal
    public void setFlags(int n) {
        this.field_2_flags = n;
    }

    @Internal
    public void setILvl(byte by) {
        this.field_2_flags = iLvl.setValue(this.field_2_flags, by);
    }

    @Internal
    public byte getILvl() {
        return (byte)iLvl.getValue(this.field_2_flags);
    }

    @Internal
    public void setFStartAt(boolean bl) {
        this.field_2_flags = fStartAt.setBoolean(this.field_2_flags, bl);
    }

    @Internal
    public boolean isFStartAt() {
        return fStartAt.isSet(this.field_2_flags);
    }

    @Internal
    public void setFFormatting(boolean bl) {
        this.field_2_flags = fFormatting.setBoolean(this.field_2_flags, bl);
    }

    @Internal
    public boolean isFFormatting() {
        return fFormatting.isSet(this.field_2_flags);
    }

    @Internal
    public void setGrfhic(short s) {
        this.field_2_flags = grfhic.setValue(this.field_2_flags, s);
    }

    @Internal
    public short getGrfhic() {
        return (short)grfhic.getValue(this.field_2_flags);
    }

    @Internal
    public void setUnused1(short s) {
        this.field_2_flags = unused1.setValue(this.field_2_flags, s);
    }

    @Internal
    @Deprecated
    public short getUnused1() {
        return (short)unused1.getValue(this.field_2_flags);
    }

    @Internal
    public void setUnused2(byte by) {
        this.field_2_flags = unused2.setValue(this.field_2_flags, by);
    }

    @Internal
    @Deprecated
    public byte getUnused2() {
        return (byte)unused2.getValue(this.field_2_flags);
    }
}

