/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class FFDataBaseAbstractType {
    protected long field_1_version;
    protected short field_2_bits;
    private static final BitField iType = new BitField(3);
    public static final byte ITYPE_TEXT = 0;
    public static final byte ITYPE_CHCK = 1;
    public static final byte ITYPE_DROP = 2;
    private static final BitField iRes = new BitField(124);
    private static final BitField fOwnHelp = new BitField(128);
    private static final BitField fOwnStat = new BitField(256);
    private static final BitField fProt = new BitField(512);
    private static final BitField iSize = new BitField(1024);
    private static final BitField iTypeTxt = new BitField(14336);
    public static final byte ITYPETXT_REG = 0;
    public static final byte ITYPETXT_NUM = 0;
    public static final byte ITYPETXT_DATE = 0;
    public static final byte ITYPETXT_CURDATE = 0;
    public static final byte ITYPETXT_CURTIME = 0;
    protected static final byte ITYPETXT_CALC = 0;
    private static final BitField fRecalc = new BitField(16384);
    private static final BitField fHasListBox = new BitField(32768);
    protected int field_3_cch;
    protected int field_4_hps;

    protected FFDataBaseAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_version = LittleEndian.getUInt(byArray, 0 + n);
        this.field_2_bits = LittleEndian.getShort(byArray, 4 + n);
        this.field_3_cch = LittleEndian.getShort(byArray, 6 + n);
        this.field_4_hps = LittleEndian.getShort(byArray, 8 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putUInt(byArray, 0 + n, this.field_1_version);
        LittleEndian.putShort(byArray, 4 + n, this.field_2_bits);
        LittleEndian.putUShort(byArray, 6 + n, this.field_3_cch);
        LittleEndian.putUShort(byArray, 8 + n, this.field_4_hps);
    }

    public byte[] serialize() {
        byte[] byArray = new byte[FFDataBaseAbstractType.getSize()];
        this.serialize(byArray, 0);
        return byArray;
    }

    public static int getSize() {
        return 10;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FFDataBaseAbstractType fFDataBaseAbstractType = (FFDataBaseAbstractType)object;
        if (this.field_1_version != fFDataBaseAbstractType.field_1_version) {
            return false;
        }
        if (this.field_2_bits != fFDataBaseAbstractType.field_2_bits) {
            return false;
        }
        if (this.field_3_cch != fFDataBaseAbstractType.field_3_cch) {
            return false;
        }
        return this.field_4_hps == fFDataBaseAbstractType.field_4_hps;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.field_1_version ^ this.field_1_version >>> 32);
        n = 31 * n + this.field_2_bits;
        n = 31 * n + this.field_3_cch;
        n = 31 * n + this.field_4_hps;
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[FFDataBase]\n");
        stringBuilder.append("    .version              = ");
        stringBuilder.append(" ( ").append(this.field_1_version).append(" )\n");
        stringBuilder.append("    .bits                 = ");
        stringBuilder.append(" ( ").append(this.field_2_bits).append(" )\n");
        stringBuilder.append("         .iType                    = ").append(this.getIType()).append('\n');
        stringBuilder.append("         .iRes                     = ").append(this.getIRes()).append('\n');
        stringBuilder.append("         .fOwnHelp                 = ").append(this.isFOwnHelp()).append('\n');
        stringBuilder.append("         .fOwnStat                 = ").append(this.isFOwnStat()).append('\n');
        stringBuilder.append("         .fProt                    = ").append(this.isFProt()).append('\n');
        stringBuilder.append("         .iSize                    = ").append(this.isISize()).append('\n');
        stringBuilder.append("         .iTypeTxt                 = ").append(this.getITypeTxt()).append('\n');
        stringBuilder.append("         .fRecalc                  = ").append(this.isFRecalc()).append('\n');
        stringBuilder.append("         .fHasListBox              = ").append(this.isFHasListBox()).append('\n');
        stringBuilder.append("    .cch                  = ");
        stringBuilder.append(" ( ").append(this.field_3_cch).append(" )\n");
        stringBuilder.append("    .hps                  = ");
        stringBuilder.append(" ( ").append(this.field_4_hps).append(" )\n");
        stringBuilder.append("[/FFDataBase]");
        return stringBuilder.toString();
    }

    @Internal
    public long getVersion() {
        return this.field_1_version;
    }

    @Internal
    public void setVersion(long l) {
        this.field_1_version = l;
    }

    @Internal
    public short getBits() {
        return this.field_2_bits;
    }

    @Internal
    public void setBits(short s) {
        this.field_2_bits = s;
    }

    @Internal
    public int getCch() {
        return this.field_3_cch;
    }

    @Internal
    public void setCch(int n) {
        this.field_3_cch = n;
    }

    @Internal
    public int getHps() {
        return this.field_4_hps;
    }

    @Internal
    public void setHps(int n) {
        this.field_4_hps = n;
    }

    @Internal
    public void setIType(byte by) {
        this.field_2_bits = (short)iType.setValue(this.field_2_bits, by);
    }

    @Internal
    public byte getIType() {
        return (byte)iType.getValue(this.field_2_bits);
    }

    @Internal
    public void setIRes(byte by) {
        this.field_2_bits = (short)iRes.setValue(this.field_2_bits, by);
    }

    @Internal
    public byte getIRes() {
        return (byte)iRes.getValue(this.field_2_bits);
    }

    @Internal
    public void setFOwnHelp(boolean bl) {
        this.field_2_bits = (short)fOwnHelp.setBoolean(this.field_2_bits, bl);
    }

    @Internal
    public boolean isFOwnHelp() {
        return fOwnHelp.isSet(this.field_2_bits);
    }

    @Internal
    public void setFOwnStat(boolean bl) {
        this.field_2_bits = (short)fOwnStat.setBoolean(this.field_2_bits, bl);
    }

    @Internal
    public boolean isFOwnStat() {
        return fOwnStat.isSet(this.field_2_bits);
    }

    @Internal
    public void setFProt(boolean bl) {
        this.field_2_bits = (short)fProt.setBoolean(this.field_2_bits, bl);
    }

    @Internal
    public boolean isFProt() {
        return fProt.isSet(this.field_2_bits);
    }

    @Internal
    public void setISize(boolean bl) {
        this.field_2_bits = (short)iSize.setBoolean(this.field_2_bits, bl);
    }

    @Internal
    public boolean isISize() {
        return iSize.isSet(this.field_2_bits);
    }

    @Internal
    public void setITypeTxt(byte by) {
        this.field_2_bits = (short)iTypeTxt.setValue(this.field_2_bits, by);
    }

    @Internal
    public byte getITypeTxt() {
        return (byte)iTypeTxt.getValue(this.field_2_bits);
    }

    @Internal
    public void setFRecalc(boolean bl) {
        this.field_2_bits = (short)fRecalc.setBoolean(this.field_2_bits, bl);
    }

    @Internal
    public boolean isFRecalc() {
        return fRecalc.isSet(this.field_2_bits);
    }

    @Internal
    public void setFHasListBox(boolean bl) {
        this.field_2_bits = (short)fHasListBox.setBoolean(this.field_2_bits, bl);
    }

    @Internal
    public boolean isFHasListBox() {
        return fHasListBox.isSet(this.field_2_bits);
    }
}

