/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.hdf.model.hdftypes.HDFType;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

@Internal
public abstract class DOPAbstractType
implements HDFType {
    protected byte field_1_formatFlags;
    private static BitField fFacingPages = new BitField(1);
    private static BitField fWidowControl = new BitField(2);
    private static BitField fPMHMainDoc = new BitField(4);
    private static BitField grfSupression = new BitField(24);
    private static BitField fpc = new BitField(96);
    private static BitField unused1 = new BitField(128);
    protected byte field_2_unused2;
    protected short field_3_footnoteInfo;
    private static BitField rncFtn = new BitField(3);
    private static BitField nFtn = new BitField(65532);
    protected byte field_4_fOutlineDirtySave;
    protected byte field_5_docinfo;
    private static BitField fOnlyMacPics = new BitField(1);
    private static BitField fOnlyWinPics = new BitField(2);
    private static BitField fLabelDoc = new BitField(4);
    private static BitField fHyphCapitals = new BitField(8);
    private static BitField fAutoHyphen = new BitField(16);
    private static BitField fFormNoFields = new BitField(32);
    private static BitField fLinkStyles = new BitField(64);
    private static BitField fRevMarking = new BitField(128);
    protected byte field_6_docinfo1;
    private static BitField fBackup = new BitField(1);
    private static BitField fExactCWords = new BitField(2);
    private static BitField fPagHidden = new BitField(4);
    private static BitField fPagResults = new BitField(8);
    private static BitField fLockAtn = new BitField(16);
    private static BitField fMirrorMargins = new BitField(32);
    private static BitField unused3 = new BitField(64);
    private static BitField fDfltTrueType = new BitField(128);
    protected byte field_7_docinfo2;
    private static BitField fPagSupressTopSpacing = new BitField(1);
    private static BitField fProtEnabled = new BitField(2);
    private static BitField fDispFormFldSel = new BitField(4);
    private static BitField fRMView = new BitField(8);
    private static BitField fRMPrint = new BitField(16);
    private static BitField unused4 = new BitField(32);
    private static BitField fLockRev = new BitField(64);
    private static BitField fEmbedFonts = new BitField(128);
    protected short field_8_docinfo3;
    private static BitField oldfNoTabForInd = new BitField(1);
    private static BitField oldfNoSpaceRaiseLower = new BitField(2);
    private static BitField oldfSuppressSpbfAfterPageBreak = new BitField(4);
    private static BitField oldfWrapTrailSpaces = new BitField(8);
    private static BitField oldfMapPrintTextColor = new BitField(16);
    private static BitField oldfNoColumnBalance = new BitField(32);
    private static BitField oldfConvMailMergeEsc = new BitField(64);
    private static BitField oldfSupressTopSpacing = new BitField(128);
    private static BitField oldfOrigWordTableRules = new BitField(256);
    private static BitField oldfTransparentMetafiles = new BitField(512);
    private static BitField oldfShowBreaksInFrames = new BitField(1024);
    private static BitField oldfSwapBordersFacingPgs = new BitField(2048);
    private static BitField unused5 = new BitField(61440);
    protected int field_9_dxaTab;
    protected int field_10_wSpare;
    protected int field_11_dxaHotz;
    protected int field_12_cConsexHypLim;
    protected int field_13_wSpare2;
    protected int field_14_dttmCreated;
    protected int field_15_dttmRevised;
    protected int field_16_dttmLastPrint;
    protected int field_17_nRevision;
    protected int field_18_tmEdited;
    protected int field_19_cWords;
    protected int field_20_cCh;
    protected int field_21_cPg;
    protected int field_22_cParas;
    protected short field_23_Edn;
    private static BitField rncEdn = new BitField(3);
    private static BitField nEdn = new BitField(65532);
    protected short field_24_Edn1;
    private static BitField epc = new BitField(3);
    private static BitField nfcFtnRef1 = new BitField(60);
    private static BitField nfcEdnRef1 = new BitField(960);
    private static BitField fPrintFormData = new BitField(1024);
    private static BitField fSaveFormData = new BitField(2048);
    private static BitField fShadeFormData = new BitField(4096);
    private static BitField fWCFtnEdn = new BitField(32768);
    protected int field_25_cLines;
    protected int field_26_cWordsFtnEnd;
    protected int field_27_cChFtnEdn;
    protected short field_28_cPgFtnEdn;
    protected int field_29_cParasFtnEdn;
    protected int field_30_cLinesFtnEdn;
    protected int field_31_lKeyProtDoc;
    protected short field_32_view;
    private static BitField wvkSaved = new BitField(7);
    private static BitField wScaleSaved = new BitField(4088);
    private static BitField zkSaved = new BitField(12288);
    private static BitField fRotateFontW6 = new BitField(16384);
    private static BitField iGutterPos = new BitField(32768);
    protected int field_33_docinfo4;
    private static BitField fNoTabForInd = new BitField(1);
    private static BitField fNoSpaceRaiseLower = new BitField(2);
    private static BitField fSupressSpdfAfterPageBreak = new BitField(4);
    private static BitField fWrapTrailSpaces = new BitField(8);
    private static BitField fMapPrintTextColor = new BitField(16);
    private static BitField fNoColumnBalance = new BitField(32);
    private static BitField fConvMailMergeEsc = new BitField(64);
    private static BitField fSupressTopSpacing = new BitField(128);
    private static BitField fOrigWordTableRules = new BitField(256);
    private static BitField fTransparentMetafiles = new BitField(512);
    private static BitField fShowBreaksInFrames = new BitField(1024);
    private static BitField fSwapBordersFacingPgs = new BitField(2048);
    private static BitField fSuppressTopSPacingMac5 = new BitField(65536);
    private static BitField fTruncDxaExpand = new BitField(131072);
    private static BitField fPrintBodyBeforeHdr = new BitField(262144);
    private static BitField fNoLeading = new BitField(524288);
    private static BitField fMWSmallCaps = new BitField(0x200000);
    protected short field_34_adt;
    protected byte[] field_35_doptypography = new byte[0];
    protected byte[] field_36_dogrid = new byte[0];
    protected short field_37_docinfo5;
    private static BitField lvl = new BitField(30);
    private static BitField fGramAllDone = new BitField(32);
    private static BitField fGramAllClean = new BitField(64);
    private static BitField fSubsetFonts = new BitField(128);
    private static BitField fHideLastVersion = new BitField(256);
    private static BitField fHtmlDoc = new BitField(512);
    private static BitField fSnapBorder = new BitField(2048);
    private static BitField fIncludeHeader = new BitField(4096);
    private static BitField fIncludeFooter = new BitField(8192);
    private static BitField fForcePageSizePag = new BitField(16384);
    private static BitField fMinFontSizePag = new BitField(32768);
    protected short field_38_docinfo6;
    private static BitField fHaveVersions = new BitField(1);
    private static BitField fAutoVersions = new BitField(2);
    protected byte[] field_39_asumyi = new byte[0];
    protected int field_40_cChWS;
    protected int field_41_cChWSFtnEdn;
    protected int field_42_grfDocEvents;
    protected int field_43_virusinfo;
    private static BitField fVirusPrompted = new BitField(1);
    private static BitField fVirusLoadSafe = new BitField(2);
    private static BitField KeyVirusSession30 = new BitField(-4);
    protected byte[] field_44_Spare = new byte[0];
    protected int field_45_reserved1;
    protected int field_46_reserved2;
    protected int field_47_cDBC;
    protected int field_48_cDBCFtnEdn;
    protected int field_49_reserved;
    protected short field_50_nfcFtnRef;
    protected short field_51_nfcEdnRef;
    protected short field_52_hpsZoonFontPag;
    protected short field_53_dywDispPag;

    protected DOPAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_formatFlags = byArray[0 + n];
        this.field_2_unused2 = byArray[1 + n];
        this.field_3_footnoteInfo = LittleEndian.getShort(byArray, 2 + n);
        this.field_4_fOutlineDirtySave = byArray[4 + n];
        this.field_5_docinfo = byArray[5 + n];
        this.field_6_docinfo1 = byArray[6 + n];
        this.field_7_docinfo2 = byArray[7 + n];
        this.field_8_docinfo3 = LittleEndian.getShort(byArray, 8 + n);
        this.field_9_dxaTab = LittleEndian.getShort(byArray, 10 + n);
        this.field_10_wSpare = LittleEndian.getShort(byArray, 12 + n);
        this.field_11_dxaHotz = LittleEndian.getShort(byArray, 14 + n);
        this.field_12_cConsexHypLim = LittleEndian.getShort(byArray, 16 + n);
        this.field_13_wSpare2 = LittleEndian.getShort(byArray, 18 + n);
        this.field_14_dttmCreated = LittleEndian.getInt(byArray, 20 + n);
        this.field_15_dttmRevised = LittleEndian.getInt(byArray, 24 + n);
        this.field_16_dttmLastPrint = LittleEndian.getInt(byArray, 28 + n);
        this.field_17_nRevision = LittleEndian.getShort(byArray, 32 + n);
        this.field_18_tmEdited = LittleEndian.getInt(byArray, 34 + n);
        this.field_19_cWords = LittleEndian.getInt(byArray, 38 + n);
        this.field_20_cCh = LittleEndian.getInt(byArray, 42 + n);
        this.field_21_cPg = LittleEndian.getShort(byArray, 46 + n);
        this.field_22_cParas = LittleEndian.getInt(byArray, 48 + n);
        this.field_23_Edn = LittleEndian.getShort(byArray, 52 + n);
        this.field_24_Edn1 = LittleEndian.getShort(byArray, 54 + n);
        this.field_25_cLines = LittleEndian.getInt(byArray, 56 + n);
        this.field_26_cWordsFtnEnd = LittleEndian.getInt(byArray, 60 + n);
        this.field_27_cChFtnEdn = LittleEndian.getInt(byArray, 64 + n);
        this.field_28_cPgFtnEdn = LittleEndian.getShort(byArray, 68 + n);
        this.field_29_cParasFtnEdn = LittleEndian.getInt(byArray, 70 + n);
        this.field_30_cLinesFtnEdn = LittleEndian.getInt(byArray, 74 + n);
        this.field_31_lKeyProtDoc = LittleEndian.getInt(byArray, 78 + n);
        this.field_32_view = LittleEndian.getShort(byArray, 82 + n);
        this.field_33_docinfo4 = LittleEndian.getInt(byArray, 84 + n);
        this.field_34_adt = LittleEndian.getShort(byArray, 88 + n);
        this.field_35_doptypography = LittleEndian.getByteArray(byArray, 90 + n, 310);
        this.field_36_dogrid = LittleEndian.getByteArray(byArray, 400 + n, 10);
        this.field_37_docinfo5 = LittleEndian.getShort(byArray, 410 + n);
        this.field_38_docinfo6 = LittleEndian.getShort(byArray, 412 + n);
        this.field_39_asumyi = LittleEndian.getByteArray(byArray, 414 + n, 12);
        this.field_40_cChWS = LittleEndian.getInt(byArray, 426 + n);
        this.field_41_cChWSFtnEdn = LittleEndian.getInt(byArray, 430 + n);
        this.field_42_grfDocEvents = LittleEndian.getInt(byArray, 434 + n);
        this.field_43_virusinfo = LittleEndian.getInt(byArray, 438 + n);
        this.field_44_Spare = LittleEndian.getByteArray(byArray, 442 + n, 30);
        this.field_45_reserved1 = LittleEndian.getInt(byArray, 472 + n);
        this.field_46_reserved2 = LittleEndian.getInt(byArray, 476 + n);
        this.field_47_cDBC = LittleEndian.getInt(byArray, 480 + n);
        this.field_48_cDBCFtnEdn = LittleEndian.getInt(byArray, 484 + n);
        this.field_49_reserved = LittleEndian.getInt(byArray, 488 + n);
        this.field_50_nfcFtnRef = LittleEndian.getShort(byArray, 492 + n);
        this.field_51_nfcEdnRef = LittleEndian.getShort(byArray, 494 + n);
        this.field_52_hpsZoonFontPag = LittleEndian.getShort(byArray, 496 + n);
        this.field_53_dywDispPag = LittleEndian.getShort(byArray, 498 + n);
    }

    public void serialize(byte[] byArray, int n) {
        byArray[0 + n] = this.field_1_formatFlags;
        byArray[1 + n] = this.field_2_unused2;
        LittleEndian.putShort(byArray, 2 + n, this.field_3_footnoteInfo);
        byArray[4 + n] = this.field_4_fOutlineDirtySave;
        byArray[5 + n] = this.field_5_docinfo;
        byArray[6 + n] = this.field_6_docinfo1;
        byArray[7 + n] = this.field_7_docinfo2;
        LittleEndian.putShort(byArray, 8 + n, this.field_8_docinfo3);
        LittleEndian.putShort(byArray, 10 + n, (short)this.field_9_dxaTab);
        LittleEndian.putShort(byArray, 12 + n, (short)this.field_10_wSpare);
        LittleEndian.putShort(byArray, 14 + n, (short)this.field_11_dxaHotz);
        LittleEndian.putShort(byArray, 16 + n, (short)this.field_12_cConsexHypLim);
        LittleEndian.putShort(byArray, 18 + n, (short)this.field_13_wSpare2);
        LittleEndian.putInt(byArray, 20 + n, this.field_14_dttmCreated);
        LittleEndian.putInt(byArray, 24 + n, this.field_15_dttmRevised);
        LittleEndian.putInt(byArray, 28 + n, this.field_16_dttmLastPrint);
        LittleEndian.putShort(byArray, 32 + n, (short)this.field_17_nRevision);
        LittleEndian.putInt(byArray, 34 + n, this.field_18_tmEdited);
        LittleEndian.putInt(byArray, 38 + n, this.field_19_cWords);
        LittleEndian.putInt(byArray, 42 + n, this.field_20_cCh);
        LittleEndian.putShort(byArray, 46 + n, (short)this.field_21_cPg);
        LittleEndian.putInt(byArray, 48 + n, this.field_22_cParas);
        LittleEndian.putShort(byArray, 52 + n, this.field_23_Edn);
        LittleEndian.putShort(byArray, 54 + n, this.field_24_Edn1);
        LittleEndian.putInt(byArray, 56 + n, this.field_25_cLines);
        LittleEndian.putInt(byArray, 60 + n, this.field_26_cWordsFtnEnd);
        LittleEndian.putInt(byArray, 64 + n, this.field_27_cChFtnEdn);
        LittleEndian.putShort(byArray, 68 + n, this.field_28_cPgFtnEdn);
        LittleEndian.putInt(byArray, 70 + n, this.field_29_cParasFtnEdn);
        LittleEndian.putInt(byArray, 74 + n, this.field_30_cLinesFtnEdn);
        LittleEndian.putInt(byArray, 78 + n, this.field_31_lKeyProtDoc);
        LittleEndian.putShort(byArray, 82 + n, this.field_32_view);
        LittleEndian.putInt(byArray, 84 + n, this.field_33_docinfo4);
        LittleEndian.putShort(byArray, 88 + n, this.field_34_adt);
        System.arraycopy(this.field_35_doptypography, 0, byArray, 90 + n, this.field_35_doptypography.length);
        System.arraycopy(this.field_36_dogrid, 0, byArray, 400 + n, this.field_36_dogrid.length);
        LittleEndian.putShort(byArray, 410 + n, this.field_37_docinfo5);
        LittleEndian.putShort(byArray, 412 + n, this.field_38_docinfo6);
        System.arraycopy(this.field_39_asumyi, 0, byArray, 414 + n, this.field_39_asumyi.length);
        LittleEndian.putInt(byArray, 426 + n, this.field_40_cChWS);
        LittleEndian.putInt(byArray, 430 + n, this.field_41_cChWSFtnEdn);
        LittleEndian.putInt(byArray, 434 + n, this.field_42_grfDocEvents);
        LittleEndian.putInt(byArray, 438 + n, this.field_43_virusinfo);
        System.arraycopy(this.field_44_Spare, 0, byArray, 442 + n, this.field_44_Spare.length);
        LittleEndian.putInt(byArray, 472 + n, this.field_45_reserved1);
        LittleEndian.putInt(byArray, 476 + n, this.field_46_reserved2);
        LittleEndian.putInt(byArray, 480 + n, this.field_47_cDBC);
        LittleEndian.putInt(byArray, 484 + n, this.field_48_cDBCFtnEdn);
        LittleEndian.putInt(byArray, 488 + n, this.field_49_reserved);
        LittleEndian.putShort(byArray, 492 + n, this.field_50_nfcFtnRef);
        LittleEndian.putShort(byArray, 494 + n, this.field_51_nfcEdnRef);
        LittleEndian.putShort(byArray, 496 + n, this.field_52_hpsZoonFontPag);
        LittleEndian.putShort(byArray, 498 + n, this.field_53_dywDispPag);
    }

    public static int getSize() {
        return 500;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[DOP]\n");
        stringBuilder.append("    .formatFlags          = ");
        stringBuilder.append(" (").append(this.getFormatFlags()).append(" )\n");
        stringBuilder.append("         .fFacingPages             = ").append(this.isFFacingPages()).append('\n');
        stringBuilder.append("         .fWidowControl            = ").append(this.isFWidowControl()).append('\n');
        stringBuilder.append("         .fPMHMainDoc              = ").append(this.isFPMHMainDoc()).append('\n');
        stringBuilder.append("         .grfSupression            = ").append(this.getGrfSupression()).append('\n');
        stringBuilder.append("         .fpc                      = ").append(this.getFpc()).append('\n');
        stringBuilder.append("         .unused1                  = ").append(this.isUnused1()).append('\n');
        stringBuilder.append("    .unused2              = ");
        stringBuilder.append(" (").append(this.getUnused2()).append(" )\n");
        stringBuilder.append("    .footnoteInfo         = ");
        stringBuilder.append(" (").append(this.getFootnoteInfo()).append(" )\n");
        stringBuilder.append("         .rncFtn                   = ").append(this.getRncFtn()).append('\n');
        stringBuilder.append("         .nFtn                     = ").append(this.getNFtn()).append('\n');
        stringBuilder.append("    .fOutlineDirtySave    = ");
        stringBuilder.append(" (").append(this.getFOutlineDirtySave()).append(" )\n");
        stringBuilder.append("    .docinfo              = ");
        stringBuilder.append(" (").append(this.getDocinfo()).append(" )\n");
        stringBuilder.append("         .fOnlyMacPics             = ").append(this.isFOnlyMacPics()).append('\n');
        stringBuilder.append("         .fOnlyWinPics             = ").append(this.isFOnlyWinPics()).append('\n');
        stringBuilder.append("         .fLabelDoc                = ").append(this.isFLabelDoc()).append('\n');
        stringBuilder.append("         .fHyphCapitals            = ").append(this.isFHyphCapitals()).append('\n');
        stringBuilder.append("         .fAutoHyphen              = ").append(this.isFAutoHyphen()).append('\n');
        stringBuilder.append("         .fFormNoFields            = ").append(this.isFFormNoFields()).append('\n');
        stringBuilder.append("         .fLinkStyles              = ").append(this.isFLinkStyles()).append('\n');
        stringBuilder.append("         .fRevMarking              = ").append(this.isFRevMarking()).append('\n');
        stringBuilder.append("    .docinfo1             = ");
        stringBuilder.append(" (").append(this.getDocinfo1()).append(" )\n");
        stringBuilder.append("         .fBackup                  = ").append(this.isFBackup()).append('\n');
        stringBuilder.append("         .fExactCWords             = ").append(this.isFExactCWords()).append('\n');
        stringBuilder.append("         .fPagHidden               = ").append(this.isFPagHidden()).append('\n');
        stringBuilder.append("         .fPagResults              = ").append(this.isFPagResults()).append('\n');
        stringBuilder.append("         .fLockAtn                 = ").append(this.isFLockAtn()).append('\n');
        stringBuilder.append("         .fMirrorMargins           = ").append(this.isFMirrorMargins()).append('\n');
        stringBuilder.append("         .unused3                  = ").append(this.isUnused3()).append('\n');
        stringBuilder.append("         .fDfltTrueType            = ").append(this.isFDfltTrueType()).append('\n');
        stringBuilder.append("    .docinfo2             = ");
        stringBuilder.append(" (").append(this.getDocinfo2()).append(" )\n");
        stringBuilder.append("         .fPagSupressTopSpacing     = ").append(this.isFPagSupressTopSpacing()).append('\n');
        stringBuilder.append("         .fProtEnabled             = ").append(this.isFProtEnabled()).append('\n');
        stringBuilder.append("         .fDispFormFldSel          = ").append(this.isFDispFormFldSel()).append('\n');
        stringBuilder.append("         .fRMView                  = ").append(this.isFRMView()).append('\n');
        stringBuilder.append("         .fRMPrint                 = ").append(this.isFRMPrint()).append('\n');
        stringBuilder.append("         .unused4                  = ").append(this.isUnused4()).append('\n');
        stringBuilder.append("         .fLockRev                 = ").append(this.isFLockRev()).append('\n');
        stringBuilder.append("         .fEmbedFonts              = ").append(this.isFEmbedFonts()).append('\n');
        stringBuilder.append("    .docinfo3             = ");
        stringBuilder.append(" (").append(this.getDocinfo3()).append(" )\n");
        stringBuilder.append("         .oldfNoTabForInd          = ").append(this.isOldfNoTabForInd()).append('\n');
        stringBuilder.append("         .oldfNoSpaceRaiseLower     = ").append(this.isOldfNoSpaceRaiseLower()).append('\n');
        stringBuilder.append("         .oldfSuppressSpbfAfterPageBreak     = ").append(this.isOldfSuppressSpbfAfterPageBreak()).append('\n');
        stringBuilder.append("         .oldfWrapTrailSpaces      = ").append(this.isOldfWrapTrailSpaces()).append('\n');
        stringBuilder.append("         .oldfMapPrintTextColor     = ").append(this.isOldfMapPrintTextColor()).append('\n');
        stringBuilder.append("         .oldfNoColumnBalance      = ").append(this.isOldfNoColumnBalance()).append('\n');
        stringBuilder.append("         .oldfConvMailMergeEsc     = ").append(this.isOldfConvMailMergeEsc()).append('\n');
        stringBuilder.append("         .oldfSupressTopSpacing     = ").append(this.isOldfSupressTopSpacing()).append('\n');
        stringBuilder.append("         .oldfOrigWordTableRules     = ").append(this.isOldfOrigWordTableRules()).append('\n');
        stringBuilder.append("         .oldfTransparentMetafiles     = ").append(this.isOldfTransparentMetafiles()).append('\n');
        stringBuilder.append("         .oldfShowBreaksInFrames     = ").append(this.isOldfShowBreaksInFrames()).append('\n');
        stringBuilder.append("         .oldfSwapBordersFacingPgs     = ").append(this.isOldfSwapBordersFacingPgs()).append('\n');
        stringBuilder.append("         .unused5                  = ").append(this.getUnused5()).append('\n');
        stringBuilder.append("    .dxaTab               = ");
        stringBuilder.append(" (").append(this.getDxaTab()).append(" )\n");
        stringBuilder.append("    .wSpare               = ");
        stringBuilder.append(" (").append(this.getWSpare()).append(" )\n");
        stringBuilder.append("    .dxaHotz              = ");
        stringBuilder.append(" (").append(this.getDxaHotz()).append(" )\n");
        stringBuilder.append("    .cConsexHypLim        = ");
        stringBuilder.append(" (").append(this.getCConsexHypLim()).append(" )\n");
        stringBuilder.append("    .wSpare2              = ");
        stringBuilder.append(" (").append(this.getWSpare2()).append(" )\n");
        stringBuilder.append("    .dttmCreated          = ");
        stringBuilder.append(" (").append(this.getDttmCreated()).append(" )\n");
        stringBuilder.append("    .dttmRevised          = ");
        stringBuilder.append(" (").append(this.getDttmRevised()).append(" )\n");
        stringBuilder.append("    .dttmLastPrint        = ");
        stringBuilder.append(" (").append(this.getDttmLastPrint()).append(" )\n");
        stringBuilder.append("    .nRevision            = ");
        stringBuilder.append(" (").append(this.getNRevision()).append(" )\n");
        stringBuilder.append("    .tmEdited             = ");
        stringBuilder.append(" (").append(this.getTmEdited()).append(" )\n");
        stringBuilder.append("    .cWords               = ");
        stringBuilder.append(" (").append(this.getCWords()).append(" )\n");
        stringBuilder.append("    .cCh                  = ");
        stringBuilder.append(" (").append(this.getCCh()).append(" )\n");
        stringBuilder.append("    .cPg                  = ");
        stringBuilder.append(" (").append(this.getCPg()).append(" )\n");
        stringBuilder.append("    .cParas               = ");
        stringBuilder.append(" (").append(this.getCParas()).append(" )\n");
        stringBuilder.append("    .Edn                  = ");
        stringBuilder.append(" (").append(this.getEdn()).append(" )\n");
        stringBuilder.append("         .rncEdn                   = ").append(this.getRncEdn()).append('\n');
        stringBuilder.append("         .nEdn                     = ").append(this.getNEdn()).append('\n');
        stringBuilder.append("    .Edn1                 = ");
        stringBuilder.append(" (").append(this.getEdn1()).append(" )\n");
        stringBuilder.append("         .epc                      = ").append(this.getEpc()).append('\n');
        stringBuilder.append("         .nfcFtnRef1               = ").append(this.getNfcFtnRef1()).append('\n');
        stringBuilder.append("         .nfcEdnRef1               = ").append(this.getNfcEdnRef1()).append('\n');
        stringBuilder.append("         .fPrintFormData           = ").append(this.isFPrintFormData()).append('\n');
        stringBuilder.append("         .fSaveFormData            = ").append(this.isFSaveFormData()).append('\n');
        stringBuilder.append("         .fShadeFormData           = ").append(this.isFShadeFormData()).append('\n');
        stringBuilder.append("         .fWCFtnEdn                = ").append(this.isFWCFtnEdn()).append('\n');
        stringBuilder.append("    .cLines               = ");
        stringBuilder.append(" (").append(this.getCLines()).append(" )\n");
        stringBuilder.append("    .cWordsFtnEnd         = ");
        stringBuilder.append(" (").append(this.getCWordsFtnEnd()).append(" )\n");
        stringBuilder.append("    .cChFtnEdn            = ");
        stringBuilder.append(" (").append(this.getCChFtnEdn()).append(" )\n");
        stringBuilder.append("    .cPgFtnEdn            = ");
        stringBuilder.append(" (").append(this.getCPgFtnEdn()).append(" )\n");
        stringBuilder.append("    .cParasFtnEdn         = ");
        stringBuilder.append(" (").append(this.getCParasFtnEdn()).append(" )\n");
        stringBuilder.append("    .cLinesFtnEdn         = ");
        stringBuilder.append(" (").append(this.getCLinesFtnEdn()).append(" )\n");
        stringBuilder.append("    .lKeyProtDoc          = ");
        stringBuilder.append(" (").append(this.getLKeyProtDoc()).append(" )\n");
        stringBuilder.append("    .view                 = ");
        stringBuilder.append(" (").append(this.getView()).append(" )\n");
        stringBuilder.append("         .wvkSaved                 = ").append(this.getWvkSaved()).append('\n');
        stringBuilder.append("         .wScaleSaved              = ").append(this.getWScaleSaved()).append('\n');
        stringBuilder.append("         .zkSaved                  = ").append(this.getZkSaved()).append('\n');
        stringBuilder.append("         .fRotateFontW6            = ").append(this.isFRotateFontW6()).append('\n');
        stringBuilder.append("         .iGutterPos               = ").append(this.isIGutterPos()).append('\n');
        stringBuilder.append("    .docinfo4             = ");
        stringBuilder.append(" (").append(this.getDocinfo4()).append(" )\n");
        stringBuilder.append("         .fNoTabForInd             = ").append(this.isFNoTabForInd()).append('\n');
        stringBuilder.append("         .fNoSpaceRaiseLower       = ").append(this.isFNoSpaceRaiseLower()).append('\n');
        stringBuilder.append("         .fSupressSpdfAfterPageBreak     = ").append(this.isFSupressSpdfAfterPageBreak()).append('\n');
        stringBuilder.append("         .fWrapTrailSpaces         = ").append(this.isFWrapTrailSpaces()).append('\n');
        stringBuilder.append("         .fMapPrintTextColor       = ").append(this.isFMapPrintTextColor()).append('\n');
        stringBuilder.append("         .fNoColumnBalance         = ").append(this.isFNoColumnBalance()).append('\n');
        stringBuilder.append("         .fConvMailMergeEsc        = ").append(this.isFConvMailMergeEsc()).append('\n');
        stringBuilder.append("         .fSupressTopSpacing       = ").append(this.isFSupressTopSpacing()).append('\n');
        stringBuilder.append("         .fOrigWordTableRules      = ").append(this.isFOrigWordTableRules()).append('\n');
        stringBuilder.append("         .fTransparentMetafiles     = ").append(this.isFTransparentMetafiles()).append('\n');
        stringBuilder.append("         .fShowBreaksInFrames      = ").append(this.isFShowBreaksInFrames()).append('\n');
        stringBuilder.append("         .fSwapBordersFacingPgs     = ").append(this.isFSwapBordersFacingPgs()).append('\n');
        stringBuilder.append("         .fSuppressTopSPacingMac5     = ").append(this.isFSuppressTopSPacingMac5()).append('\n');
        stringBuilder.append("         .fTruncDxaExpand          = ").append(this.isFTruncDxaExpand()).append('\n');
        stringBuilder.append("         .fPrintBodyBeforeHdr      = ").append(this.isFPrintBodyBeforeHdr()).append('\n');
        stringBuilder.append("         .fNoLeading               = ").append(this.isFNoLeading()).append('\n');
        stringBuilder.append("         .fMWSmallCaps             = ").append(this.isFMWSmallCaps()).append('\n');
        stringBuilder.append("    .adt                  = ");
        stringBuilder.append(" (").append(this.getAdt()).append(" )\n");
        stringBuilder.append("    .doptypography        = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getDoptypography())).append(" )\n");
        stringBuilder.append("    .dogrid               = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getDogrid())).append(" )\n");
        stringBuilder.append("    .docinfo5             = ");
        stringBuilder.append(" (").append(this.getDocinfo5()).append(" )\n");
        stringBuilder.append("         .lvl                      = ").append(this.getLvl()).append('\n');
        stringBuilder.append("         .fGramAllDone             = ").append(this.isFGramAllDone()).append('\n');
        stringBuilder.append("         .fGramAllClean            = ").append(this.isFGramAllClean()).append('\n');
        stringBuilder.append("         .fSubsetFonts             = ").append(this.isFSubsetFonts()).append('\n');
        stringBuilder.append("         .fHideLastVersion         = ").append(this.isFHideLastVersion()).append('\n');
        stringBuilder.append("         .fHtmlDoc                 = ").append(this.isFHtmlDoc()).append('\n');
        stringBuilder.append("         .fSnapBorder              = ").append(this.isFSnapBorder()).append('\n');
        stringBuilder.append("         .fIncludeHeader           = ").append(this.isFIncludeHeader()).append('\n');
        stringBuilder.append("         .fIncludeFooter           = ").append(this.isFIncludeFooter()).append('\n');
        stringBuilder.append("         .fForcePageSizePag        = ").append(this.isFForcePageSizePag()).append('\n');
        stringBuilder.append("         .fMinFontSizePag          = ").append(this.isFMinFontSizePag()).append('\n');
        stringBuilder.append("    .docinfo6             = ");
        stringBuilder.append(" (").append(this.getDocinfo6()).append(" )\n");
        stringBuilder.append("         .fHaveVersions            = ").append(this.isFHaveVersions()).append('\n');
        stringBuilder.append("         .fAutoVersions            = ").append(this.isFAutoVersions()).append('\n');
        stringBuilder.append("    .asumyi               = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getAsumyi())).append(" )\n");
        stringBuilder.append("    .cChWS                = ");
        stringBuilder.append(" (").append(this.getCChWS()).append(" )\n");
        stringBuilder.append("    .cChWSFtnEdn          = ");
        stringBuilder.append(" (").append(this.getCChWSFtnEdn()).append(" )\n");
        stringBuilder.append("    .grfDocEvents         = ");
        stringBuilder.append(" (").append(this.getGrfDocEvents()).append(" )\n");
        stringBuilder.append("    .virusinfo            = ");
        stringBuilder.append(" (").append(this.getVirusinfo()).append(" )\n");
        stringBuilder.append("         .fVirusPrompted           = ").append(this.isFVirusPrompted()).append('\n');
        stringBuilder.append("         .fVirusLoadSafe           = ").append(this.isFVirusLoadSafe()).append('\n');
        stringBuilder.append("         .KeyVirusSession30        = ").append(this.getKeyVirusSession30()).append('\n');
        stringBuilder.append("    .Spare                = ");
        stringBuilder.append(" (").append(Arrays.toString(this.getSpare())).append(" )\n");
        stringBuilder.append("    .reserved1            = ");
        stringBuilder.append(" (").append(this.getReserved1()).append(" )\n");
        stringBuilder.append("    .reserved2            = ");
        stringBuilder.append(" (").append(this.getReserved2()).append(" )\n");
        stringBuilder.append("    .cDBC                 = ");
        stringBuilder.append(" (").append(this.getCDBC()).append(" )\n");
        stringBuilder.append("    .cDBCFtnEdn           = ");
        stringBuilder.append(" (").append(this.getCDBCFtnEdn()).append(" )\n");
        stringBuilder.append("    .reserved             = ");
        stringBuilder.append(" (").append(this.getReserved()).append(" )\n");
        stringBuilder.append("    .nfcFtnRef            = ");
        stringBuilder.append(" (").append(this.getNfcFtnRef()).append(" )\n");
        stringBuilder.append("    .nfcEdnRef            = ");
        stringBuilder.append(" (").append(this.getNfcEdnRef()).append(" )\n");
        stringBuilder.append("    .hpsZoonFontPag       = ");
        stringBuilder.append(" (").append(this.getHpsZoonFontPag()).append(" )\n");
        stringBuilder.append("    .dywDispPag           = ");
        stringBuilder.append(" (").append(this.getDywDispPag()).append(" )\n");
        stringBuilder.append("[/DOP]\n");
        return stringBuilder.toString();
    }

    @Internal
    public byte getFormatFlags() {
        return this.field_1_formatFlags;
    }

    @Internal
    public void setFormatFlags(byte by) {
        this.field_1_formatFlags = by;
    }

    @Internal
    public byte getUnused2() {
        return this.field_2_unused2;
    }

    @Internal
    public void setUnused2(byte by) {
        this.field_2_unused2 = by;
    }

    @Internal
    public short getFootnoteInfo() {
        return this.field_3_footnoteInfo;
    }

    @Internal
    public void setFootnoteInfo(short s) {
        this.field_3_footnoteInfo = s;
    }

    @Internal
    public byte getFOutlineDirtySave() {
        return this.field_4_fOutlineDirtySave;
    }

    @Internal
    public void setFOutlineDirtySave(byte by) {
        this.field_4_fOutlineDirtySave = by;
    }

    @Internal
    public byte getDocinfo() {
        return this.field_5_docinfo;
    }

    @Internal
    public void setDocinfo(byte by) {
        this.field_5_docinfo = by;
    }

    @Internal
    public byte getDocinfo1() {
        return this.field_6_docinfo1;
    }

    @Internal
    public void setDocinfo1(byte by) {
        this.field_6_docinfo1 = by;
    }

    @Internal
    public byte getDocinfo2() {
        return this.field_7_docinfo2;
    }

    @Internal
    public void setDocinfo2(byte by) {
        this.field_7_docinfo2 = by;
    }

    @Internal
    public short getDocinfo3() {
        return this.field_8_docinfo3;
    }

    @Internal
    public void setDocinfo3(short s) {
        this.field_8_docinfo3 = s;
    }

    @Internal
    public int getDxaTab() {
        return this.field_9_dxaTab;
    }

    @Internal
    public void setDxaTab(int n) {
        this.field_9_dxaTab = n;
    }

    @Internal
    public int getWSpare() {
        return this.field_10_wSpare;
    }

    @Internal
    public void setWSpare(int n) {
        this.field_10_wSpare = n;
    }

    @Internal
    public int getDxaHotz() {
        return this.field_11_dxaHotz;
    }

    @Internal
    public void setDxaHotz(int n) {
        this.field_11_dxaHotz = n;
    }

    @Internal
    public int getCConsexHypLim() {
        return this.field_12_cConsexHypLim;
    }

    @Internal
    public void setCConsexHypLim(int n) {
        this.field_12_cConsexHypLim = n;
    }

    @Internal
    public int getWSpare2() {
        return this.field_13_wSpare2;
    }

    @Internal
    public void setWSpare2(int n) {
        this.field_13_wSpare2 = n;
    }

    @Internal
    public int getDttmCreated() {
        return this.field_14_dttmCreated;
    }

    @Internal
    public void setDttmCreated(int n) {
        this.field_14_dttmCreated = n;
    }

    @Internal
    public int getDttmRevised() {
        return this.field_15_dttmRevised;
    }

    @Internal
    public void setDttmRevised(int n) {
        this.field_15_dttmRevised = n;
    }

    @Internal
    public int getDttmLastPrint() {
        return this.field_16_dttmLastPrint;
    }

    @Internal
    public void setDttmLastPrint(int n) {
        this.field_16_dttmLastPrint = n;
    }

    @Internal
    public int getNRevision() {
        return this.field_17_nRevision;
    }

    @Internal
    public void setNRevision(int n) {
        this.field_17_nRevision = n;
    }

    @Internal
    public int getTmEdited() {
        return this.field_18_tmEdited;
    }

    @Internal
    public void setTmEdited(int n) {
        this.field_18_tmEdited = n;
    }

    @Internal
    public int getCWords() {
        return this.field_19_cWords;
    }

    @Internal
    public void setCWords(int n) {
        this.field_19_cWords = n;
    }

    @Internal
    public int getCCh() {
        return this.field_20_cCh;
    }

    @Internal
    public void setCCh(int n) {
        this.field_20_cCh = n;
    }

    @Internal
    public int getCPg() {
        return this.field_21_cPg;
    }

    @Internal
    public void setCPg(int n) {
        this.field_21_cPg = n;
    }

    @Internal
    public int getCParas() {
        return this.field_22_cParas;
    }

    @Internal
    public void setCParas(int n) {
        this.field_22_cParas = n;
    }

    @Internal
    public short getEdn() {
        return this.field_23_Edn;
    }

    @Internal
    public void setEdn(short s) {
        this.field_23_Edn = s;
    }

    @Internal
    public short getEdn1() {
        return this.field_24_Edn1;
    }

    @Internal
    public void setEdn1(short s) {
        this.field_24_Edn1 = s;
    }

    @Internal
    public int getCLines() {
        return this.field_25_cLines;
    }

    @Internal
    public void setCLines(int n) {
        this.field_25_cLines = n;
    }

    @Internal
    public int getCWordsFtnEnd() {
        return this.field_26_cWordsFtnEnd;
    }

    @Internal
    public void setCWordsFtnEnd(int n) {
        this.field_26_cWordsFtnEnd = n;
    }

    @Internal
    public int getCChFtnEdn() {
        return this.field_27_cChFtnEdn;
    }

    @Internal
    public void setCChFtnEdn(int n) {
        this.field_27_cChFtnEdn = n;
    }

    @Internal
    public short getCPgFtnEdn() {
        return this.field_28_cPgFtnEdn;
    }

    @Internal
    public void setCPgFtnEdn(short s) {
        this.field_28_cPgFtnEdn = s;
    }

    @Internal
    public int getCParasFtnEdn() {
        return this.field_29_cParasFtnEdn;
    }

    @Internal
    public void setCParasFtnEdn(int n) {
        this.field_29_cParasFtnEdn = n;
    }

    @Internal
    public int getCLinesFtnEdn() {
        return this.field_30_cLinesFtnEdn;
    }

    @Internal
    public void setCLinesFtnEdn(int n) {
        this.field_30_cLinesFtnEdn = n;
    }

    @Internal
    public int getLKeyProtDoc() {
        return this.field_31_lKeyProtDoc;
    }

    @Internal
    public void setLKeyProtDoc(int n) {
        this.field_31_lKeyProtDoc = n;
    }

    @Internal
    public short getView() {
        return this.field_32_view;
    }

    @Internal
    public void setView(short s) {
        this.field_32_view = s;
    }

    @Internal
    public int getDocinfo4() {
        return this.field_33_docinfo4;
    }

    @Internal
    public void setDocinfo4(int n) {
        this.field_33_docinfo4 = n;
    }

    @Internal
    public short getAdt() {
        return this.field_34_adt;
    }

    @Internal
    public void setAdt(short s) {
        this.field_34_adt = s;
    }

    @Internal
    public byte[] getDoptypography() {
        return this.field_35_doptypography;
    }

    @Internal
    public void setDoptypography(byte[] byArray) {
        this.field_35_doptypography = byArray;
    }

    @Internal
    public byte[] getDogrid() {
        return this.field_36_dogrid;
    }

    @Internal
    public void setDogrid(byte[] byArray) {
        this.field_36_dogrid = byArray;
    }

    @Internal
    public short getDocinfo5() {
        return this.field_37_docinfo5;
    }

    @Internal
    public void setDocinfo5(short s) {
        this.field_37_docinfo5 = s;
    }

    @Internal
    public short getDocinfo6() {
        return this.field_38_docinfo6;
    }

    @Internal
    public void setDocinfo6(short s) {
        this.field_38_docinfo6 = s;
    }

    @Internal
    public byte[] getAsumyi() {
        return this.field_39_asumyi;
    }

    @Internal
    public void setAsumyi(byte[] byArray) {
        this.field_39_asumyi = byArray;
    }

    @Internal
    public int getCChWS() {
        return this.field_40_cChWS;
    }

    @Internal
    public void setCChWS(int n) {
        this.field_40_cChWS = n;
    }

    @Internal
    public int getCChWSFtnEdn() {
        return this.field_41_cChWSFtnEdn;
    }

    @Internal
    public void setCChWSFtnEdn(int n) {
        this.field_41_cChWSFtnEdn = n;
    }

    @Internal
    public int getGrfDocEvents() {
        return this.field_42_grfDocEvents;
    }

    @Internal
    public void setGrfDocEvents(int n) {
        this.field_42_grfDocEvents = n;
    }

    @Internal
    public int getVirusinfo() {
        return this.field_43_virusinfo;
    }

    @Internal
    public void setVirusinfo(int n) {
        this.field_43_virusinfo = n;
    }

    @Internal
    public byte[] getSpare() {
        return this.field_44_Spare;
    }

    @Internal
    public void setSpare(byte[] byArray) {
        this.field_44_Spare = byArray;
    }

    @Internal
    public int getReserved1() {
        return this.field_45_reserved1;
    }

    @Internal
    public void setReserved1(int n) {
        this.field_45_reserved1 = n;
    }

    @Internal
    public int getReserved2() {
        return this.field_46_reserved2;
    }

    @Internal
    public void setReserved2(int n) {
        this.field_46_reserved2 = n;
    }

    @Internal
    public int getCDBC() {
        return this.field_47_cDBC;
    }

    @Internal
    public void setCDBC(int n) {
        this.field_47_cDBC = n;
    }

    @Internal
    public int getCDBCFtnEdn() {
        return this.field_48_cDBCFtnEdn;
    }

    @Internal
    public void setCDBCFtnEdn(int n) {
        this.field_48_cDBCFtnEdn = n;
    }

    @Internal
    public int getReserved() {
        return this.field_49_reserved;
    }

    @Internal
    public void setReserved(int n) {
        this.field_49_reserved = n;
    }

    @Internal
    public short getNfcFtnRef() {
        return this.field_50_nfcFtnRef;
    }

    @Internal
    public void setNfcFtnRef(short s) {
        this.field_50_nfcFtnRef = s;
    }

    @Internal
    public short getNfcEdnRef() {
        return this.field_51_nfcEdnRef;
    }

    @Internal
    public void setNfcEdnRef(short s) {
        this.field_51_nfcEdnRef = s;
    }

    @Internal
    public short getHpsZoonFontPag() {
        return this.field_52_hpsZoonFontPag;
    }

    @Internal
    public void setHpsZoonFontPag(short s) {
        this.field_52_hpsZoonFontPag = s;
    }

    @Internal
    public short getDywDispPag() {
        return this.field_53_dywDispPag;
    }

    @Internal
    public void setDywDispPag(short s) {
        this.field_53_dywDispPag = s;
    }

    @Internal
    public void setFFacingPages(boolean bl) {
        this.field_1_formatFlags = (byte)fFacingPages.setBoolean(this.field_1_formatFlags, bl);
    }

    @Internal
    public boolean isFFacingPages() {
        return fFacingPages.isSet(this.field_1_formatFlags);
    }

    @Internal
    public void setFWidowControl(boolean bl) {
        this.field_1_formatFlags = (byte)fWidowControl.setBoolean(this.field_1_formatFlags, bl);
    }

    @Internal
    public boolean isFWidowControl() {
        return fWidowControl.isSet(this.field_1_formatFlags);
    }

    @Internal
    public void setFPMHMainDoc(boolean bl) {
        this.field_1_formatFlags = (byte)fPMHMainDoc.setBoolean(this.field_1_formatFlags, bl);
    }

    @Internal
    public boolean isFPMHMainDoc() {
        return fPMHMainDoc.isSet(this.field_1_formatFlags);
    }

    @Internal
    public void setGrfSupression(byte by) {
        this.field_1_formatFlags = (byte)grfSupression.setValue(this.field_1_formatFlags, by);
    }

    @Internal
    public byte getGrfSupression() {
        return (byte)grfSupression.getValue(this.field_1_formatFlags);
    }

    @Internal
    public void setFpc(byte by) {
        this.field_1_formatFlags = (byte)fpc.setValue(this.field_1_formatFlags, by);
    }

    @Internal
    public byte getFpc() {
        return (byte)fpc.getValue(this.field_1_formatFlags);
    }

    @Internal
    public void setUnused1(boolean bl) {
        this.field_1_formatFlags = (byte)unused1.setBoolean(this.field_1_formatFlags, bl);
    }

    @Internal
    public boolean isUnused1() {
        return unused1.isSet(this.field_1_formatFlags);
    }

    @Internal
    public void setRncFtn(byte by) {
        this.field_3_footnoteInfo = (short)rncFtn.setValue(this.field_3_footnoteInfo, by);
    }

    @Internal
    public byte getRncFtn() {
        return (byte)rncFtn.getValue(this.field_3_footnoteInfo);
    }

    @Internal
    public void setNFtn(short s) {
        this.field_3_footnoteInfo = (short)nFtn.setValue(this.field_3_footnoteInfo, s);
    }

    @Internal
    public short getNFtn() {
        return (short)nFtn.getValue(this.field_3_footnoteInfo);
    }

    @Internal
    public void setFOnlyMacPics(boolean bl) {
        this.field_5_docinfo = (byte)fOnlyMacPics.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFOnlyMacPics() {
        return fOnlyMacPics.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFOnlyWinPics(boolean bl) {
        this.field_5_docinfo = (byte)fOnlyWinPics.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFOnlyWinPics() {
        return fOnlyWinPics.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFLabelDoc(boolean bl) {
        this.field_5_docinfo = (byte)fLabelDoc.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFLabelDoc() {
        return fLabelDoc.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFHyphCapitals(boolean bl) {
        this.field_5_docinfo = (byte)fHyphCapitals.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFHyphCapitals() {
        return fHyphCapitals.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFAutoHyphen(boolean bl) {
        this.field_5_docinfo = (byte)fAutoHyphen.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFAutoHyphen() {
        return fAutoHyphen.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFFormNoFields(boolean bl) {
        this.field_5_docinfo = (byte)fFormNoFields.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFFormNoFields() {
        return fFormNoFields.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFLinkStyles(boolean bl) {
        this.field_5_docinfo = (byte)fLinkStyles.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFLinkStyles() {
        return fLinkStyles.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFRevMarking(boolean bl) {
        this.field_5_docinfo = (byte)fRevMarking.setBoolean(this.field_5_docinfo, bl);
    }

    @Internal
    public boolean isFRevMarking() {
        return fRevMarking.isSet(this.field_5_docinfo);
    }

    @Internal
    public void setFBackup(boolean bl) {
        this.field_6_docinfo1 = (byte)fBackup.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isFBackup() {
        return fBackup.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setFExactCWords(boolean bl) {
        this.field_6_docinfo1 = (byte)fExactCWords.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isFExactCWords() {
        return fExactCWords.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setFPagHidden(boolean bl) {
        this.field_6_docinfo1 = (byte)fPagHidden.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isFPagHidden() {
        return fPagHidden.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setFPagResults(boolean bl) {
        this.field_6_docinfo1 = (byte)fPagResults.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isFPagResults() {
        return fPagResults.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setFLockAtn(boolean bl) {
        this.field_6_docinfo1 = (byte)fLockAtn.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isFLockAtn() {
        return fLockAtn.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setFMirrorMargins(boolean bl) {
        this.field_6_docinfo1 = (byte)fMirrorMargins.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isFMirrorMargins() {
        return fMirrorMargins.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setUnused3(boolean bl) {
        this.field_6_docinfo1 = (byte)unused3.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isUnused3() {
        return unused3.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setFDfltTrueType(boolean bl) {
        this.field_6_docinfo1 = (byte)fDfltTrueType.setBoolean(this.field_6_docinfo1, bl);
    }

    @Internal
    public boolean isFDfltTrueType() {
        return fDfltTrueType.isSet(this.field_6_docinfo1);
    }

    @Internal
    public void setFPagSupressTopSpacing(boolean bl) {
        this.field_7_docinfo2 = (byte)fPagSupressTopSpacing.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isFPagSupressTopSpacing() {
        return fPagSupressTopSpacing.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setFProtEnabled(boolean bl) {
        this.field_7_docinfo2 = (byte)fProtEnabled.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isFProtEnabled() {
        return fProtEnabled.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setFDispFormFldSel(boolean bl) {
        this.field_7_docinfo2 = (byte)fDispFormFldSel.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isFDispFormFldSel() {
        return fDispFormFldSel.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setFRMView(boolean bl) {
        this.field_7_docinfo2 = (byte)fRMView.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isFRMView() {
        return fRMView.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setFRMPrint(boolean bl) {
        this.field_7_docinfo2 = (byte)fRMPrint.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isFRMPrint() {
        return fRMPrint.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setUnused4(boolean bl) {
        this.field_7_docinfo2 = (byte)unused4.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isUnused4() {
        return unused4.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setFLockRev(boolean bl) {
        this.field_7_docinfo2 = (byte)fLockRev.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isFLockRev() {
        return fLockRev.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setFEmbedFonts(boolean bl) {
        this.field_7_docinfo2 = (byte)fEmbedFonts.setBoolean(this.field_7_docinfo2, bl);
    }

    @Internal
    public boolean isFEmbedFonts() {
        return fEmbedFonts.isSet(this.field_7_docinfo2);
    }

    @Internal
    public void setOldfNoTabForInd(boolean bl) {
        this.field_8_docinfo3 = (short)oldfNoTabForInd.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfNoTabForInd() {
        return oldfNoTabForInd.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfNoSpaceRaiseLower(boolean bl) {
        this.field_8_docinfo3 = (short)oldfNoSpaceRaiseLower.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfNoSpaceRaiseLower() {
        return oldfNoSpaceRaiseLower.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfSuppressSpbfAfterPageBreak(boolean bl) {
        this.field_8_docinfo3 = (short)oldfSuppressSpbfAfterPageBreak.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfSuppressSpbfAfterPageBreak() {
        return oldfSuppressSpbfAfterPageBreak.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfWrapTrailSpaces(boolean bl) {
        this.field_8_docinfo3 = (short)oldfWrapTrailSpaces.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfWrapTrailSpaces() {
        return oldfWrapTrailSpaces.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfMapPrintTextColor(boolean bl) {
        this.field_8_docinfo3 = (short)oldfMapPrintTextColor.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfMapPrintTextColor() {
        return oldfMapPrintTextColor.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfNoColumnBalance(boolean bl) {
        this.field_8_docinfo3 = (short)oldfNoColumnBalance.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfNoColumnBalance() {
        return oldfNoColumnBalance.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfConvMailMergeEsc(boolean bl) {
        this.field_8_docinfo3 = (short)oldfConvMailMergeEsc.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfConvMailMergeEsc() {
        return oldfConvMailMergeEsc.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfSupressTopSpacing(boolean bl) {
        this.field_8_docinfo3 = (short)oldfSupressTopSpacing.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfSupressTopSpacing() {
        return oldfSupressTopSpacing.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfOrigWordTableRules(boolean bl) {
        this.field_8_docinfo3 = (short)oldfOrigWordTableRules.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfOrigWordTableRules() {
        return oldfOrigWordTableRules.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfTransparentMetafiles(boolean bl) {
        this.field_8_docinfo3 = (short)oldfTransparentMetafiles.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfTransparentMetafiles() {
        return oldfTransparentMetafiles.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfShowBreaksInFrames(boolean bl) {
        this.field_8_docinfo3 = (short)oldfShowBreaksInFrames.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfShowBreaksInFrames() {
        return oldfShowBreaksInFrames.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setOldfSwapBordersFacingPgs(boolean bl) {
        this.field_8_docinfo3 = (short)oldfSwapBordersFacingPgs.setBoolean(this.field_8_docinfo3, bl);
    }

    @Internal
    public boolean isOldfSwapBordersFacingPgs() {
        return oldfSwapBordersFacingPgs.isSet(this.field_8_docinfo3);
    }

    @Internal
    public void setUnused5(byte by) {
        this.field_8_docinfo3 = (short)unused5.setValue(this.field_8_docinfo3, by);
    }

    @Internal
    public byte getUnused5() {
        return (byte)unused5.getValue(this.field_8_docinfo3);
    }

    @Internal
    public void setRncEdn(byte by) {
        this.field_23_Edn = (short)rncEdn.setValue(this.field_23_Edn, by);
    }

    @Internal
    public byte getRncEdn() {
        return (byte)rncEdn.getValue(this.field_23_Edn);
    }

    @Internal
    public void setNEdn(short s) {
        this.field_23_Edn = (short)nEdn.setValue(this.field_23_Edn, s);
    }

    @Internal
    public short getNEdn() {
        return (short)nEdn.getValue(this.field_23_Edn);
    }

    @Internal
    public void setEpc(byte by) {
        this.field_24_Edn1 = (short)epc.setValue(this.field_24_Edn1, by);
    }

    @Internal
    public byte getEpc() {
        return (byte)epc.getValue(this.field_24_Edn1);
    }

    @Internal
    public void setNfcFtnRef1(byte by) {
        this.field_24_Edn1 = (short)nfcFtnRef1.setValue(this.field_24_Edn1, by);
    }

    @Internal
    public byte getNfcFtnRef1() {
        return (byte)nfcFtnRef1.getValue(this.field_24_Edn1);
    }

    @Internal
    public void setNfcEdnRef1(byte by) {
        this.field_24_Edn1 = (short)nfcEdnRef1.setValue(this.field_24_Edn1, by);
    }

    @Internal
    public byte getNfcEdnRef1() {
        return (byte)nfcEdnRef1.getValue(this.field_24_Edn1);
    }

    @Internal
    public void setFPrintFormData(boolean bl) {
        this.field_24_Edn1 = (short)fPrintFormData.setBoolean(this.field_24_Edn1, bl);
    }

    @Internal
    public boolean isFPrintFormData() {
        return fPrintFormData.isSet(this.field_24_Edn1);
    }

    @Internal
    public void setFSaveFormData(boolean bl) {
        this.field_24_Edn1 = (short)fSaveFormData.setBoolean(this.field_24_Edn1, bl);
    }

    @Internal
    public boolean isFSaveFormData() {
        return fSaveFormData.isSet(this.field_24_Edn1);
    }

    @Internal
    public void setFShadeFormData(boolean bl) {
        this.field_24_Edn1 = (short)fShadeFormData.setBoolean(this.field_24_Edn1, bl);
    }

    @Internal
    public boolean isFShadeFormData() {
        return fShadeFormData.isSet(this.field_24_Edn1);
    }

    @Internal
    public void setFWCFtnEdn(boolean bl) {
        this.field_24_Edn1 = (short)fWCFtnEdn.setBoolean(this.field_24_Edn1, bl);
    }

    @Internal
    public boolean isFWCFtnEdn() {
        return fWCFtnEdn.isSet(this.field_24_Edn1);
    }

    @Internal
    public void setWvkSaved(byte by) {
        this.field_32_view = (short)wvkSaved.setValue(this.field_32_view, by);
    }

    @Internal
    public byte getWvkSaved() {
        return (byte)wvkSaved.getValue(this.field_32_view);
    }

    @Internal
    public void setWScaleSaved(short s) {
        this.field_32_view = (short)wScaleSaved.setValue(this.field_32_view, s);
    }

    @Internal
    public short getWScaleSaved() {
        return (short)wScaleSaved.getValue(this.field_32_view);
    }

    @Internal
    public void setZkSaved(byte by) {
        this.field_32_view = (short)zkSaved.setValue(this.field_32_view, by);
    }

    @Internal
    public byte getZkSaved() {
        return (byte)zkSaved.getValue(this.field_32_view);
    }

    @Internal
    public void setFRotateFontW6(boolean bl) {
        this.field_32_view = (short)fRotateFontW6.setBoolean(this.field_32_view, bl);
    }

    @Internal
    public boolean isFRotateFontW6() {
        return fRotateFontW6.isSet(this.field_32_view);
    }

    @Internal
    public void setIGutterPos(boolean bl) {
        this.field_32_view = (short)iGutterPos.setBoolean(this.field_32_view, bl);
    }

    @Internal
    public boolean isIGutterPos() {
        return iGutterPos.isSet(this.field_32_view);
    }

    @Internal
    public void setFNoTabForInd(boolean bl) {
        this.field_33_docinfo4 = fNoTabForInd.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFNoTabForInd() {
        return fNoTabForInd.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFNoSpaceRaiseLower(boolean bl) {
        this.field_33_docinfo4 = fNoSpaceRaiseLower.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFNoSpaceRaiseLower() {
        return fNoSpaceRaiseLower.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFSupressSpdfAfterPageBreak(boolean bl) {
        this.field_33_docinfo4 = fSupressSpdfAfterPageBreak.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFSupressSpdfAfterPageBreak() {
        return fSupressSpdfAfterPageBreak.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFWrapTrailSpaces(boolean bl) {
        this.field_33_docinfo4 = fWrapTrailSpaces.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFWrapTrailSpaces() {
        return fWrapTrailSpaces.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFMapPrintTextColor(boolean bl) {
        this.field_33_docinfo4 = fMapPrintTextColor.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFMapPrintTextColor() {
        return fMapPrintTextColor.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFNoColumnBalance(boolean bl) {
        this.field_33_docinfo4 = fNoColumnBalance.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFNoColumnBalance() {
        return fNoColumnBalance.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFConvMailMergeEsc(boolean bl) {
        this.field_33_docinfo4 = fConvMailMergeEsc.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFConvMailMergeEsc() {
        return fConvMailMergeEsc.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFSupressTopSpacing(boolean bl) {
        this.field_33_docinfo4 = fSupressTopSpacing.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFSupressTopSpacing() {
        return fSupressTopSpacing.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFOrigWordTableRules(boolean bl) {
        this.field_33_docinfo4 = fOrigWordTableRules.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFOrigWordTableRules() {
        return fOrigWordTableRules.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFTransparentMetafiles(boolean bl) {
        this.field_33_docinfo4 = fTransparentMetafiles.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFTransparentMetafiles() {
        return fTransparentMetafiles.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFShowBreaksInFrames(boolean bl) {
        this.field_33_docinfo4 = fShowBreaksInFrames.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFShowBreaksInFrames() {
        return fShowBreaksInFrames.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFSwapBordersFacingPgs(boolean bl) {
        this.field_33_docinfo4 = fSwapBordersFacingPgs.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFSwapBordersFacingPgs() {
        return fSwapBordersFacingPgs.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFSuppressTopSPacingMac5(boolean bl) {
        this.field_33_docinfo4 = fSuppressTopSPacingMac5.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFSuppressTopSPacingMac5() {
        return fSuppressTopSPacingMac5.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFTruncDxaExpand(boolean bl) {
        this.field_33_docinfo4 = fTruncDxaExpand.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFTruncDxaExpand() {
        return fTruncDxaExpand.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFPrintBodyBeforeHdr(boolean bl) {
        this.field_33_docinfo4 = fPrintBodyBeforeHdr.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFPrintBodyBeforeHdr() {
        return fPrintBodyBeforeHdr.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFNoLeading(boolean bl) {
        this.field_33_docinfo4 = fNoLeading.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFNoLeading() {
        return fNoLeading.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setFMWSmallCaps(boolean bl) {
        this.field_33_docinfo4 = fMWSmallCaps.setBoolean(this.field_33_docinfo4, bl);
    }

    @Internal
    public boolean isFMWSmallCaps() {
        return fMWSmallCaps.isSet(this.field_33_docinfo4);
    }

    @Internal
    public void setLvl(byte by) {
        this.field_37_docinfo5 = (short)lvl.setValue(this.field_37_docinfo5, by);
    }

    @Internal
    public byte getLvl() {
        return (byte)lvl.getValue(this.field_37_docinfo5);
    }

    @Internal
    public void setFGramAllDone(boolean bl) {
        this.field_37_docinfo5 = (short)fGramAllDone.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFGramAllDone() {
        return fGramAllDone.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFGramAllClean(boolean bl) {
        this.field_37_docinfo5 = (short)fGramAllClean.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFGramAllClean() {
        return fGramAllClean.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFSubsetFonts(boolean bl) {
        this.field_37_docinfo5 = (short)fSubsetFonts.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFSubsetFonts() {
        return fSubsetFonts.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFHideLastVersion(boolean bl) {
        this.field_37_docinfo5 = (short)fHideLastVersion.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFHideLastVersion() {
        return fHideLastVersion.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFHtmlDoc(boolean bl) {
        this.field_37_docinfo5 = (short)fHtmlDoc.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFHtmlDoc() {
        return fHtmlDoc.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFSnapBorder(boolean bl) {
        this.field_37_docinfo5 = (short)fSnapBorder.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFSnapBorder() {
        return fSnapBorder.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFIncludeHeader(boolean bl) {
        this.field_37_docinfo5 = (short)fIncludeHeader.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFIncludeHeader() {
        return fIncludeHeader.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFIncludeFooter(boolean bl) {
        this.field_37_docinfo5 = (short)fIncludeFooter.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFIncludeFooter() {
        return fIncludeFooter.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFForcePageSizePag(boolean bl) {
        this.field_37_docinfo5 = (short)fForcePageSizePag.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFForcePageSizePag() {
        return fForcePageSizePag.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFMinFontSizePag(boolean bl) {
        this.field_37_docinfo5 = (short)fMinFontSizePag.setBoolean(this.field_37_docinfo5, bl);
    }

    @Internal
    public boolean isFMinFontSizePag() {
        return fMinFontSizePag.isSet(this.field_37_docinfo5);
    }

    @Internal
    public void setFHaveVersions(boolean bl) {
        this.field_38_docinfo6 = (short)fHaveVersions.setBoolean(this.field_38_docinfo6, bl);
    }

    @Internal
    public boolean isFHaveVersions() {
        return fHaveVersions.isSet(this.field_38_docinfo6);
    }

    @Internal
    public void setFAutoVersions(boolean bl) {
        this.field_38_docinfo6 = (short)fAutoVersions.setBoolean(this.field_38_docinfo6, bl);
    }

    @Internal
    public boolean isFAutoVersions() {
        return fAutoVersions.isSet(this.field_38_docinfo6);
    }

    @Internal
    public void setFVirusPrompted(boolean bl) {
        this.field_43_virusinfo = fVirusPrompted.setBoolean(this.field_43_virusinfo, bl);
    }

    @Internal
    public boolean isFVirusPrompted() {
        return fVirusPrompted.isSet(this.field_43_virusinfo);
    }

    @Internal
    public void setFVirusLoadSafe(boolean bl) {
        this.field_43_virusinfo = fVirusLoadSafe.setBoolean(this.field_43_virusinfo, bl);
    }

    @Internal
    public boolean isFVirusLoadSafe() {
        return fVirusLoadSafe.isSet(this.field_43_virusinfo);
    }

    @Internal
    public void setKeyVirusSession30(int n) {
        this.field_43_virusinfo = KeyVirusSession30.setValue(this.field_43_virusinfo, n);
    }

    @Internal
    public int getKeyVirusSession30() {
        return KeyVirusSession30.getValue(this.field_43_virusinfo);
    }
}

