/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model.types;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public abstract class BKFAbstractType {
    protected short field_1_ibkl;
    protected short field_2_bkf_flags;
    private static BitField itcFirst = new BitField(127);
    private static BitField fPub = new BitField(128);
    private static BitField itcLim = new BitField(32512);
    private static BitField fCol = new BitField(32768);

    protected BKFAbstractType() {
    }

    protected void fillFields(byte[] byArray, int n) {
        this.field_1_ibkl = LittleEndian.getShort(byArray, 0 + n);
        this.field_2_bkf_flags = LittleEndian.getShort(byArray, 2 + n);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, 0 + n, this.field_1_ibkl);
        LittleEndian.putShort(byArray, 2 + n, this.field_2_bkf_flags);
    }

    public static int getSize() {
        return 4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[BKF]\n");
        stringBuilder.append("    .ibkl                 = ");
        stringBuilder.append(" (").append(this.getIbkl()).append(" )\n");
        stringBuilder.append("    .bkf_flags            = ");
        stringBuilder.append(" (").append(this.getBkf_flags()).append(" )\n");
        stringBuilder.append("         .itcFirst                 = ").append(this.getItcFirst()).append('\n');
        stringBuilder.append("         .fPub                     = ").append(this.isFPub()).append('\n');
        stringBuilder.append("         .itcLim                   = ").append(this.getItcLim()).append('\n');
        stringBuilder.append("         .fCol                     = ").append(this.isFCol()).append('\n');
        stringBuilder.append("[/BKF]\n");
        return stringBuilder.toString();
    }

    public short getIbkl() {
        return this.field_1_ibkl;
    }

    public void setIbkl(short s) {
        this.field_1_ibkl = s;
    }

    public short getBkf_flags() {
        return this.field_2_bkf_flags;
    }

    public void setBkf_flags(short s) {
        this.field_2_bkf_flags = s;
    }

    public void setItcFirst(byte by) {
        this.field_2_bkf_flags = (short)itcFirst.setValue(this.field_2_bkf_flags, by);
    }

    public byte getItcFirst() {
        return (byte)itcFirst.getValue(this.field_2_bkf_flags);
    }

    public void setFPub(boolean bl) {
        this.field_2_bkf_flags = (short)fPub.setBoolean(this.field_2_bkf_flags, bl);
    }

    public boolean isFPub() {
        return fPub.isSet(this.field_2_bkf_flags);
    }

    public void setItcLim(byte by) {
        this.field_2_bkf_flags = (short)itcLim.setValue(this.field_2_bkf_flags, by);
    }

    public byte getItcLim() {
        return (byte)itcLim.getValue(this.field_2_bkf_flags);
    }

    public void setFCol(boolean bl) {
        this.field_2_bkf_flags = (short)fCol.setBoolean(this.field_2_bkf_flags, bl);
    }

    public boolean isFCol() {
        return fCol.isSet(this.field_2_bkf_flags);
    }
}

