/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.Xst;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;

@Internal
public class Xstz {
    private static final POILogger log = POILogFactory.getLogger(Xstz.class);
    private final short _chTerm = 0;
    private Xst _xst;

    public Xstz() {
        this._xst = new Xst();
    }

    public Xstz(byte[] byArray, int n) {
        this.fillFields(byArray, n);
    }

    public void fillFields(byte[] byArray, int n) {
        int n2 = n;
        this._xst = new Xst(byArray, n2);
        short s = LittleEndian.getShort(byArray, n2 += this._xst.getSize());
        if (s != 0 && log.check(5)) {
            log.log(5, "chTerm at the end of Xstz at offset ", n2, " is not 0");
        }
    }

    public String getAsJavaString() {
        return this._xst.getAsJavaString();
    }

    public int getSize() {
        return this._xst.getSize() + 2;
    }

    public int serialize(byte[] byArray, int n) {
        int n2 = n;
        this._xst.serialize(byArray, n2);
        LittleEndian.putUShort(byArray, n2 += this._xst.getSize(), 0);
        return (n2 += 2) - n;
    }

    public String toString() {
        return "[Xstz]" + this._xst.getAsJavaString() + "[/Xstz]";
    }
}

