/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.PieceDescriptor;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.util.Internal;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class TextPiece
extends PropertyNode<TextPiece> {
    private boolean _usesUnicode;
    private PieceDescriptor _pd;

    public TextPiece(int n, int n2, byte[] byArray, PieceDescriptor pieceDescriptor, int n3) {
        this(n, n2, byArray, pieceDescriptor);
    }

    public TextPiece(int n, int n2, byte[] byArray, PieceDescriptor pieceDescriptor) {
        super(n, n2, TextPiece.buildInitSB(byArray, pieceDescriptor));
        this._usesUnicode = pieceDescriptor.isUnicode();
        this._pd = pieceDescriptor;
        int n3 = ((CharSequence)this._buf).length();
        if (n2 - n != n3) {
            throw new IllegalStateException("Told we're for characters " + n + " -> " + n2 + ", but actually covers " + n3 + " characters!");
        }
        if (n2 < n) {
            throw new IllegalStateException("Told we're of negative size! start=" + n + " end=" + n2);
        }
    }

    private static StringBuilder buildInitSB(byte[] byArray, PieceDescriptor pieceDescriptor) {
        String string = new String(byArray, Charset.forName(pieceDescriptor.isUnicode() ? "UTF-16LE" : "Cp1252"));
        return new StringBuilder(string);
    }

    public boolean isUnicode() {
        return this._usesUnicode;
    }

    public PieceDescriptor getPieceDescriptor() {
        return this._pd;
    }

    @Deprecated
    public StringBuffer getStringBuffer() {
        return new StringBuffer(this.getStringBuilder());
    }

    public StringBuilder getStringBuilder() {
        return (StringBuilder)this._buf;
    }

    public byte[] getRawBytes() {
        return ((CharSequence)this._buf).toString().getBytes(Charset.forName(this._usesUnicode ? "UTF-16LE" : "Cp1252"));
    }

    @Deprecated
    public String substring(int n, int n2) {
        StringBuilder stringBuilder = (StringBuilder)this._buf;
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("Can't request a substring before 0 - asked for " + n);
        }
        if (n2 > stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("Index " + n2 + " out of range 0 -> " + stringBuilder.length());
        }
        if (n2 < n) {
            throw new StringIndexOutOfBoundsException("Asked for text from " + n + " to " + n2 + ", which has an end before the start!");
        }
        return stringBuilder.substring(n, n2);
    }

    @Override
    @Deprecated
    public void adjustForDelete(int n, int n2) {
        int n3 = n2;
        int n4 = this.getStart();
        int n5 = this.getEnd();
        int n6 = n + n3;
        if (n <= n5 && n6 >= n4) {
            int n7 = Math.max(n4, n);
            int n8 = Math.min(n5, n6);
            int n9 = n7 - n4;
            int n10 = n8 - n4;
            ((StringBuilder)this._buf).delete(n9, n10);
        }
        super.adjustForDelete(n, n2);
    }

    @Deprecated
    public int characterLength() {
        return this.getEnd() - this.getStart();
    }

    public int bytesLength() {
        return (this.getEnd() - this.getStart()) * (this._usesUnicode ? 2 : 1);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TextPiece)) {
            return false;
        }
        TextPiece textPiece = (TextPiece)object;
        assert (this._buf != null && textPiece._buf != null && this._pd != null && textPiece._pd != null);
        return this.limitsAreEqual(object) && textPiece._usesUnicode == this._usesUnicode && textPiece._buf.toString().equals(this._buf.toString()) && textPiece._pd.equals(this._pd);
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public int getCP() {
        return this.getStart();
    }

    public String toString() {
        return "TextPiece from " + this.getStart() + " to " + this.getEnd() + " (" + this.getPieceDescriptor() + ")";
    }
}

