/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.HDFType;
import ai2.org.apache.poi.hwpf.model.StdfBase;
import ai2.org.apache.poi.hwpf.model.StdfPost2000;
import ai2.org.apache.poi.hwpf.model.UPX;
import ai2.org.apache.poi.hwpf.usermodel.CharacterProperties;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.StringUtil;
import java.util.Arrays;

@Internal
public final class StyleDescription
implements HDFType {
    private static final POILogger logger = POILogFactory.getLogger(StyleDescription.class);
    private static final int PARAGRAPH_STYLE = 1;
    private static final int CHARACTER_STYLE = 2;
    private int _baseLength;
    private StdfBase _stdfBase;
    private StdfPost2000 _stdfPost2000;
    UPX[] _upxs;
    String _name;
    @Deprecated
    ParagraphProperties _pap;
    @Deprecated
    CharacterProperties _chp;

    public StyleDescription() {
    }

    public StyleDescription(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        this._baseLength = n;
        int n4 = n2 + n;
        boolean bl2 = false;
        if (n == 18) {
            bl2 = true;
        } else if (n == 10) {
            bl2 = false;
        } else {
            logger.log(5, "Style definition has non-standard size of ", n);
        }
        this._stdfBase = new StdfBase(byArray, n2);
        n2 += StdfBase.getSize();
        if (bl2) {
            this._stdfPost2000 = new StdfPost2000(byArray, n2);
        }
        short s = 0;
        int n5 = 1;
        if (bl) {
            s = LittleEndian.getShort(byArray, n4);
            n5 = 2;
            n4 += 2;
        } else {
            s = byArray[n4];
        }
        this._name = StringUtil.getFromUnicodeLE(byArray, n4, s * n5 / 2);
        int n6 = n3 = (s + 1) * n5 + n4;
        int n7 = this._stdfBase.getCupx();
        this._upxs = new UPX[n7];
        for (int i = 0; i < n7; ++i) {
            short s2 = LittleEndian.getShort(byArray, n6);
            byte[] byArray2 = new byte[s2];
            System.arraycopy(byArray, n6 += 2, byArray2, 0, s2);
            this._upxs[i] = new UPX(byArray2);
            n6 += s2;
            if (s2 % 2 != 1) continue;
            ++n6;
        }
    }

    public int getBaseStyle() {
        return this._stdfBase.getIstdBase();
    }

    public byte[] getCHPX() {
        switch (this._stdfBase.getStk()) {
            case 1: {
                if (this._upxs.length > 1) {
                    return this._upxs[1].getUPX();
                }
                return null;
            }
            case 2: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    public byte[] getPAPX() {
        switch (this._stdfBase.getStk()) {
            case 1: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    @Deprecated
    public ParagraphProperties getPAP() {
        return this._pap;
    }

    @Deprecated
    public CharacterProperties getCHP() {
        return this._chp;
    }

    @Deprecated
    void setPAP(ParagraphProperties paragraphProperties) {
        this._pap = paragraphProperties;
    }

    @Deprecated
    void setCHP(CharacterProperties characterProperties) {
        this._chp = characterProperties;
    }

    public String getName() {
        return this._name;
    }

    public byte[] toByteArray() {
        int n;
        int n2 = this._baseLength + 2 + (this._name.length() + 1) * 2;
        n2 += this._upxs[0].size() + 2;
        for (int i = 1; i < this._upxs.length; ++i) {
            n2 += this._upxs[i - 1].size() % 2;
            n2 += this._upxs[i].size() + 2;
        }
        byte[] byArray = new byte[n2];
        this._stdfBase.serialize(byArray, 0);
        int n3 = this._baseLength;
        char[] cArray = this._name.toCharArray();
        LittleEndian.putShort(byArray, this._baseLength, (short)cArray.length);
        n3 += 2;
        for (n = 0; n < cArray.length; ++n) {
            LittleEndian.putShort(byArray, n3, (short)cArray[n]);
            n3 += 2;
        }
        n3 += 2;
        for (n = 0; n < this._upxs.length; ++n) {
            short s = (short)this._upxs[n].size();
            LittleEndian.putShort(byArray, n3, s);
            System.arraycopy(this._upxs[n].getUPX(), 0, byArray, n3 += 2, s);
            n3 += s + s % 2;
        }
        return byArray;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._name == null ? 0 : this._name.hashCode());
        n = 31 * n + (this._stdfBase == null ? 0 : this._stdfBase.hashCode());
        n = 31 * n + Arrays.hashCode(this._upxs);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StyleDescription styleDescription = (StyleDescription)object;
        if (this._name == null ? styleDescription._name != null : !this._name.equals(styleDescription._name)) {
            return false;
        }
        if (this._stdfBase == null ? styleDescription._stdfBase != null : !this._stdfBase.equals(styleDescription._stdfBase)) {
            return false;
        }
        return Arrays.equals(this._upxs, styleDescription._upxs);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[STD]: '");
        stringBuilder.append(this._name);
        stringBuilder.append("'");
        stringBuilder.append(("\nStdfBase:\t" + this._stdfBase).replaceAll("\n", "\n    "));
        stringBuilder.append(("\nStdfPost2000:\t" + this._stdfPost2000).replaceAll("\n", "\n    "));
        for (UPX uPX : this._upxs) {
            stringBuilder.append(("\nUPX:\t" + uPX).replaceAll("\n", "\n    "));
        }
        return stringBuilder.toString();
    }
}

