/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.util.Arrays;

public class Sttb {
    private int _cbExtra;
    private final int _cDataLength;
    private String[] _data;
    private byte[][] _extraData;
    private final boolean _fExtend = true;

    public Sttb(byte[] byArray, int n) {
        this(2, byArray, n);
    }

    public Sttb(int n, byte[] byArray, int n2) {
        this._cDataLength = n;
        this.fillFields(byArray, n2);
    }

    public Sttb(int n, String[] stringArray) {
        this._cDataLength = n;
        this._data = Arrays.copyOf(stringArray, stringArray.length);
        this._cbExtra = 0;
        this._extraData = null;
    }

    public void fillFields(byte[] byArray, int n) {
        short s = LittleEndian.getShort(byArray, n);
        int n2 = n + 2;
        if (s != -1) {
            throw new UnsupportedOperationException("Non-extended character Pascal strings are not supported right now. Please, contact POI developers for update.");
        }
        int n3 = this._cDataLength == 2 ? LittleEndian.getUShort(byArray, n2) : LittleEndian.getInt(byArray, n2);
        this._cbExtra = LittleEndian.getUShort(byArray, n2 += this._cDataLength);
        n2 += 2;
        this._data = new String[n3];
        this._extraData = new byte[n3][];
        for (int i = 0; i < n3; ++i) {
            short s2 = LittleEndian.getShort(byArray, n2);
            n2 += 2;
            if (s2 < 0) continue;
            this._data[i] = StringUtil.getFromUnicodeLE(byArray, n2, s2);
            this._extraData[i] = LittleEndian.getByteArray(byArray, n2 += s2 * 2, this._cbExtra);
            n2 += this._cbExtra;
        }
    }

    public String[] getData() {
        return this._data;
    }

    public int getSize() {
        int n = 2;
        n += this._cDataLength;
        n += 2;
        this.getClass();
        for (String string : this._data) {
            n += 2;
            n += 2 * string.length();
        }
        if (this._extraData != null) {
            n += this._cbExtra * this._data.length;
        }
        return n;
    }

    public byte[] serialize() {
        int n;
        byte[] byArray = new byte[this.getSize()];
        LittleEndian.putShort(byArray, 0, (short)-1);
        if (this._data == null || this._data.length == 0) {
            if (this._cDataLength == 4) {
                LittleEndian.putInt(byArray, 2, 0);
                LittleEndian.putUShort(byArray, 6, this._cbExtra);
                return byArray;
            }
            LittleEndian.putUShort(byArray, 2, 0);
            LittleEndian.putUShort(byArray, 4, this._cbExtra);
            return byArray;
        }
        if (this._cDataLength == 4) {
            LittleEndian.putInt(byArray, 2, this._data.length);
            LittleEndian.putUShort(byArray, 6, this._cbExtra);
            n = 8;
        } else {
            LittleEndian.putUShort(byArray, 2, this._data.length);
            LittleEndian.putUShort(byArray, 4, this._cbExtra);
            n = 6;
        }
        for (int i = 0; i < this._data.length; ++i) {
            String string = this._data[i];
            if (string == null) {
                byArray[n] = -1;
                byArray[n + 1] = 0;
                n += 2;
                continue;
            }
            LittleEndian.putUShort(byArray, n, string.length());
            StringUtil.putUnicodeLE(string, byArray, n += 2);
            n += 2 * string.length();
            if (this._cbExtra == 0) continue;
            if (this._extraData[i] != null && this._extraData[i].length != 0) {
                System.arraycopy(this._extraData[i], 0, byArray, n, Math.min(this._extraData[i].length, this._cbExtra));
            }
            n += this._cbExtra;
        }
        return byArray;
    }

    public int serialize(byte[] byArray, int n) {
        byte[] byArray2 = this.serialize();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }
}

