/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.SttbUtils;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class RevisionMarkAuthorTable {
    private String[] entries;

    public RevisionMarkAuthorTable(byte[] byArray, int n, int n2) throws IOException {
        this.entries = SttbUtils.readSttbfRMark(byArray, n);
    }

    public List<String> getEntries() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public String getAuthor(int n) {
        String string = null;
        if (n >= 0 && n < this.entries.length) {
            string = this.entries[n];
        }
        return string;
    }

    public int getSize() {
        return this.entries.length;
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        SttbUtils.writeSttbfRMark(this.entries, hWPFOutputStream);
    }
}

