/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public abstract class PropertyNode<T extends PropertyNode<T>>
implements Comparable<T>,
Cloneable {
    private static final POILogger _logger = POILogFactory.getLogger(PropertyNode.class);
    protected Object _buf;
    private int _cpStart;
    private int _cpEnd;

    protected PropertyNode(int n, int n2, Object object) {
        this._cpStart = n;
        this._cpEnd = n2;
        this._buf = object;
        if (this._cpStart < 0) {
            _logger.log(5, new Object[]{"A property claimed to start before zero, at " + this._cpStart + "! Resetting it to zero, and hoping for the best"});
            this._cpStart = 0;
        }
        if (this._cpEnd < this._cpStart) {
            _logger.log(5, new Object[]{"A property claimed to end (" + this._cpEnd + ") before start! " + "Resetting end to start, and hoping for the best"});
            this._cpEnd = this._cpStart;
        }
    }

    public int getStart() {
        return this._cpStart;
    }

    public void setStart(int n) {
        this._cpStart = n;
    }

    public int getEnd() {
        return this._cpEnd;
    }

    public void setEnd(int n) {
        this._cpEnd = n;
    }

    public void adjustForDelete(int n, int n2) {
        int n3 = n + n2;
        if (this._cpEnd > n) {
            if (this._cpStart < n3) {
                this._cpEnd = n3 >= this._cpEnd ? n : this._cpEnd - n2;
                this._cpStart = Math.min(n, this._cpStart);
            } else {
                this._cpEnd -= n2;
                this._cpStart -= n2;
            }
        }
    }

    protected boolean limitsAreEqual(Object object) {
        return ((PropertyNode)object).getStart() == this._cpStart && ((PropertyNode)object).getEnd() == this._cpEnd;
    }

    public int hashCode() {
        return this._cpStart * 31 + this._buf.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertyNode)) {
            return false;
        }
        if (this.limitsAreEqual(object)) {
            Object object2 = ((PropertyNode)object)._buf;
            if (object2 instanceof byte[] && this._buf instanceof byte[]) {
                return Arrays.equals((byte[])object2, (byte[])this._buf);
            }
            return this._buf.equals(object2);
        }
        return false;
    }

    public T clone() throws CloneNotSupportedException {
        return (T)((PropertyNode)super.clone());
    }

    @Override
    public int compareTo(T t) {
        int n = ((PropertyNode)t).getEnd();
        if (this._cpEnd == n) {
            return 0;
        }
        if (this._cpEnd < n) {
            return -1;
        }
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StartComparator
    implements Comparator<PropertyNode<?>> {
        public static final StartComparator instance = new StartComparator();

        @Override
        public int compare(PropertyNode<?> propertyNode, PropertyNode<?> propertyNode2) {
            int n;
            int n2 = propertyNode.getStart();
            return n2 < (n = propertyNode2.getStart()) ? -1 : (n2 == n ? 0 : 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EndComparator
    implements Comparator<PropertyNode<?>> {
        public static final EndComparator instance = new EndComparator();

        @Override
        public int compare(PropertyNode<?> propertyNode, PropertyNode<?> propertyNode2) {
            int n;
            int n2 = propertyNode.getEnd();
            return n2 < (n = propertyNode2.getEnd()) ? -1 : (n2 == n ? 0 : 1);
        }
    }
}

