/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.LFO;
import ai2.org.apache.poi.hwpf.model.LFOData;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class PlfLfo {
    private static POILogger log = POILogFactory.getLogger(PlfLfo.class);
    private int _lfoMac;
    private LFO[] _rgLfo;
    private LFOData[] _rgLfoData;

    PlfLfo(byte[] byArray, int n, int n2) {
        Object object;
        int n3;
        int n4 = n;
        long l = LittleEndian.getUInt(byArray, n4);
        n4 += 4;
        if (l > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Apache POI doesn't support rgLfo/rgLfoData size large than 2147483647 elements");
        }
        this._lfoMac = (int)l;
        this._rgLfo = new LFO[this._lfoMac];
        this._rgLfoData = new LFOData[this._lfoMac];
        for (n3 = 0; n3 < this._lfoMac; ++n3) {
            object = new LFO(byArray, n4);
            n4 += LFO.getSize();
            this._rgLfo[n3] = object;
        }
        for (n3 = 0; n3 < this._lfoMac; ++n3) {
            object = new LFOData(byArray, n4, this._rgLfo[n3].getClfolvl());
            n4 += ((LFOData)object).getSizeInBytes();
            this._rgLfoData[n3] = object;
        }
        if (n4 - n != n2 && log.check(5)) {
            log.log(5, new Object[]{"Actual size of PlfLfo is " + (n4 - n) + " bytes, but expected " + n2});
        }
    }

    void add(LFO lFO, LFOData lFOData) {
        int n = this._lfoMac + 1;
        this._rgLfo = Arrays.copyOf(this._rgLfo, n);
        this._rgLfo[this._lfoMac + 1] = lFO;
        this._rgLfoData = Arrays.copyOf(this._rgLfoData, n);
        this._rgLfoData[this._lfoMac + 1] = lFOData;
        this._lfoMac = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlfLfo plfLfo = (PlfLfo)object;
        if (this._lfoMac != plfLfo._lfoMac) {
            return false;
        }
        if (!Arrays.equals(this._rgLfo, plfLfo._rgLfo)) {
            return false;
        }
        return Arrays.equals(this._rgLfoData, plfLfo._rgLfoData);
    }

    public int getLfoMac() {
        return this._lfoMac;
    }

    public int getIlfoByLsid(int n) {
        for (int i = 0; i < this._lfoMac; ++i) {
            if (this._rgLfo[i].getLsid() != n) continue;
            return i + 1;
        }
        throw new NoSuchElementException("LFO with lsid " + n + " not found");
    }

    public LFO getLfo(int n) throws NoSuchElementException {
        if (n <= 0 || n > this._lfoMac) {
            throw new NoSuchElementException("LFO with ilfo " + n + " not found. lfoMac is " + this._lfoMac);
        }
        return this._rgLfo[n - 1];
    }

    public LFOData getLfoData(int n) throws NoSuchElementException {
        if (n <= 0 || n > this._lfoMac) {
            throw new NoSuchElementException("LFOData with ilfo " + n + " not found. lfoMac is " + this._lfoMac);
        }
        return this._rgLfoData[n - 1];
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._lfoMac;
        n = 31 * n + Arrays.hashCode(this._rgLfo);
        n = 31 * n + Arrays.hashCode(this._rgLfoData);
        return n;
    }

    void writeTo(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        int n;
        int n2 = hWPFOutputStream.getOffset();
        fileInformationBlock.setFcPlfLfo(n2);
        LittleEndian.putUInt(this._lfoMac, hWPFOutputStream);
        byte[] byArray = new byte[LFO.getSize() * this._lfoMac];
        for (n = 0; n < this._lfoMac; ++n) {
            this._rgLfo[n].serialize(byArray, n * LFO.getSize());
        }
        hWPFOutputStream.write(byArray, 0, LFO.getSize() * this._lfoMac);
        for (n = 0; n < this._lfoMac; ++n) {
            this._rgLfoData[n].writeTo(hWPFOutputStream);
        }
        fileInformationBlock.setLcbPlfLfo(hWPFOutputStream.getOffset() - n2);
    }
}

