/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;

public final class PlexOfCps {
    private int _iMac;
    private int _offset;
    private int _cbStruct;
    private ArrayList<GenericPropertyNode> _props;

    public PlexOfCps(int n) {
        this._props = new ArrayList();
        this._cbStruct = n;
    }

    public PlexOfCps(byte[] byArray, int n, int n2, int n3) {
        this._iMac = (n2 - 4) / (4 + n3);
        this._cbStruct = n3;
        this._props = new ArrayList(this._iMac);
        for (int i = 0; i < this._iMac; ++i) {
            this._props.add(this.getProperty(i, byArray, n));
        }
    }

    @Internal
    void adjust(int n, int n2) {
        for (GenericPropertyNode genericPropertyNode : this._props) {
            if (genericPropertyNode.getStart() > n) {
                if (genericPropertyNode.getStart() + n2 < n) {
                    genericPropertyNode.setStart(n);
                } else {
                    genericPropertyNode.setStart(genericPropertyNode.getStart() + n2);
                }
            }
            if (genericPropertyNode.getEnd() < n) continue;
            if (genericPropertyNode.getEnd() + n2 < n) {
                genericPropertyNode.setEnd(n);
                continue;
            }
            genericPropertyNode.setEnd(genericPropertyNode.getEnd() + n2);
        }
    }

    public GenericPropertyNode getProperty(int n) {
        return this._props.get(n);
    }

    public void addProperty(GenericPropertyNode genericPropertyNode) {
        this._props.add(genericPropertyNode);
        ++this._iMac;
    }

    void remove(int n) {
        this._props.remove(n);
        --this._iMac;
    }

    public byte[] toByteArray() {
        int n = this._props.size();
        int n2 = (n + 1) * 4;
        int n3 = this._cbStruct * n;
        int n4 = n2 + n3;
        byte[] byArray = new byte[n4];
        GenericPropertyNode genericPropertyNode = null;
        for (int i = 0; i < n; ++i) {
            genericPropertyNode = this._props.get(i);
            LittleEndian.putInt(byArray, 4 * i, genericPropertyNode.getStart());
            System.arraycopy(genericPropertyNode.getBytes(), 0, byArray, n2 + i * this._cbStruct, this._cbStruct);
        }
        LittleEndian.putInt(byArray, 4 * n, genericPropertyNode.getEnd());
        return byArray;
    }

    private GenericPropertyNode getProperty(int n, byte[] byArray, int n2) {
        int n3 = LittleEndian.getInt(byArray, n2 + this.getIntOffset(n));
        int n4 = LittleEndian.getInt(byArray, n2 + this.getIntOffset(n + 1));
        byte[] byArray2 = new byte[this._cbStruct];
        System.arraycopy(byArray, n2 + this.getStructOffset(n), byArray2, 0, this._cbStruct);
        return new GenericPropertyNode(n3, n4, byArray2);
    }

    private int getIntOffset(int n) {
        return n * 4;
    }

    public int length() {
        return this._iMac;
    }

    private int getStructOffset(int n) {
        return 4 * (this._iMac + 1) + this._cbStruct * n;
    }

    GenericPropertyNode[] toPropertiesArray() {
        if (this._props == null || this._props.isEmpty()) {
            return new GenericPropertyNode[0];
        }
        return this._props.toArray(new GenericPropertyNode[this._props.size()]);
    }

    public String toString() {
        return "PLCF (cbStruct: " + this._cbStruct + "; iMac: " + this._iMac + ")";
    }
}

