/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hwpf.model.PICF;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class PICFAndOfficeArtData {
    private List<EscherRecord> _blipRecords;
    private short _cchPicName;
    private PICF _picf;
    private EscherContainerRecord _shape;
    private byte[] _stPicName;

    public PICFAndOfficeArtData(byte[] byArray, int n) {
        EscherRecord escherRecord;
        int n2 = n;
        this._picf = new PICF(byArray, n2);
        n2 += PICF.getSize();
        if (this._picf.getMm() == 102) {
            this._cchPicName = LittleEndian.getUByte(byArray, n2);
            this._stPicName = LittleEndian.getByteArray(byArray, ++n2, this._cchPicName);
            n2 += this._cchPicName;
        }
        DefaultEscherRecordFactory defaultEscherRecordFactory = new DefaultEscherRecordFactory();
        this._shape = new EscherContainerRecord();
        int n3 = this._shape.fillFields(byArray, n2, defaultEscherRecordFactory);
        n2 += n3;
        this._blipRecords = new LinkedList<EscherRecord>();
        while (n2 - n < this._picf.getLcb() && ((escherRecord = defaultEscherRecordFactory.createRecord(byArray, n2)).getRecordId() == -4089 || escherRecord.getRecordId() >= -4072 && escherRecord.getRecordId() <= -3817)) {
            int n4 = escherRecord.fillFields(byArray, n2, defaultEscherRecordFactory);
            n2 += n4;
            this._blipRecords.add(escherRecord);
        }
    }

    public List<EscherRecord> getBlipRecords() {
        return this._blipRecords;
    }

    public PICF getPicf() {
        return this._picf;
    }

    public EscherContainerRecord getShape() {
        return this._shape;
    }

    public byte[] getStPicName() {
        return this._stPicName;
    }
}

