/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.BytePropertyNode;
import ai2.org.apache.poi.hwpf.model.CharIndexTranslator;
import ai2.org.apache.poi.hwpf.model.ParagraphHeight;
import ai2.org.apache.poi.hwpf.model.StyleSheet;
import ai2.org.apache.poi.hwpf.sprm.ParagraphSprmUncompressor;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class PAPX
extends BytePropertyNode<PAPX> {
    private ParagraphHeight _phe;

    public PAPX(int n, int n2, CharIndexTranslator charIndexTranslator, byte[] byArray, ParagraphHeight paragraphHeight, byte[] byArray2) {
        super(n, n2, charIndexTranslator, new SprmBuffer(byArray, 2));
        this._phe = paragraphHeight;
        SprmBuffer sprmBuffer = this.findHuge(new SprmBuffer(byArray, 2), byArray2);
        if (sprmBuffer != null) {
            this._buf = sprmBuffer;
        }
    }

    public PAPX(int n, int n2, byte[] byArray, ParagraphHeight paragraphHeight, byte[] byArray2) {
        super(n, n2, new SprmBuffer(byArray, 2));
        this._phe = paragraphHeight;
        SprmBuffer sprmBuffer = this.findHuge(new SprmBuffer(byArray, 2), byArray2);
        if (sprmBuffer != null) {
            this._buf = sprmBuffer;
        }
    }

    @Deprecated
    public PAPX(int n, int n2, CharIndexTranslator charIndexTranslator, SprmBuffer sprmBuffer, byte[] byArray) {
        super(n, n2, charIndexTranslator, sprmBuffer);
        this._phe = new ParagraphHeight();
        sprmBuffer = this.findHuge(sprmBuffer, byArray);
        if (sprmBuffer != null) {
            this._buf = sprmBuffer;
        }
    }

    public PAPX(int n, int n2, SprmBuffer sprmBuffer) {
        super(n, n2, sprmBuffer);
        this._phe = new ParagraphHeight();
    }

    private SprmBuffer findHuge(SprmBuffer sprmBuffer, byte[] byArray) {
        short s;
        int n;
        SprmOperation sprmOperation;
        byte[] byArray2 = sprmBuffer.toByteArray();
        if (byArray2.length == 8 && byArray != null && ((sprmOperation = new SprmOperation(byArray2, 2)).getOperation() == 69 || sprmOperation.getOperation() == 70) && sprmOperation.getSizeCode() == 3 && (n = sprmOperation.getOperand()) + 1 < byArray.length && n + (s = LittleEndian.getShort(byArray, n)) < byArray.length) {
            byte[] byArray3 = new byte[s + 2];
            byArray3[0] = byArray2[0];
            byArray3[1] = byArray2[1];
            System.arraycopy(byArray, n + 2, byArray3, 2, s);
            return new SprmBuffer(byArray3, 2);
        }
        return null;
    }

    public ParagraphHeight getParagraphHeight() {
        return this._phe;
    }

    public byte[] getGrpprl() {
        if (this._buf == null) {
            return new byte[0];
        }
        return ((SprmBuffer)this._buf).toByteArray();
    }

    public short getIstd() {
        if (this._buf == null) {
            return 0;
        }
        byte[] byArray = this.getGrpprl();
        if (byArray.length == 0) {
            return 0;
        }
        if (byArray.length == 1) {
            return (short)LittleEndian.getUnsignedByte(byArray, 0);
        }
        return LittleEndian.getShort(byArray);
    }

    public SprmBuffer getSprmBuf() {
        return (SprmBuffer)this._buf;
    }

    @Deprecated
    @Internal
    public ParagraphProperties getParagraphProperties(StyleSheet styleSheet) {
        if (styleSheet == null) {
            return new ParagraphProperties();
        }
        short s = this.getIstd();
        ParagraphProperties paragraphProperties = styleSheet.getParagraphStyle(s);
        ParagraphProperties paragraphProperties2 = ParagraphSprmUncompressor.uncompressPAP(paragraphProperties, this.getGrpprl(), 2);
        return paragraphProperties2;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            return this._phe.equals(((PAPX)object)._phe);
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        return "PAPX from " + this.getStart() + " to " + this.getEnd() + " (in bytes " + this.getStartBytes() + " to " + this.getEndBytes() + ")";
    }
}

